#ifndef MENU_H
#define	MENU_H

#include <xc.h> 
#include "uart.h"
#include "hd44780.h"

//state machine based menu system
//assumes a main menu with numeric selector for main 
//multi-digit numbers (uint/ulong) for individual items
//also has (Y/N) confirmation

#define MENU_COUNT (3)
#define MENU_CONFIRM (0xFF)
#define MENU_CANCEL (0xAA)
#define ESC_KEY (27)
#define CANCEL_KEY (3)

const char menuItems[MENU_COUNT][14]={
    "VREF (mV):   ",
    "Shunt (m\x1):  ",   //ohms symbol is at codepoint 1 in graphics.h
    "Contact (m\x1):"    //ohms symbol is at codepoint 1 in graphics.h
};

unsigned int calValues[MENU_COUNT];

const char menuHeading[]="Main Menu";
const char menuRequest[]="Enter ";
const char menuFirst='1';               //key for first item, eg could be '1' or 'a'

char menuState=0;               //0 is main, 1 is first item etc
char menuWaiting=0;             //is waiting for input, 0 causes menu to be printed on first call
unsigned int menuEntry=0;       //for multi-digit entry
char menuService(void);         //service, call as needed, returns non-zero if item returns a value
unsigned int menuResult=0;      //valid for above
char menuSelection=0;           //stored while pending
char getInput(void);            //IO interface, assumes character device eg, UART

void showMainMenu(void);        //for use with non-stream outputs
void showOption(char m);        //for use with non-stream outputs
void showNumber(void);          //needs menuEntry
void showConfirm(char m);       //needs menuEntry

#endif	/* MENU_H */

