; UTIL1822.INC: useful macros and subroutines
;------------------------------------------------------------------------
; put a literal value (constant) into a register
;------------------------------------------------------------------------
MOVLF	macro	literal, file	; literal->file
	BANKSEL	  file
	MOVLW	literal
	MOVWF	file
	endm
;-----------------------------------------------------------------------------
; move file1 to file2
;-----------------------------------------------------------------------------
MOVFF	macro	file1, file2	; file1 -> file2
	BANKSEL	file1
	movf	file1, w
	BANKSEL	file2
	MOVWF	file2
	endm
;------------------------------------------------------------------------
; put 16-bit register1 into 16-bit register2
;------------------------------------------------------------------------
MOVFF16b	macro	fileLO1, fileHI1, fileLO2, fileHI2	; file1->file2
	MOVF	fileLO1, W
	MOVWF	fileLO2
	MOVF	fileHI1, W
	MOVWF	fileHI2
	endm
;------------------------------------------------------------------------
; read table "lut", at adress "adr", put result into file
;------------------------------------------------------------------------
READLUT	macro	file, lut, adr
	;MOVLP	HIGH lut
	MOVLW	high lut
	MOVWF	PCLATH
	MOVF	adr, w	; (adr) -> W
	CALL	lut		; retreive a byte from table
	movwf	file
	endm
;
;////////////////////////////////////////////////////////////////////////
;
;------------------------------------------------------------------------
; Clear 80 bytes, bank0 [0x20 to 0x6F] + 16 bytes, COMMON [0x70 to 0x7F] 
;------------------------------------------------------------------------
clearRAMbank0
	MOVLW	0x20		; initialize pointer...
	MOVWF	FSR0L		; ... to RAM (indirect addressing)
	CLRF	FSR0H
init1
	CLRF	INDF0		; clear 1 byte
	INCF	FSR0L, f	; increment pointer
	BTFSS	FSR0L, 7	; > 0x7F ?
	GOTO	init1		; no
	RETURN
