; F1822ADC.INC: routines for 10-bit measurements.
;-----------------------------------------------------------------------------
; declare in the main file:
;-----------------------------------------------------------------------------
;F1822ADC.INC
;measure
;	measAN2HI, measAN2LO ; 10-bit count from channel AN2
;
;take care of :
; TRISA	 (bank1), config RA2 as input
; ANSELA (bank3)= 0000 0100	; select AN2
;
;/////////////////////////////////////////////////////////////////////////////
;
;------------------------------------------------------------------------------
; store 10-bit measure (ADRESH, ADRESL) in (measHI, measLO)
;------------------------------------------------------------------------------
SAVEMEAS10b	 macro	measHI, measLO 
	MOVLB 1					; switch to bank1
	movf	ADRESH, W		; retreive high byte
	MOVLB 0					; switch to bank0
	movwf	measHI			; store it in measHI
	MOVLB 1					; switch to bank1
	movf	ADRESL, W		; retreive low byte
	MOVLB 0					; switch to bank0
	movwf	measLO			; store it in measLO
	endm
;------------------------------------------------------------------------------
; duplicate old 10-bit measure in (FSR1H, FSR1L)
;------------------------------------------------------------------------------
COPYMEAS10b	 macro	measHI, measLO 
	movf	measHI, W		; copy high byte ...
	movwf	FSR1H			; ... in FSR1H (to allow compare old, new meas.)
	movf	measLO, W		; copy low byte ...
	movwf	FSR1L			; ... in FSR1L (to allow compare old, new meas.)
	endm

;-----------------------------------------------------------------------------
; call this routine before any measure
;-----------------------------------------------------------------------------
enableFVR
	MOVLB 2					; switch to bank2
	movlw	b'10000010'		; <7>=1: FVR on, <10>=10: 2.048V reference  
	;iorwf FVRCON, F
	movwf FVRCON
	;wait until reference stable
	btfss FVRCON, FVRRDY	; FVRRDY=1 => reference is ready
	goto $-1
	MOVLB 0
	RETURN
;-----------------------------------------------------------------------------
; 10-bit measure from channel AN2 (measuring C)
;-----------------------------------------------------------------------------
measAN2
	;COPYMEAS10b	 measAN2HI, measAN2LO 

	MOVLW	b'00001000'		; <6-2>=00010, mask for channel AN2
	CALL	meas10b
 ;bcf meas2change
 ;btfsc measXchange	; is meas. same ?
 ;bsf meas2change	; no.
 
	;SAVEMEAS10b	 measAN2HI, measAN2LO 
	RETURN
;-----------------------------------------------------------------------------
; 10-bit measure 
; CAUTION: VREF+ connected to internal FVR
;-----------------------------------------------------------------------------
meas10b
	MOVLB	1				; switch to bank1
	MOVWF	ADCON0
	;MOVLW	b'11000011'		;right justified, <6-4>=100 => Fosc/4 (if 4MHz)... 
 	MOVLW	b'11110011'		;right justified, <6-4>=111 => Frc clock... 
	MOVWF	ADCON1			;... <1-0>=11 => VREF+ connected to internal FVR

meas10bGO
 ;bsf measXchange
	BSF	ADCON0, ADON		; switch on ADC module ; INDISPENSABLE ICI

	;MOVLW	.8				; 32 us delai interne (if 4 MHz)
	;;MOVLW	.64				; 256 us delai interne (if 4 MHz)
	;ADDLW	0FFh			; revient  soustraire 1 de W
	;BTFSS	STATUS, Z		; bit Z=1 (i.e. W = 0 ?)
	;GOTO	$-2				; boucle interne = 4 * 8 = 32 us
	;;GOTO	$-2				; boucle interne = 4 * 64 = 256 us
	;;;;;NOP				; delay 129 s
	;;;;;NOP				; delay 129 s
	MOVLW	.65
	ADDLW	0FFh		; W--
	BTFSS	STATUS, Z	; bit Z=1 (i.e. W = 0 ?)
	GOTO	$-2			; no, then loop = 4 * 65 = 260 us

	BSF	 ADCON0, ADGO		; initiate one A/D conversion
	BTFSC  ADCON0, ADGO		; A/D conversion complete ?
	GOTO	$-1				; no

	NOP
	BCF	 ADCON0, ADON		; switch off ADC module

;copy (ADRESH,L) into (measAN2HI,measAN2LO)
	MOVLB 1					; switch to bank1
	movf	ADRESH, W		; retreive high byte
	MOVLB 0					; switch to bank0
	movwf	measAN2HI			; store it in measAN2HI
	MOVLB 1					; switch to bank1
	movf	ADRESL, W		; retreive low byte
	MOVLB 0					; switch to bank0
	movwf	measAN2LO			; store it in measAN2LO

finRtn
	RETURN
;;-----------------------------------------------------------------------------
;; convert 10-bit numerical count (AN2) to physical parameter (C)
;;-----------------------------------------------------------------------------
;calculus
;;compute (AN2 / 5) => (C + 50) <= TC1047A [-40C..125C], 10mV/C, 500mV @ 0C
; ;btfss meas2change	; has meas. changed ?
; ;goto	finRtn2	; no.
;
;	DIV16_8	  measAN2HI, measAN2LO, .5, Tfridge
;
;; Fridge operation = 4C ... 9C => 54 < Tfridge < 59
;
;	; if (Tfridge < TfridgeMIN) goto temperatureLOW
;	SIregLTval8b  Tfridge, TfridgeMIN, temperatureLOW
;
;	; if (Tfridge >= TfridgeMAX) goto temperatureHIGH
;	SIregGEval8b  Tfridge, TfridgeMAX, temperatureHIGH
;
;temperatureLOW
;
;
;temperatureHIGH
;
;
;finRtn2
;	RETURN
