; SIRENE6b.INC: Siren Sound (increasing tone) @ 4 MHz
; macros: 
; routines: ToneHo, ToneHi, DispSonore

;-----------------------------------------------------------------------------
; declare in the main file:
;-----------------------------------------------------------------------------
;#define	PIEZO	GPIO, 1		; piezo for alarm
;; siren
;	frequency, counter
;	cycles1, cycles2
;	steps

;-----------------------------------------------------------------------------
; ToneHo sound, approx. 2 kHz (never apply permanent DC voltage to piezo)
;-----------------------------------------------------------------------------
ToneHo
	clrf  cycles1
Ho
	;bcf   PIEZO		; PIEZO LOW...
	;bsf   PIEZOb	;...during 0.259 ms
	MOVLF	b'00000000', WPUA	;RA3 pullup OFF => BS170 off
	MOVLB	0				; switch to bank0	
	DELAY256us_4MHz

	;bsf   PIEZO		; PIEZO HIGH...
	;bcf   PIEZOb	;...during 0.259 ms
	MOVLF	b'00001000', WPUA	;RA3 pullup ON => BS170 on
	MOVLB	0				; switch to bank0	
	DELAY256us_4MHz

	decfsz cycles1, f
	goto   Ho		; repeat Ho tone during 0.518 * 256 = 132,608 ms (?)

	;bcf   PIEZO		; turn off piezo
	MOVLF	b'00000000', WPUA	;RA3 pullup OFF => BS170 off
	MOVLB	0				; switch to bank0	
	RETURN

;-----------------------------------------------------------------------------
; ToneHi sound, approx. 4 kHz (never apply permanent DC voltage to piezo)
;-----------------------------------------------------------------------------
ToneHi
	clrf  cycles1
Hi
	;bcf   PIEZO		; PIEZO LOW ...
	;bsf   PIEZOb		;...during 0.130 ms
	MOVLF	b'00000000', WPUA	;RA3 pullup OFF => BS170 off
	MOVLB	0			; switch to bank0	
	DELAY128us_4MHz
	
	;bsf   PIEZO		; PIEZO HIGH ...
	;bcf   PIEZOb		;...during 0.130 ms
	MOVLF	b'00001000', WPUA	;RA3 pullup ON => BS170 on
	MOVLB	0			; switch to bank0	
	DELAY128us_4MHz
	
	;bcf   PIEZO		; PIEZO LOW ...
	;bsf   PIEZOb		;...during 0.130 ms
	MOVLF	b'00000000', WPUA	;RA3 pullup OFF => BS170 off
	MOVLB	0			; switch to bank0	
	DELAY128us_4MHz
	
	;bsf   PIEZO		; PIEZO HIGH ...
	;bcf   PIEZOb		;...during 0.130 ms
	MOVLF	b'00001000', WPUA	;RA3 pullup ON => BS170 on
	MOVLB	0			; switch to bank0	
	DELAY128us_4MHz
	
	decfsz cycles1, f
	goto   Hi			; repeat Hi tone during 0.520 * 256 = 133,12 ms (?)

	;bcf   PIEZO		; turn off piezo
	MOVLF	b'00000000', WPUA	;RA3 pullup OFF => BS170 off
	MOVLB	0			; switch to bank0	
	RETURN
