; SPLASH.INC: useful macros and subroutines
;------------------------------------------------------------------------------
;usage, to light LED num. N (LEDndx) during (lightON)
;	BANKSEL	LEDndx
;	clrf	LEDndx
;splash
;	;MOVLF	.100, lightON	; period=10ms x 100 = 1s duration light ON each LED
;	MOVLF	.50, lightON	; 1s duration light ON each LED
;	call	splashDOT
;	incf	LEDndx, f
;	SIregLTval8b  LEDndx, .10, splash ; if (LEDndx < 10) goto splash 

;----------------------------------
splashDOT
	READLUT	valTRISA, Table1, LEDndx ; valTRISA = Table1 [LEDndx]

	READLUT	valPORTA, Table2, LEDndx ; valPORTA = Table2 [LEDndx]

	READLUT	valtimeON, Table3, LEDndx ; valtimeON = Table3 [LEDndx]

repeatdot
	MOVFF	valTRISA, TRISA	; update config.PORTA
	MOVFF	valPORTA, PORTA	; update RAx,RAy states
	MOVLF	.10, lightPeriod
	MOVFF	valtimeON, timeON
ledONdot
	call	Delai_1ms
	decf	lightPeriod, f
	decfsz	timeON, f
	goto	ledONdot		;flashing a LED during timeON / ledPeriod
	incf	lightPeriod, f
	clrf	PORTA
ledOFFdot
	call	Delai_1ms
	decfsz	lightPeriod, f
	goto	ledOFFdot

	decfsz	lightON, f		; light a LED during 1s
	goto	repeatdot
	RETURN

;----------------------------------
splashBAR
	clrf	LEDi

barloop
	READLUT	valTRISA, Table1, LEDi ; valTRISA = Table1 [LEDi]

	READLUT	valPORTA, Table2, LEDi ; valPORTA = Table2 [LEDi]

	READLUT	valtimeON, Table3, LEDi ; valtimeON = Table3 [LEDi]

repeatbar
	MOVFF	valTRISA, TRISA	; update config.PORTA
	MOVFF	valPORTA, PORTA	; update RAx,RAy states
	MOVLF	.10, lightPeriod
	MOVFF	valtimeON, timeON
ledONbar
	MOVLF	.1, cpt1
	;call	DelayXms_4MHz	; Delai 1ms @ 4 MHz
	call	Delay100us_4MHz	; Delai 100s @ 4 MHz
	decf	lightPeriod, f
	decfsz	timeON, f
	goto	ledONbar		;flashing a LED during timeON / ledPeriod
	incf	lightPeriod, f
	clrf	PORTA
ledOFFbar
	MOVLF	.1, cpt1
	;call	DelayXms_4MHz	; Delai 1ms @ 4 MHz
	call	Delay100us_4MHz	; Delai 100s @ 4 MHz
	decfsz	lightPeriod, f
	goto	ledOFFbar

	incf	LEDi, f
	SIregaLTregb8b LEDndx, LEDi, bar_redo ; if (LEDndx < LEDi) goto bar_redo
	goto barloop

bar_redo
	decfsz	lightON, f		; light a BAR during 1s
	goto	splashBAR
	RETURN
