; Delays31kHz.INC: delay routines useful at Fosc=31kHz.
;
;-----------------------------------------------------------------------------
; delay 1 second
;-----------------------------------------------------------------------------
DELAY1S	 macro
	clrwdt
	call	Delai_256ms
	call	Delai_256ms
	call	Delai_256ms
	call	Delai_256ms
	clrwdt
	endm

;/////////////////////////////////////////////////////////////////////////////
;
;-----------------------------------------------------------------------------
; delay 1 ms knowing that 1 instruction = 129 s (@ internal 31 kHz)
;-----------------------------------------------------------------------------
;1032s
Delai_1ms			; appel CALL : 2 x 129 s = 258 s
	GOTO	$+1		; 2 x 129 = 258 s
	GOTO	$+1		; 2 x 129 = 258 s
	RETURN			; retour  : 2 x 129 s = 258 s
;total = 258 x 4 = 1032 s
;;-----------------------------------------------------------------------------
;; delay 1.5 ms knowing that 1 instruction = 129 s (@ internal 31 kHz)
;;-----------------------------------------------------------------------------
;;1.5ms (bar mode)
;Delai_1ms_etdemi	; appel CALL : 2 x 129 s = 258 s
;	GOTO	$+1		; 2 x 129 = 258 s
;	GOTO	$+1		; 2 x 129 = 258 s
;	GOTO	$+1		; 2 x 129 = 258 s
;	GOTO	$+1		; 2 x 129 = 258 s
;	RETURN			; retour  : 2 x 129 s = 258 s
;;total = 258 x 6 = 1548 s
;-----------------------------------------------------------------------------
; delay 10 ms
;-----------------------------------------------------------------------------
;10ms (dot mode)
Delai_10ms			; appel CALL : 2 x 129 s = 258 s
	MOVLF	.6, cpt3	  ; macro MOVLF : 3 x 129 s = 387 s
	call	Delai_1ms ; 1032 s
	decfsz   cpt3, F  ; 1 instr = 129 s
	GOTO	$-2		  ; saut = 2 x 129 s = 258 s
	GOTO	$+1		; 2 x 129 = 258 s
	GOTO	$+1		; 2 x 129 = 258 s
	RETURN			; retour  : 2 x 129 s = 258 s
;total = 6 x 1.419 = 8.514 ms + 1.419 ms
;-----------------------------------------------------------------------------
; delay 20 ms
;-----------------------------------------------------------------------------
Delai_20ms			; appel CALL : 2 x 129 s = 258 s
	MOVLF	.14, cpt3	  ; macro MOVLF : 3 x 129 s = 387 s
	call	Delai_1ms ; 1032 s
	decfsz   cpt3, F  ; 1 instr = 129 s
	GOTO	$-2		  ; saut = 2 x 129 s = 258 s
	RETURN			; retour  : 2 x 129 s = 258 s
;total = 14 x 1.419 = 19.866 ms + 0.903 ms
;-----------------------------------------------------------------------------
; delay 256 ms
;-----------------------------------------------------------------------------
Delai_256ms			  ; appel CALL  : 2 x 129 s = 258 s
	MOVLF	.180, cpt3	  ; macro MOVLF : 3 x 129 s = 387 s
	call	Delai_1ms ; 1032 s
	decfsz   cpt3, F  ; 1 instr = 129 s
	GOTO	$-2		  ; saut = 2 x 129 s = 258 s
	RETURN			  ; retour RETURN: 2 x 129 s = 258 s
;total = 180 x 1.419 = 255.42 ms + 0.903 ms
