; DIV16BY8.INC: 
; result:2 (16-bit) / W register (8-bit) -> 
; result=Quotient, result+1=Remainder. W register preserved.
; C=1 if error. Z=1 if divide by 0. Z=0 if divide overflow
; size=29. speed=7 cycles if div by 0. speed=94 min., 129 max.
;------------------------------------------------------------------------------
;
;------------------------------ define variables ------------------------------
;div16by8
;	result:2	; dividend (16-bit) -> result=Quotient, result+1=Remainder
;------------------------------------------------------------------------------
;
DIV16_8	macro		measHI, measLO, cstQuotient, varPhysique
	MOVF	measLO, W
	MOVWF	result		;Dividend
	MOVF	measHI, W
	MOVWF	result + 1	;Dividend + 1
	MOVLW	cstQuotient
	CALL	div16b8b	;(Dividend:2) / W => (Quotient,Remainder)
	MOVF	result, W 	;Quotient inside result
	MOVWF	varPhysique	; grandeur physique 
	endm
	
;------------------------------------------------------------------------------
div16b8b
	addlw	0			; W+=0 (to test for div by 0)
	bsf	STATUS, C 		; set CARRY in case of error
	btfsc	STATUS, Z 	; if zero
	return				; return (error C, Z)

	call	DivSkipHiShift

iDivRepeat = 8
 while iDivRepeat
	call	DivCode
iDivRepeat--
 endw

	rlf	result, f 		; C << lo << C
	bcf	STATUS, Z  		; NZ (in case of overflow error)
	return				; we are done !

DivCode
	rlf	result, f 		; C << lo << C
	rlf	result+1, f 	; C << hi << C
	btfss	STATUS, C	; if CARRY
	goto	DivSkipHiShift
	subwf	result+1, f	; hi-=W
	bsf	STATUS, C		; ignore CARRY
	return				; done

DivSkipHiShift
	subwf	result+1, f	; hi-=W
	btfsc	STATUS, C	; if CARRY set
	return				; done
	addwf	result+1, f	; hi+=W
	bcf	STATUS, C		; clear CARRY
	return				; done
;------------------------------------------------------------------------------
