; BarDot10bgyr.ASM: = DC current vu-meter (1A) w/ 10LED bargraph (0.1A resol.)
; order 1,2,...,10 ; blue green yellow red
; BENABADJI Salim - ORAN - Aug. 17th, 2024
;------------------------------------------------------------------------------
;
	List P = 12F1822   	;8p/core14/fROM2kW/sRAM128/EEP256/4ADC10b/1cmp/tmr2-1
#include <p12f1822.inc>

	Errorlevel -302		; avoid warning #302: Register in operand not in bank0. 
						; Ensure that bank bits are correct.

	__CONFIG _CONFIG1, H'3FFF' & _FCMEN_OFF & _IESO_OFF & _BOREN_OFF & _MCLRE_OFF & _PWRTE_ON & _WDTE_ON & _FOSC_INTOSC
	__CONFIG _CONFIG2, H'3FFF' & _LVP_OFF & _PLLEN_OFF
;activate the Watchdog Timer if necessary to recover from unexpected events.

;------------------------------ define hardware -------------------------------
;internal 31 kHz, if dotgraph
;internal 4 MHz, if bargraph

#define	 BP1	PORTA, 3		; BP1 toggle bar/dot mode
#define	 PIEZO	PORTA, 3		; output piezo (alarm)

;======================================
	CBLOCK	0x20	; BANK0 = [0x20....0x6F]  = 80 bytes
;LEDs
	LEDndx			; ptr to Table1, Table2 & Table3
	LEDi			; used in barmode
	valTRISA, valPORTA
	valtimeON, timeON
	lightON, lightPeriod ; pseudo PWM = lightON / lightPeriod 
;delai
	cpt1, cpt2, cpt3 ; counters
;siren
	cycles1
;measure
	measAN2HI, measAN2LO ; 10-bit count from channel AN2
;div16by8
	result:2	; dividend (16-bit) -> result=Quotient, result+1=Remainder
;flags
	bnFlags			;<0>=1, any btn pushed
					;<1>=1, overflow odd
					;<2>=1, do timing
					;<3>=1, leading zero. Don't display, to lower consumption 
	ENDC
;TOTAL = 17 bytes used !
;--------------------------------- define bits -------------------------------

#define	btnPushed	bnFlags, 0 ;<0>=1 => any btn pushed

;-----------------------------------------------------------------------------
; increment one digit from 0 to maxi-1 ; if maxi, then wrap to 0 
;-----------------------------------------------------------------------------
INC1	macro	digitX, maxi, jump 
	banksel	digitX
	INCF	digitX, f	; increment digitX 
	MOVLW	maxi
	XORWF	digitX, w
	BTFSS	STATUS, Z	; digitX = maxi ?
	GOTO	jump		; no
	CLRF	digitX		; yes, then clear digitX
	endm
;-----------------------------------------------------------------------------
; decrement one digit from maxi to 0 ; if -1, then wrap to maxi
;-----------------------------------------------------------------------------
DEC1	macro	digitX, maxi, jump
	banksel	digitX
	DECF	digitX, f	; decrement digitX 
	MOVLW	.255
	XORWF	digitX, w	; digitX = -1 ?
	BTFSS	STATUS, Z
	GOTO	jump		; no
	MOVLW	maxi		; yes, then update digitX to highest value
	MOVWF	digitX
	endm
	
;/////////////////////////////////////////////////////////////////////////////
;	MAIN PROGRAM
;/////////////////////////////////////////////////////////////////////////////
	ORG		0x00			; address reset
	GOTO	Main
	;ORG		0x04			; address interrupt
	;GOTO	intTMR0

;/////////////////////////////////////////////////////////////////////////////
;
;------------------------------------------------------------------------
; Table1 to update cfg TRISA ; Table2 to update RAx,RAy states
;------------------------------------------------------------------------
Table1
	ADDWF PCL,f
	RETLW b'11111100'	; RA0,RA1 outputs, prepare to light LED1
	RETLW b'11111100'	;       idem       prepare to light LED2
	RETLW b'11101101'	; RA1,RA4 outputs, prepare to light LED3
	RETLW b'11101101'	;       idem       prepare to light LED4
	RETLW b'11001111'	; RA4,RA5 outputs, prepare to light LED5
	RETLW b'11001111'	;       idem       prepare to light LED6
	RETLW b'11101110'	; RA0,RA4 outputs, prepare to light LED7
	RETLW b'11101110'	;       idem       prepare to light LED8
	RETLW b'11011101'	; RA1,RA5 outputs, prepare to light LED9
	RETLW b'11011101'	;       idem       prepare to light LED10

Table2
	ADDWF PCL,f
	RETLW b'00000001'	; RA0 high, RA1 low to light LED1
	RETLW b'00000010'	; RA0 low, RA1 high to light LED2

	RETLW b'00000010'	; RA1 high, RA4 low to light LED3
	RETLW b'00010000'	; RA1 low, RA4 high to light LED4

	RETLW b'00010000'	; RA4 high, RA5 low to light LED5
	RETLW b'00100000'	; RA4 low, RA5 high to light LED6

	RETLW b'00000001'	; RA0 high, RA4 low to light LED7
	RETLW b'00010000'	; RA0 low, RA4 high to light LED8

	RETLW b'00000010'	; RA1 high, RA5 low to light LED9
	RETLW b'00100000'	; RA1 low, RA5 high to light LED10

;------------------------------------------------------------------------
; Table3 timing pseudo-PWM to light red, yellow, green, blue LEDs
;------------------------------------------------------------------------
Table3 ; resolution 1ms ; period 10ms
	ADDWF PCL,f
	RETLW b'00001001'	; 10ms ON / period to light LED1 blue
	RETLW b'00000001'	; 1ms  ON / period to light LED2 green
	RETLW b'00000001'	;       idem       to light LED3 green
	RETLW b'00000001'	;       idem       to light LED4 green
	RETLW b'00000001'	;       idem       to light LED5 green
	RETLW b'00001000'	; 8ms  ON / period to light LED6 yellow
	RETLW b'00001000'	;       idem       to light LED7 yellow
	RETLW b'00001000'	;       idem       to light LED8 yellow
	RETLW b'00000111'	; 7ms  ON / period to light LED9 red
	RETLW b'00000111'	;       idem       to light LED10 red

;------------------------------------------------------------------------
; Table4 timing light ON for each BARgraph, @ 4MHz
;------------------------------------------------------------------------
Table4 ; in ms
	ADDWF PCL,f
	RETLW .255		; BAR LED1
	RETLW .255		; BAR LED1 to LED2

	RETLW .240		; BAR LED1 to LED3
	RETLW .220		; BAR LED1 to LED4
	RETLW .190		; BAR LED1 to LED5

	RETLW .140		; BAR LED1 to LED6
	RETLW .140		; BAR LED1 to LED7

	RETLW .100		; BAR LED1 to LED8
	RETLW .100		; BAR LED1 to LED9

	RETLW .50		; BAR LED1 to LED10

;-----------------------------------------------------------------------------

#include "IF8b16b3.INC"	; all the tests IF
#include "UTIL1822.INC"
#include "SPLASH.INC"
#include "F1822osc.INC"
#include "Delays31kHz.INC"
#include "Delays4MHz.INC"
#include "SIRENE6b.INC"
#include "DIV16BY8.INC"
#include "F1822ADC.INC"
#include "SenseBtns.INC"

;=============================================================================
Main
;choice 4MHz freq. @ initialisation stuff only
	call	setosc4MHz
	clrwdt
;----	
;	MOVLF	b'01010100', OPTION_REG	; <7>=0:pullups ON; <5>=0: RA2, not T0CKI
;									; <3>=0:enable prescale to TMR0
;									; <2:0>=100: prescale = 1:32
	MOVLF	b'01010011', OPTION_REG	; <7>=0:pullups ON; <5>=0: RA2, not T0CKI
									; <3>=0:enable prescale to TMR0
									; <2:0>=011: prescale = 1:16
;----
	;MOVLF	b'00001000', WPUA	;pullup (RA3) enabled (without R7, T1 & PIEZO)
	MOVLF	b'00000000', WPUA	;pullup (RA3) disabled (with R7, T1 & PIEZO)
;----
;init PORTA
	MOVLF	b'00111111', TRISA	;all RAx inputs
	MOVLF	b'00000000', PORTA	;all RAx LOW
	MOVLF	b'00000000', LATA	;all Data Latch RAx LOW
	MOVLF	b'00000100', ANSELA	; use RA2 as AN2 analog input

;init watchdog
	;MOVLF	b'00000100', WDTCON	;<5-1>=01100 => watchdog timeout=4s (default=2s)
	;MOVLB 0						; back to bank0

;some delay
	DELAY1S_4MHz
	clrwdt

;<SPLASH PIEZO>=========
splashPiezo
	call	ToneHo
	call	ToneHi
	call	ToneHo
	call	ToneHi

	DELAY1S_4MHz		; pause 1s @ 4MHz

	call	senseBtn1

	btfsc	btnPushed	; btn flag cleared ? i.e BP1 has not been pushed ?
	goto	splashPiezo	; no. BP1 has been pushed.

endof_splashPiezo
	bcf	btnPushed		; clear btn flag
;</SPLASH PIEZO>========

;<SPLASH DOT>==========
	call	setosc31kHz	;choice 31kHz freq. for dotmode

	BANKSEL	LEDndx
	clrf	LEDndx
dotsplash
	clrwdt
	;MOVLF	.100, lightON	; period=10ms x 100 = 1s duration light ON each LED
	MOVLF	.50, lightON	; 1s duration light ON each LED
	call	splashDOT
	incf	LEDndx, f
	SIregLTval8b  LEDndx, .10, dotsplash ; if (LEDndx < 10) goto dotsplash 

	DELAY1S				; pause 1s @ 31kHz
;</SPLASH DOT>==========

;<SPLASH BAR>===========
	call	setosc4MHz	;choice 4MHz freq. for barmode

	BANKSEL	LEDndx
	clrf	LEDndx
barsplash
	clrwdt
	READLUT	lightON, Table4, LEDndx ; lightON = Table4 [LEDndx] adjust 1s each BAR
	call	splashBAR
	incf	LEDndx, f
	SIregLTval8b  LEDndx, .10, barsplash ; if (LEDndx < 10) goto barsplash 

	DELAY1S_4MHz		; pause 1s @ 4MHz
;</SPLASH BAR>===========
	
;============================= LOOP FOREVER ==================================
	call	enableFVR	; enable internal ref 2.048V before any meas.

loopForever
	clrwdt

;----------------------
senseBP1
	call	senseBtn1

	btfsc	btnPushed	; btn flag cleared ? i.e BP1 has not been pushed ?
	call	ToneHo
	;call	ToneHi
	clrwdt
	bcf	btnPushed		; clear btn flag
;----------------------

doMeas
	call	measAN2		; C

;;CAS1: VOLT vumeter
;	DIV16_8	  measAN2HI, measAN2LO, .103, LEDndx ; bargraph 0...2V with 0.2V resol
;	;MOVF	LEDndx, w
;	;SUBLW	.9			; w = 9 -LEDndx
;	;MOVWF	LEDndx		; store W in LEDndx

;CAS2: AMPERE vumeter (Rshunt = 0R1)
	DIV16_8	  measAN2HI, measAN2LO, .5, LEDndx ; bargraph 0...1A with 0.1A resol
	SIregLTval8b  LEDndx, .10, doSuite ; if (LEDndx < 10) goto doSuite 
	MOVLF	.9, LEDndx	; LEDndx = 0...9max, as it is also a ptr to Tables 1,2,3
	
doSuite
	clrwdt
	SIregLTval8b  LEDndx, .9, lightbar ; if (LEDndx < 9) goto lightbar 
	;call	ToneHo			;Alarm overcurrent 90%
	call	ToneHi			;Alarm overcurrent 100%

lightbar
	clrwdt
	READLUT	lightON, Table4, LEDndx ; lightON = Table4 [LEDndx] adjust 1s each BAR
	;MOVLF	.250, lightON	; period=250ms x 4 = 1s duration light ON each BAR
	call	splashBAR
	clrf	PORTA
	goto	loopForever

;----------------------------------------------------------------------------
	END
