; F1822osc.INC: routines to set oscillator frequency.
;
;/////////////////////////////////////////////////////////////////////////////
;
;-----------------------------------------------------------------------------
; sets internal oscillator to 4 MHz
;-----------------------------------------------------------------------------
setosc4MHz
	MOVLF	b'01101010', OSCCON	; OSCCON<6:3> = 1101 (4 MHz)
;wait until clock ready
	btfss  OSCSTAT, HFIOFR		; HFINTOSC is ready ?
	goto   $-1
; and clock stable
	btfss  OSCSTAT, HFIOFS		; HFINTOSC is at least 0.5% accurate ?
	goto   $-1
	RETURN

;-----------------------------------------------------------------------------
; sets internal oscillator to 31 kHz
;-----------------------------------------------------------------------------
setosc31kHz
	MOVLF	b'00000010', OSCCON	; OSCCON<6:3> = 000X (31 kHz)
;wait until clock ready
	btfss  OSCSTAT, LFIOFR	; LFINTOSC is ready ?
	goto   $-1
	RETURN
