; Delays4MHz.INC: delay routines useful at Fosc=4MHz.
;
;-----------------------------------------------------------------------------
; delay 1 second (Fosc = 4 MHz)
;-----------------------------------------------------------------------------
DELAY1S_4MHz	 macro
	clrwdt
	BANKSEL	cpt1
	clrf	cpt1
	call	DelayXms_4MHz	; Delai 256ms
	call	DelayXms_4MHz
	call	DelayXms_4MHz
	call	DelayXms_4MHz
	clrwdt
	endm
;-----------------------------------------------------------------------------
; delay 256 s (Fosc = 4 MHz)
;-----------------------------------------------------------------------------
DELAY256us_4MHz	 macro
	MOVLW	.64
	ADDLW	0FFh		; W--
	BTFSS	STATUS, Z	; bit Z=1 (i.e. W = 0 ?)
	GOTO	$-2			; no, then loop = 4 * 64 = 256 us
	endm
;-----------------------------------------------------------------------------
; delay 128 s (Fosc = 4 MHz)
;-----------------------------------------------------------------------------
DELAY128us_4MHz	 macro
	MOVLW	.32
	ADDLW	0FFh		; W--
	BTFSS	STATUS, Z	; bit Z=1 (i.e. W = 0 ?)
	GOTO	$-2			; no, then loop = 4 * 32 = 128 us
	endm

;/////////////////////////////////////////////////////////////////////////////
;
;----------------------------------------------------------------------------
Delay100us_4MHz	; Delai 100s @ 4 MHz
	MOVLW	.25
	ADDLW	0FFh		; W--
	BTFSS	STATUS, Z	; bit Z=1 (i.e. W = 0 ?)
	GOTO	$-2			; no, then loop = 4 * 25 = 100 us
	RETURN

;----------------------------------------------------------------------------
; Delay X ms, where X = 1,2,...,255 (and 256 ms, if X=0)
;----------------------------------------------------------------------------
DelayXms_4MHz
	MOVWF	cpt1			; cpt1 = X

delay1ms_4MHz
	MOVLW	.250
	ADDLW	0FFh		; W--
	BTFSS	STATUS, Z	; bit Z=1 (i.e. W = 0 ?)
	GOTO	$-2			; no, then loop = 4 * 250 = 1000 us

	DECFSZ	cpt1, F
	GOTO	delay1ms_4MHz
	RETURN
