#line 1 "D:/DESIGN/Digital_Tone_Control/Filles for Circuitcellar Digital_tone_control_by_NoelA. Rios/Digital_Tone_Control_Firmware_By_NoelA.Rios/Digital_tone_Control_firmware.c"
#line 30 "D:/DESIGN/Digital_Tone_Control/Filles for Circuitcellar Digital_tone_control_by_NoelA. Rios/Digital_Tone_Control_Firmware_By_NoelA.Rios/Digital_tone_Control_firmware.c"
const char THRESHOLD = 8;
const char sample = 4;
const char address_code=0x82;

unsigned char channel_select=0;
unsigned char input_gain=2;
unsigned char volume=40;
unsigned char treble=5;
unsigned char bass=7;
unsigned char channel_active=3;
const char test_mode=0xF0;
unsigned char buffer;
unsigned char temp;

unsigned char counter;
unsigned char sample_counter;
unsigned char volume_level;
unsigned char resample=10;

int volume_rdg;
int balance_rdg;
int bass_rdg;
int treble_rdg;
int input_gain_rdg;
int channel_rdg;

sbit blink at PORTD7_bit;
sbit blink_Direction at DDD7_bit;
sbit Chip_Select at PORTB2_bit;
sbit Chip_Select_Direction at DDB2_bit;

sbit CE at PORTB0_bit;
sbit CE_Direction at DDB0_bit;


void Read_potentiometer();

unsigned char reverseBits(unsigned char num)
{
 int NO_OF_BITS = sizeof(num) * 8;
 unsigned char reverse_num = 0;
 int i;
 for (i = 0; i < NO_OF_BITS; i++)
 {
 if((num & (1 << i)))
 reverse_num |= 1 << ((NO_OF_BITS - 1) - i);
 }
 return reverse_num;
}

void set_parameter()
{
CE=1;
delay_us(1000);
CE=0;
delay_us(1000);
buffer=reverseBits(address_code);
SPI1_Write(buffer);
delay_us(1000);
CE=1;
delay_us(1000);

buffer=reverseBits(channel_select);
buffer&=0xF0;
temp=reverseBits(input_gain);
temp>>=4;
temp&=0x0F;
buffer|=temp;
SPI1_Write(buffer);
delay_us(100);
buffer=reverseBits(volume);
SPI1_Write(buffer);
delay_us(100);
buffer=reverseBits(treble);
buffer&=0xF0;
temp=reverseBits(bass);
temp>>=4;
temp&=0x0F;
buffer|=temp;
SPI1_Write(buffer);
delay_us(100);

buffer=0;
temp=reverseBits(channel_active);
temp>>=2;
temp&=0b00110000;
buffer|=temp;

SPI1_Write(buffer);
delay_us(1000);
CE=0;
delay_us(1000);

}


void Timer1Overflow_ISR() org IVT_ADDR_TIMER1_OVF {

 if (counter >= THRESHOLD) {
 blink = ~blink;
 counter = 0;
 }
 else
 counter++;

 if(sample_counter>=sample)
 {
 Read_potentiometer();
 sample_counter=0;


 }
 else
 sample_counter++;

}

void SPI_init()
{
 Chip_Select = 1;
 Chip_Select_Direction = 1;
 CE=1;
 CE_Direction = 1;
 SPI1_Init();

}

void ADC_setup()
{
 ADC_Init();
}

void Read_Potentiometer()
{

volume_rdg=ADC_Get_Sample(0);
delay_us(1000);
if(volume_rdg<=10) {
volume=80;
volume_level=80;}
else{
volume_level=abs(80-volume_rdg/13);
volume=volume_level;
}

balance_rdg=ADC_Get_Sample(1);
delay_us(1000);
#line 198 "D:/DESIGN/Digital_Tone_Control/Filles for Circuitcellar Digital_tone_control_by_NoelA. Rios/Digital_Tone_Control_Firmware_By_NoelA.Rios/Digital_tone_Control_firmware.c"
if(balance_rdg>=0 && balance_rdg<=85)
{ channel_active=2;
volume=volume_level+30;
if(volume>=80) volume=80;
set_parameter();
channel_active=1;
volume=volume_level;
set_parameter();
}
if(balance_rdg>=86 && balance_rdg<=170)
{ channel_active=2;
volume=volume_level+15;
if(volume>=80) volume=80;
set_parameter();
channel_active=1;
volume=volume_level;
set_parameter();
}
if(balance_rdg>=171 && balance_rdg<=255)
{ channel_active=2;
volume=volume_level+10;
if(volume>=80) volume=80;
set_parameter();
channel_active=1;
volume=volume_level;
set_parameter();
}
if(balance_rdg>=256 && balance_rdg<=340)
{ channel_active=2;
volume=volume_level+7;
if(volume>=80) volume=80;
set_parameter();
channel_active=1;
volume=volume_level;
set_parameter();
}
if(balance_rdg>=341 && balance_rdg<=425)
{ channel_active=2;
volume=volume_level+5;
if(volume>=80) volume=80;
set_parameter();
channel_active=1;
volume=volume_level;
set_parameter();
}
if(balance_rdg>=426 && balance_rdg<=510)
{ channel_active=3;
volume=volume_level;
set_parameter();
}

if(balance_rdg>=511 && balance_rdg<=595)
{ channel_active=1;
volume=volume_level+5;
if(volume>80) volume=80;
set_parameter();
volume=volume_level;
channel_active=2;
set_parameter();
}
if(balance_rdg>=596 && balance_rdg<=680)
{ channel_active=1;
volume=volume_level+7;
if(volume>80) volume=80;
set_parameter();
channel_active=2;
volume=volume_level;
set_parameter();

}
if(balance_rdg>=681 && balance_rdg<=765)
{ channel_active=1;
volume=volume_level+10;
if(volume>80) volume=80;
set_parameter();
channel_active=2;
volume=volume_level;
set_parameter();

}
if(balance_rdg>=766 && balance_rdg<=850)
{ channel_active=1;
volume=volume_level+15;
if(volume>80) volume=80;
set_parameter();
channel_active=2;
volume=volume_level;
set_parameter();

}
if(balance_rdg>=851 && balance_rdg<=1023)
{ channel_active=1;
volume=volume_level+30;
if(volume>80) volume=80;
set_parameter();
channel_active=2;
volume=volume_level;
set_parameter();

}


treble_rdg=ADC_Get_Sample(2);
delay_us(1000);
if(treble_rdg>=0 && treble_rdg<=102) treble=13;
if(treble_rdg>=103 && treble_rdg<=204) treble=12;
if(treble_rdg>=205 && treble_rdg<=306) treble=11;
if(treble_rdg>=307 && treble_rdg<=406) treble=10;
if(treble_rdg>=407 && treble_rdg<=508) treble=9;
if(treble_rdg>=509 && treble_rdg<=512) treble=0;
if(treble_rdg>=513 && treble_rdg<=615) treble=1;
if(treble_rdg>=616 && treble_rdg<=717) treble=2;
if(treble_rdg>=718 && treble_rdg<=819) treble=3;
if(treble_rdg>=820 && treble_rdg<=921) treble=4;
if(treble_rdg>=922 && treble_rdg<=1023) treble=5;


bass_rdg=ADC_Get_Sample(3);
delay_us(1000);
if(bass_rdg==0) bass=0;
if(bass_rdg>=0 && bass_rdg<=102) bass=1;
if(bass_rdg>=103 && bass_rdg<=204)bass=2;
if(bass_rdg>=205 && bass_rdg<=306)bass=3;
if(bass_rdg>=307 && bass_rdg<=408)bass=4;
if(bass_rdg>=409 && bass_rdg<=510)bass=5;
if(bass_rdg>=511 && bass_rdg<=612)bass=6;
if(bass_rdg>=613 && bass_rdg<=714)bass=7;
if(bass_rdg>=715 && bass_rdg<=816)bass=8;
if(bass_rdg>=817 && bass_rdg<=918)bass=9;
if(bass_rdg>=919 && bass_rdg<=1023)bass=10;


input_gain_rdg=ADC_Get_Sample(5);
delay_us(1000);
if(input_gain_rdg==0) input_gain=0;
if(input_gain_rdg>=0 && input_gain_rdg<=68) input_gain=1;
if(input_gain_rdg>=69 && input_gain_rdg<=136) input_gain=2;
if(input_gain_rdg>=137 && input_gain_rdg<=204) input_gain=3;
if(input_gain_rdg>=205 && input_gain_rdg<=272) input_gain=4;
if(input_gain_rdg>=278 && input_gain_rdg<=340) input_gain=5;
if(input_gain_rdg>=341 && input_gain_rdg<=408) input_gain=6;
if(input_gain_rdg>=409 && input_gain_rdg<=476) input_gain=7;
if(input_gain_rdg>=477 && input_gain_rdg<=544) input_gain=8;
if(input_gain_rdg>=545 && input_gain_rdg<=612) input_gain=9;
if(input_gain_rdg>=613 && input_gain_rdg<=680) input_gain=10;
if(input_gain_rdg>=681 && input_gain_rdg<=748) input_gain=11;
if(input_gain_rdg>=749 && input_gain_rdg<=816) input_gain=12;
if(input_gain_rdg>=817 && input_gain_rdg<=884) input_gain=13;
if(input_gain_rdg>=885 && input_gain_rdg<=952) input_gain=14;
if(input_gain_rdg>=953 && input_gain_rdg<=1023) input_gain=15;

channel_rdg=ADC_Get_Sample(4);
delay_us(1000);
if(channel_rdg>=0 && channel_rdg<=256) channel_select=0;
if(channel_rdg>=257 && channel_rdg<=512) channel_select=1;
if(channel_rdg>=513 && channel_rdg<=768) channel_select=2;
if(channel_rdg>=769 && channel_rdg<=1023) channel_select=4;


}
void main() {

 SPI_init();
 ADC_setup();


 blink_Direction=1;
 blink = 0;

 SREG_I_bit = 1;
 TOIE1_bit = 1;
 TCCR1B = 1;

 while (1)
 ;
}
