
_reverseBits:

;Digital_tone_Control_firmware.c,67 :: 		unsigned char reverseBits(unsigned char num)
;Digital_tone_Control_firmware.c,69 :: 		int  NO_OF_BITS = sizeof(num) * 8;
; NO_OF_BITS start address is: 18 (R18)
	LDI        R18, 8
	LDI        R19, 0
;Digital_tone_Control_firmware.c,70 :: 		unsigned char reverse_num = 0;
; reverse_num start address is: 22 (R22)
	LDI        R22, 0
;Digital_tone_Control_firmware.c,72 :: 		for (i = 0; i < NO_OF_BITS; i++)
; i start address is: 20 (R20)
	LDI        R20, 0
	LDI        R21, 0
; NO_OF_BITS end address is: 18 (R18)
; reverse_num end address is: 22 (R22)
; i end address is: 20 (R20)
L_reverseBits0:
; i start address is: 20 (R20)
; reverse_num start address is: 22 (R22)
; NO_OF_BITS start address is: 18 (R18)
	CP         R20, R18
	CPC        R21, R19
	BRLT       L__reverseBits362
	JMP        L_reverseBits1
L__reverseBits362:
;Digital_tone_Control_firmware.c,74 :: 		if((num & (1 << i)))
	MOV        R27, R20
	LDI        R16, 1
	LDI        R17, 0
	TST        R27
	BREQ       L__reverseBits364
L__reverseBits363:
	LSL        R16
	ROL        R17
	DEC        R27
	BRNE       L__reverseBits363
L__reverseBits364:
	AND        R16, R2
	ANDI       R17, 0
	MOV        R27, R16
	OR         R27, R17
	BRNE       L__reverseBits365
	JMP        L__reverseBits207
L__reverseBits365:
;Digital_tone_Control_firmware.c,75 :: 		reverse_num |= 1 << ((NO_OF_BITS - 1) - i);
	MOV        R16, R18
	SUBI       R16, 1
	SUB        R16, R20
	MOV        R27, R16
	LDI        R16, 1
	TST        R27
	BREQ       L__reverseBits367
L__reverseBits366:
	LSL        R16
	DEC        R27
	BRNE       L__reverseBits366
L__reverseBits367:
	OR         R16, R22
	MOV        R22, R16
; reverse_num end address is: 22 (R22)
	JMP        L_reverseBits3
L__reverseBits207:
;Digital_tone_Control_firmware.c,74 :: 		if((num & (1 << i)))
;Digital_tone_Control_firmware.c,75 :: 		reverse_num |= 1 << ((NO_OF_BITS - 1) - i);
L_reverseBits3:
;Digital_tone_Control_firmware.c,72 :: 		for (i = 0; i < NO_OF_BITS; i++)
; reverse_num start address is: 22 (R22)
	MOVW       R16, R20
	SUBI       R16, 255
	SBCI       R17, 255
	MOVW       R20, R16
;Digital_tone_Control_firmware.c,76 :: 		}
; NO_OF_BITS end address is: 18 (R18)
; i end address is: 20 (R20)
	JMP        L_reverseBits0
L_reverseBits1:
;Digital_tone_Control_firmware.c,77 :: 		return reverse_num;
	MOV        R16, R22
; reverse_num end address is: 22 (R22)
;Digital_tone_Control_firmware.c,78 :: 		}
L_end_reverseBits:
	RET
; end of _reverseBits

_set_parameter:

;Digital_tone_Control_firmware.c,80 :: 		void set_parameter()
;Digital_tone_Control_firmware.c,82 :: 		CE=1;
	PUSH       R2
	IN         R27, PORTB0_bit+0
	SBR        R27, BitMask(PORTB0_bit+0)
	OUT        PORTB0_bit+0, R27
;Digital_tone_Control_firmware.c,83 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_set_parameter4:
	DEC        R16
	BRNE       L_set_parameter4
	DEC        R17
	BRNE       L_set_parameter4
	NOP
	NOP
;Digital_tone_Control_firmware.c,84 :: 		CE=0;                     //Send Address
	IN         R27, PORTB0_bit+0
	CBR        R27, BitMask(PORTB0_bit+0)
	OUT        PORTB0_bit+0, R27
;Digital_tone_Control_firmware.c,85 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_set_parameter6:
	DEC        R16
	BRNE       L_set_parameter6
	DEC        R17
	BRNE       L_set_parameter6
	NOP
	NOP
;Digital_tone_Control_firmware.c,86 :: 		buffer=reverseBits(address_code);
	LDI        R27, 130
	MOV        R2, R27
	CALL       _reverseBits+0
	STS        _buffer+0, R16
;Digital_tone_Control_firmware.c,87 :: 		SPI1_Write(buffer);
	MOV        R2, R16
	CALL       _SPI1_Write+0
;Digital_tone_Control_firmware.c,88 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_set_parameter8:
	DEC        R16
	BRNE       L_set_parameter8
	DEC        R17
	BRNE       L_set_parameter8
	NOP
	NOP
;Digital_tone_Control_firmware.c,89 :: 		CE=1;                    //Set parameter
	IN         R27, PORTB0_bit+0
	SBR        R27, BitMask(PORTB0_bit+0)
	OUT        PORTB0_bit+0, R27
;Digital_tone_Control_firmware.c,90 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_set_parameter10:
	DEC        R16
	BRNE       L_set_parameter10
	DEC        R17
	BRNE       L_set_parameter10
	NOP
	NOP
;Digital_tone_Control_firmware.c,92 :: 		buffer=reverseBits(channel_select);
	LDS        R2, _channel_select+0
	CALL       _reverseBits+0
	STS        _buffer+0, R16
;Digital_tone_Control_firmware.c,93 :: 		buffer&=0xF0;
	ANDI       R16, 240
	STS        _buffer+0, R16
;Digital_tone_Control_firmware.c,94 :: 		temp=reverseBits(input_gain);
	LDS        R2, _input_gain+0
	CALL       _reverseBits+0
	STS        _temp+0, R16
;Digital_tone_Control_firmware.c,95 :: 		temp>>=4;             //must align to lower nibble
	LSR        R16
	LSR        R16
	LSR        R16
	LSR        R16
	STS        _temp+0, R16
;Digital_tone_Control_firmware.c,96 :: 		temp&=0x0F;
	MOV        R17, R16
	ANDI       R17, 15
	STS        _temp+0, R17
;Digital_tone_Control_firmware.c,97 :: 		buffer|=temp;
	LDS        R16, _buffer+0
	OR         R16, R17
	STS        _buffer+0, R16
;Digital_tone_Control_firmware.c,98 :: 		SPI1_Write(buffer);     //set channel and input gain
	MOV        R2, R16
	CALL       _SPI1_Write+0
;Digital_tone_Control_firmware.c,99 :: 		delay_us(100);
	LDI        R16, 33
L_set_parameter12:
	DEC        R16
	BRNE       L_set_parameter12
	NOP
;Digital_tone_Control_firmware.c,100 :: 		buffer=reverseBits(volume);
	LDS        R2, _volume+0
	CALL       _reverseBits+0
	STS        _buffer+0, R16
;Digital_tone_Control_firmware.c,101 :: 		SPI1_Write(buffer);     //set volume
	MOV        R2, R16
	CALL       _SPI1_Write+0
;Digital_tone_Control_firmware.c,102 :: 		delay_us(100);
	LDI        R16, 33
L_set_parameter14:
	DEC        R16
	BRNE       L_set_parameter14
	NOP
;Digital_tone_Control_firmware.c,103 :: 		buffer=reverseBits(treble);
	LDS        R2, _treble+0
	CALL       _reverseBits+0
	STS        _buffer+0, R16
;Digital_tone_Control_firmware.c,104 :: 		buffer&=0xF0;
	ANDI       R16, 240
	STS        _buffer+0, R16
;Digital_tone_Control_firmware.c,105 :: 		temp=reverseBits(bass);
	LDS        R2, _bass+0
	CALL       _reverseBits+0
	STS        _temp+0, R16
;Digital_tone_Control_firmware.c,106 :: 		temp>>=4;                //align to lower nibble
	LSR        R16
	LSR        R16
	LSR        R16
	LSR        R16
	STS        _temp+0, R16
;Digital_tone_Control_firmware.c,107 :: 		temp&=0x0F;             //align for 4 bits  D24 & D25 always zero
	MOV        R17, R16
	ANDI       R17, 15
	STS        _temp+0, R17
;Digital_tone_Control_firmware.c,108 :: 		buffer|=temp;
	LDS        R16, _buffer+0
	OR         R16, R17
	STS        _buffer+0, R16
;Digital_tone_Control_firmware.c,109 :: 		SPI1_Write(buffer);     //set treble and bass
	MOV        R2, R16
	CALL       _SPI1_Write+0
;Digital_tone_Control_firmware.c,110 :: 		delay_us(100);
	LDI        R16, 33
L_set_parameter16:
	DEC        R16
	BRNE       L_set_parameter16
	NOP
;Digital_tone_Control_firmware.c,112 :: 		buffer=0;
	LDI        R27, 0
	STS        _buffer+0, R27
;Digital_tone_Control_firmware.c,113 :: 		temp=reverseBits(channel_active);
	LDS        R2, _channel_active+0
	CALL       _reverseBits+0
	STS        _temp+0, R16
;Digital_tone_Control_firmware.c,114 :: 		temp>>=2;
	LSR        R16
	LSR        R16
	STS        _temp+0, R16
;Digital_tone_Control_firmware.c,115 :: 		temp&=0b00110000;
	MOV        R17, R16
	ANDI       R17, 48
	STS        _temp+0, R17
;Digital_tone_Control_firmware.c,116 :: 		buffer|=temp;
	LDS        R16, _buffer+0
	OR         R16, R17
	STS        _buffer+0, R16
;Digital_tone_Control_firmware.c,118 :: 		SPI1_Write(buffer);  //bass and channel active  0x30 (both channel , zero test mode)
	MOV        R2, R16
	CALL       _SPI1_Write+0
;Digital_tone_Control_firmware.c,119 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_set_parameter18:
	DEC        R16
	BRNE       L_set_parameter18
	DEC        R17
	BRNE       L_set_parameter18
	NOP
	NOP
;Digital_tone_Control_firmware.c,120 :: 		CE=0;
	IN         R27, PORTB0_bit+0
	CBR        R27, BitMask(PORTB0_bit+0)
	OUT        PORTB0_bit+0, R27
;Digital_tone_Control_firmware.c,121 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_set_parameter20:
	DEC        R16
	BRNE       L_set_parameter20
	DEC        R17
	BRNE       L_set_parameter20
	NOP
	NOP
;Digital_tone_Control_firmware.c,123 :: 		}
L_end_set_parameter:
	POP        R2
	RET
; end of _set_parameter

_Timer1Overflow_ISR:
	PUSH       R30
	PUSH       R31
	PUSH       R27
	IN         R27, SREG+0
	PUSH       R27

;Digital_tone_Control_firmware.c,126 :: 		void Timer1Overflow_ISR() org IVT_ADDR_TIMER1_OVF {
;Digital_tone_Control_firmware.c,128 :: 		if (counter >= THRESHOLD) {
	LDS        R16, _counter+0
	CPI        R16, 8
	BRSH       L__Timer1Overflow_ISR370
	JMP        L_Timer1Overflow_ISR22
L__Timer1Overflow_ISR370:
;Digital_tone_Control_firmware.c,129 :: 		blink = ~blink;             // toggle PORTD
	IN         R0, PORTD7_bit+0
	LDI        R27, BitMask(PORTD7_bit+0)
	EOR        R0, R27
	OUT        PORTD7_bit+0, R0
;Digital_tone_Control_firmware.c,130 :: 		counter = 0;                // reset counter
	LDI        R27, 0
	STS        _counter+0, R27
;Digital_tone_Control_firmware.c,131 :: 		}
	JMP        L_Timer1Overflow_ISR23
L_Timer1Overflow_ISR22:
;Digital_tone_Control_firmware.c,133 :: 		counter++;                  // increment counter
	LDS        R16, _counter+0
	SUBI       R16, 255
	STS        _counter+0, R16
L_Timer1Overflow_ISR23:
;Digital_tone_Control_firmware.c,135 :: 		if(sample_counter>=sample)
	LDS        R16, _sample_counter+0
	CPI        R16, 4
	BRSH       L__Timer1Overflow_ISR373
	JMP        L_Timer1Overflow_ISR24
L__Timer1Overflow_ISR373:
;Digital_tone_Control_firmware.c,137 :: 		Read_potentiometer();
	CALL       _Read_potentiometer+0
;Digital_tone_Control_firmware.c,138 :: 		sample_counter=0;
	LDI        R27, 0
	STS        _sample_counter+0, R27
;Digital_tone_Control_firmware.c,141 :: 		}
	JMP        L_Timer1Overflow_ISR25
L_Timer1Overflow_ISR24:
;Digital_tone_Control_firmware.c,143 :: 		sample_counter++;
	LDS        R16, _sample_counter+0
	SUBI       R16, 255
	STS        _sample_counter+0, R16
L_Timer1Overflow_ISR25:
;Digital_tone_Control_firmware.c,145 :: 		}
L_end_Timer1Overflow_ISR:
	POP        R27
	OUT        SREG+0, R27
	POP        R27
	POP        R31
	POP        R30
	RETI
; end of _Timer1Overflow_ISR

_SPI_init:

;Digital_tone_Control_firmware.c,147 :: 		void SPI_init()
;Digital_tone_Control_firmware.c,149 :: 		Chip_Select = 1;                        // Deselect
	IN         R27, PORTB2_bit+0
	SBR        R27, BitMask(PORTB2_bit+0)
	OUT        PORTB2_bit+0, R27
;Digital_tone_Control_firmware.c,150 :: 		Chip_Select_Direction = 1;              // Set CS# pin as Output
	IN         R27, DDB2_bit+0
	SBR        R27, BitMask(DDB2_bit+0)
	OUT        DDB2_bit+0, R27
;Digital_tone_Control_firmware.c,151 :: 		CE=1;
	IN         R27, PORTB0_bit+0
	SBR        R27, BitMask(PORTB0_bit+0)
	OUT        PORTB0_bit+0, R27
;Digital_tone_Control_firmware.c,152 :: 		CE_Direction = 1;             //Set PB0 pin as output
	IN         R27, DDB0_bit+0
	SBR        R27, BitMask(DDB0_bit+0)
	OUT        DDB0_bit+0, R27
;Digital_tone_Control_firmware.c,153 :: 		SPI1_Init();
	CALL       _SPI1_Init+0
;Digital_tone_Control_firmware.c,155 :: 		}
L_end_SPI_init:
	RET
; end of _SPI_init

_ADC_setup:

;Digital_tone_Control_firmware.c,157 :: 		void ADC_setup()
;Digital_tone_Control_firmware.c,159 :: 		ADC_Init();
	CALL       _ADC_Init+0
;Digital_tone_Control_firmware.c,160 :: 		}
L_end_ADC_setup:
	RET
; end of _ADC_setup

_Read_Potentiometer:

;Digital_tone_Control_firmware.c,162 :: 		void Read_Potentiometer()
;Digital_tone_Control_firmware.c,165 :: 		volume_rdg=ADC_Get_Sample(0);
	PUSH       R2
	PUSH       R3
	CLR        R2
	CALL       _ADC_Get_Sample+0
	STS        _volume_rdg+0, R16
	STS        _volume_rdg+1, R17
;Digital_tone_Control_firmware.c,166 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_Read_Potentiometer26:
	DEC        R16
	BRNE       L_Read_Potentiometer26
	DEC        R17
	BRNE       L_Read_Potentiometer26
	NOP
	NOP
;Digital_tone_Control_firmware.c,167 :: 		if(volume_rdg<=10) {
	LDS        R18, _volume_rdg+0
	LDS        R19, _volume_rdg+1
	LDI        R16, 10
	LDI        R17, 0
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer377
	JMP        L_Read_Potentiometer28
L__Read_Potentiometer377:
;Digital_tone_Control_firmware.c,168 :: 		volume=80;
	LDI        R27, 80
	STS        _volume+0, R27
;Digital_tone_Control_firmware.c,169 :: 		volume_level=80;}            //Needed by balance
	LDI        R27, 80
	STS        _volume_level+0, R27
	JMP        L_Read_Potentiometer29
L_Read_Potentiometer28:
;Digital_tone_Control_firmware.c,171 :: 		volume_level=abs(80-volume_rdg/13);       //1024 highest volume ADC
	LDI        R20, 13
	LDI        R21, 0
	LDS        R16, _volume_rdg+0
	LDS        R17, _volume_rdg+1
	CALL       _Div_16x16_S+0
	MOVW       R16, R22
	MOVW       R0, R16
	LDI        R16, 80
	LDI        R17, 0
	SUB        R16, R0
	SBC        R17, R1
	MOVW       R2, R16
	CALL       _abs+0
	STS        _volume_level+0, R16
;Digital_tone_Control_firmware.c,172 :: 		volume=volume_level;                                     // 0 -highest volume
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,173 :: 		}
L_Read_Potentiometer29:
;Digital_tone_Control_firmware.c,175 :: 		balance_rdg=ADC_Get_Sample(1);        //balance
	LDI        R27, 1
	MOV        R2, R27
	CALL       _ADC_Get_Sample+0
	STS        _balance_rdg+0, R16
	STS        _balance_rdg+1, R17
;Digital_tone_Control_firmware.c,176 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_Read_Potentiometer30:
	DEC        R16
	BRNE       L_Read_Potentiometer30
	DEC        R17
	BRNE       L_Read_Potentiometer30
	NOP
	NOP
;Digital_tone_Control_firmware.c,198 :: 		if(balance_rdg>=0 && balance_rdg<=85) //lowest level
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 0
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer378
	JMP        L__Read_Potentiometer260
L__Read_Potentiometer378:
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 85
	LDI        R17, 0
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer379
	JMP        L__Read_Potentiometer259
L__Read_Potentiometer379:
L__Read_Potentiometer258:
;Digital_tone_Control_firmware.c,199 :: 		{ channel_active=2;         // 2 -right  min      1-left  max
	LDI        R27, 2
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,200 :: 		volume=volume_level+30;
	LDS        R16, _volume_level+0
	SUBI       R16, 226
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,201 :: 		if(volume>=80) volume=80;
	CPI        R16, 80
	BRSH       L__Read_Potentiometer380
	JMP        L_Read_Potentiometer35
L__Read_Potentiometer380:
	LDI        R27, 80
	STS        _volume+0, R27
L_Read_Potentiometer35:
;Digital_tone_Control_firmware.c,202 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,203 :: 		channel_active=1;
	LDI        R27, 1
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,204 :: 		volume=volume_level;
	LDS        R16, _volume_level+0
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,205 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,198 :: 		if(balance_rdg>=0 && balance_rdg<=85) //lowest level
L__Read_Potentiometer260:
L__Read_Potentiometer259:
;Digital_tone_Control_firmware.c,207 :: 		if(balance_rdg>=86 && balance_rdg<=170)
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 86
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer381
	JMP        L__Read_Potentiometer262
L__Read_Potentiometer381:
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 170
	LDI        R17, 0
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer382
	JMP        L__Read_Potentiometer261
L__Read_Potentiometer382:
L__Read_Potentiometer257:
;Digital_tone_Control_firmware.c,208 :: 		{ channel_active=2;
	LDI        R27, 2
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,209 :: 		volume=volume_level+15;
	LDS        R16, _volume_level+0
	SUBI       R16, 241
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,210 :: 		if(volume>=80) volume=80;
	CPI        R16, 80
	BRSH       L__Read_Potentiometer383
	JMP        L_Read_Potentiometer39
L__Read_Potentiometer383:
	LDI        R27, 80
	STS        _volume+0, R27
L_Read_Potentiometer39:
;Digital_tone_Control_firmware.c,211 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,212 :: 		channel_active=1;
	LDI        R27, 1
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,213 :: 		volume=volume_level;
	LDS        R16, _volume_level+0
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,214 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,207 :: 		if(balance_rdg>=86 && balance_rdg<=170)
L__Read_Potentiometer262:
L__Read_Potentiometer261:
;Digital_tone_Control_firmware.c,216 :: 		if(balance_rdg>=171 && balance_rdg<=255)
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 171
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer384
	JMP        L__Read_Potentiometer264
L__Read_Potentiometer384:
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 255
	LDI        R17, 0
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer385
	JMP        L__Read_Potentiometer263
L__Read_Potentiometer385:
L__Read_Potentiometer256:
;Digital_tone_Control_firmware.c,217 :: 		{ channel_active=2;
	LDI        R27, 2
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,218 :: 		volume=volume_level+10;
	LDS        R16, _volume_level+0
	SUBI       R16, 246
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,219 :: 		if(volume>=80) volume=80;
	CPI        R16, 80
	BRSH       L__Read_Potentiometer386
	JMP        L_Read_Potentiometer43
L__Read_Potentiometer386:
	LDI        R27, 80
	STS        _volume+0, R27
L_Read_Potentiometer43:
;Digital_tone_Control_firmware.c,220 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,221 :: 		channel_active=1;
	LDI        R27, 1
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,222 :: 		volume=volume_level;
	LDS        R16, _volume_level+0
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,223 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,216 :: 		if(balance_rdg>=171 && balance_rdg<=255)
L__Read_Potentiometer264:
L__Read_Potentiometer263:
;Digital_tone_Control_firmware.c,225 :: 		if(balance_rdg>=256 && balance_rdg<=340)
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 0
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer387
	JMP        L__Read_Potentiometer266
L__Read_Potentiometer387:
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 84
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer388
	JMP        L__Read_Potentiometer265
L__Read_Potentiometer388:
L__Read_Potentiometer255:
;Digital_tone_Control_firmware.c,226 :: 		{ channel_active=2;
	LDI        R27, 2
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,227 :: 		volume=volume_level+7;
	LDS        R16, _volume_level+0
	SUBI       R16, 249
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,228 :: 		if(volume>=80) volume=80;
	CPI        R16, 80
	BRSH       L__Read_Potentiometer389
	JMP        L_Read_Potentiometer47
L__Read_Potentiometer389:
	LDI        R27, 80
	STS        _volume+0, R27
L_Read_Potentiometer47:
;Digital_tone_Control_firmware.c,229 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,230 :: 		channel_active=1;
	LDI        R27, 1
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,231 :: 		volume=volume_level;
	LDS        R16, _volume_level+0
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,232 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,225 :: 		if(balance_rdg>=256 && balance_rdg<=340)
L__Read_Potentiometer266:
L__Read_Potentiometer265:
;Digital_tone_Control_firmware.c,234 :: 		if(balance_rdg>=341 && balance_rdg<=425)
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 85
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer390
	JMP        L__Read_Potentiometer268
L__Read_Potentiometer390:
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 169
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer391
	JMP        L__Read_Potentiometer267
L__Read_Potentiometer391:
L__Read_Potentiometer254:
;Digital_tone_Control_firmware.c,235 :: 		{ channel_active=2;
	LDI        R27, 2
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,236 :: 		volume=volume_level+5;
	LDS        R16, _volume_level+0
	SUBI       R16, 251
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,237 :: 		if(volume>=80) volume=80;
	CPI        R16, 80
	BRSH       L__Read_Potentiometer392
	JMP        L_Read_Potentiometer51
L__Read_Potentiometer392:
	LDI        R27, 80
	STS        _volume+0, R27
L_Read_Potentiometer51:
;Digital_tone_Control_firmware.c,238 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,239 :: 		channel_active=1;
	LDI        R27, 1
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,240 :: 		volume=volume_level;
	LDS        R16, _volume_level+0
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,241 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,234 :: 		if(balance_rdg>=341 && balance_rdg<=425)
L__Read_Potentiometer268:
L__Read_Potentiometer267:
;Digital_tone_Control_firmware.c,243 :: 		if(balance_rdg>=426 && balance_rdg<=510)  //Center
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 170
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer393
	JMP        L__Read_Potentiometer270
L__Read_Potentiometer393:
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 254
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer394
	JMP        L__Read_Potentiometer269
L__Read_Potentiometer394:
L__Read_Potentiometer253:
;Digital_tone_Control_firmware.c,244 :: 		{ channel_active=3;
	LDI        R27, 3
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,245 :: 		volume=volume_level;
	LDS        R16, _volume_level+0
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,246 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,243 :: 		if(balance_rdg>=426 && balance_rdg<=510)  //Center
L__Read_Potentiometer270:
L__Read_Potentiometer269:
;Digital_tone_Control_firmware.c,249 :: 		if(balance_rdg>=511 && balance_rdg<=595)    //2 -right   1 -left
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 255
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer395
	JMP        L__Read_Potentiometer272
L__Read_Potentiometer395:
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 83
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer396
	JMP        L__Read_Potentiometer271
L__Read_Potentiometer396:
L__Read_Potentiometer252:
;Digital_tone_Control_firmware.c,250 :: 		{ channel_active=1;
	LDI        R27, 1
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,251 :: 		volume=volume_level+5;
	LDS        R16, _volume_level+0
	MOV        R17, R16
	SUBI       R17, 251
	STS        _volume+0, R17
;Digital_tone_Control_firmware.c,252 :: 		if(volume>80) volume=80;
	LDI        R16, 80
	CP         R16, R17
	BRLO       L__Read_Potentiometer397
	JMP        L_Read_Potentiometer58
L__Read_Potentiometer397:
	LDI        R27, 80
	STS        _volume+0, R27
L_Read_Potentiometer58:
;Digital_tone_Control_firmware.c,253 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,254 :: 		volume=volume_level;
	LDS        R16, _volume_level+0
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,255 :: 		channel_active=2;
	LDI        R27, 2
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,256 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,249 :: 		if(balance_rdg>=511 && balance_rdg<=595)    //2 -right   1 -left
L__Read_Potentiometer272:
L__Read_Potentiometer271:
;Digital_tone_Control_firmware.c,258 :: 		if(balance_rdg>=596 && balance_rdg<=680)
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 84
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer398
	JMP        L__Read_Potentiometer274
L__Read_Potentiometer398:
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 168
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer399
	JMP        L__Read_Potentiometer273
L__Read_Potentiometer399:
L__Read_Potentiometer251:
;Digital_tone_Control_firmware.c,259 :: 		{ channel_active=1;
	LDI        R27, 1
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,260 :: 		volume=volume_level+7;
	LDS        R16, _volume_level+0
	MOV        R17, R16
	SUBI       R17, 249
	STS        _volume+0, R17
;Digital_tone_Control_firmware.c,261 :: 		if(volume>80) volume=80;
	LDI        R16, 80
	CP         R16, R17
	BRLO       L__Read_Potentiometer400
	JMP        L_Read_Potentiometer62
L__Read_Potentiometer400:
	LDI        R27, 80
	STS        _volume+0, R27
L_Read_Potentiometer62:
;Digital_tone_Control_firmware.c,262 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,263 :: 		channel_active=2;
	LDI        R27, 2
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,264 :: 		volume=volume_level;
	LDS        R16, _volume_level+0
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,265 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,258 :: 		if(balance_rdg>=596 && balance_rdg<=680)
L__Read_Potentiometer274:
L__Read_Potentiometer273:
;Digital_tone_Control_firmware.c,268 :: 		if(balance_rdg>=681 && balance_rdg<=765)
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 169
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer401
	JMP        L__Read_Potentiometer276
L__Read_Potentiometer401:
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 253
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer402
	JMP        L__Read_Potentiometer275
L__Read_Potentiometer402:
L__Read_Potentiometer250:
;Digital_tone_Control_firmware.c,269 :: 		{ channel_active=1;
	LDI        R27, 1
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,270 :: 		volume=volume_level+10;
	LDS        R16, _volume_level+0
	MOV        R17, R16
	SUBI       R17, 246
	STS        _volume+0, R17
;Digital_tone_Control_firmware.c,271 :: 		if(volume>80) volume=80;
	LDI        R16, 80
	CP         R16, R17
	BRLO       L__Read_Potentiometer403
	JMP        L_Read_Potentiometer66
L__Read_Potentiometer403:
	LDI        R27, 80
	STS        _volume+0, R27
L_Read_Potentiometer66:
;Digital_tone_Control_firmware.c,272 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,273 :: 		channel_active=2;
	LDI        R27, 2
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,274 :: 		volume=volume_level;
	LDS        R16, _volume_level+0
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,275 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,268 :: 		if(balance_rdg>=681 && balance_rdg<=765)
L__Read_Potentiometer276:
L__Read_Potentiometer275:
;Digital_tone_Control_firmware.c,278 :: 		if(balance_rdg>=766 && balance_rdg<=850)
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 254
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer404
	JMP        L__Read_Potentiometer278
L__Read_Potentiometer404:
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 82
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer405
	JMP        L__Read_Potentiometer277
L__Read_Potentiometer405:
L__Read_Potentiometer249:
;Digital_tone_Control_firmware.c,279 :: 		{ channel_active=1;
	LDI        R27, 1
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,280 :: 		volume=volume_level+15;
	LDS        R16, _volume_level+0
	MOV        R17, R16
	SUBI       R17, 241
	STS        _volume+0, R17
;Digital_tone_Control_firmware.c,281 :: 		if(volume>80) volume=80;
	LDI        R16, 80
	CP         R16, R17
	BRLO       L__Read_Potentiometer406
	JMP        L_Read_Potentiometer70
L__Read_Potentiometer406:
	LDI        R27, 80
	STS        _volume+0, R27
L_Read_Potentiometer70:
;Digital_tone_Control_firmware.c,282 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,283 :: 		channel_active=2;
	LDI        R27, 2
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,284 :: 		volume=volume_level;
	LDS        R16, _volume_level+0
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,285 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,278 :: 		if(balance_rdg>=766 && balance_rdg<=850)
L__Read_Potentiometer278:
L__Read_Potentiometer277:
;Digital_tone_Control_firmware.c,288 :: 		if(balance_rdg>=851 && balance_rdg<=1023)
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 83
	LDI        R17, 3
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer407
	JMP        L__Read_Potentiometer280
L__Read_Potentiometer407:
	LDS        R18, _balance_rdg+0
	LDS        R19, _balance_rdg+1
	LDI        R16, 255
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer408
	JMP        L__Read_Potentiometer279
L__Read_Potentiometer408:
L__Read_Potentiometer248:
;Digital_tone_Control_firmware.c,289 :: 		{ channel_active=1;
	LDI        R27, 1
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,290 :: 		volume=volume_level+30;
	LDS        R16, _volume_level+0
	MOV        R17, R16
	SUBI       R17, 226
	STS        _volume+0, R17
;Digital_tone_Control_firmware.c,291 :: 		if(volume>80) volume=80;
	LDI        R16, 80
	CP         R16, R17
	BRLO       L__Read_Potentiometer409
	JMP        L_Read_Potentiometer74
L__Read_Potentiometer409:
	LDI        R27, 80
	STS        _volume+0, R27
L_Read_Potentiometer74:
;Digital_tone_Control_firmware.c,292 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,293 :: 		channel_active=2;
	LDI        R27, 2
	STS        _channel_active+0, R27
;Digital_tone_Control_firmware.c,294 :: 		volume=volume_level;
	LDS        R16, _volume_level+0
	STS        _volume+0, R16
;Digital_tone_Control_firmware.c,295 :: 		set_parameter();
	CALL       _set_parameter+0
;Digital_tone_Control_firmware.c,288 :: 		if(balance_rdg>=851 && balance_rdg<=1023)
L__Read_Potentiometer280:
L__Read_Potentiometer279:
;Digital_tone_Control_firmware.c,300 :: 		treble_rdg=ADC_Get_Sample(2);      //treble
	LDI        R27, 2
	MOV        R2, R27
	CALL       _ADC_Get_Sample+0
	STS        _treble_rdg+0, R16
	STS        _treble_rdg+1, R17
;Digital_tone_Control_firmware.c,301 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_Read_Potentiometer75:
	DEC        R16
	BRNE       L_Read_Potentiometer75
	DEC        R17
	BRNE       L_Read_Potentiometer75
	NOP
	NOP
;Digital_tone_Control_firmware.c,302 :: 		if(treble_rdg>=0 && treble_rdg<=102) treble=13;
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 0
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer410
	JMP        L__Read_Potentiometer282
L__Read_Potentiometer410:
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 102
	LDI        R17, 0
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer411
	JMP        L__Read_Potentiometer281
L__Read_Potentiometer411:
L__Read_Potentiometer247:
	LDI        R27, 13
	STS        _treble+0, R27
L__Read_Potentiometer282:
L__Read_Potentiometer281:
;Digital_tone_Control_firmware.c,303 :: 		if(treble_rdg>=103 && treble_rdg<=204) treble=12;
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 103
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer412
	JMP        L__Read_Potentiometer284
L__Read_Potentiometer412:
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 204
	LDI        R17, 0
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer413
	JMP        L__Read_Potentiometer283
L__Read_Potentiometer413:
L__Read_Potentiometer246:
	LDI        R27, 12
	STS        _treble+0, R27
L__Read_Potentiometer284:
L__Read_Potentiometer283:
;Digital_tone_Control_firmware.c,304 :: 		if(treble_rdg>=205 && treble_rdg<=306) treble=11;
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 205
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer414
	JMP        L__Read_Potentiometer286
L__Read_Potentiometer414:
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 50
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer415
	JMP        L__Read_Potentiometer285
L__Read_Potentiometer415:
L__Read_Potentiometer245:
	LDI        R27, 11
	STS        _treble+0, R27
L__Read_Potentiometer286:
L__Read_Potentiometer285:
;Digital_tone_Control_firmware.c,305 :: 		if(treble_rdg>=307 && treble_rdg<=406) treble=10;
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 51
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer416
	JMP        L__Read_Potentiometer288
L__Read_Potentiometer416:
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 150
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer417
	JMP        L__Read_Potentiometer287
L__Read_Potentiometer417:
L__Read_Potentiometer244:
	LDI        R27, 10
	STS        _treble+0, R27
L__Read_Potentiometer288:
L__Read_Potentiometer287:
;Digital_tone_Control_firmware.c,306 :: 		if(treble_rdg>=407 && treble_rdg<=508) treble=9;
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 151
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer418
	JMP        L__Read_Potentiometer290
L__Read_Potentiometer418:
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 252
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer419
	JMP        L__Read_Potentiometer289
L__Read_Potentiometer419:
L__Read_Potentiometer243:
	LDI        R27, 9
	STS        _treble+0, R27
L__Read_Potentiometer290:
L__Read_Potentiometer289:
;Digital_tone_Control_firmware.c,307 :: 		if(treble_rdg>=509 && treble_rdg<=512) treble=0;
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 253
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer420
	JMP        L__Read_Potentiometer292
L__Read_Potentiometer420:
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 0
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer421
	JMP        L__Read_Potentiometer291
L__Read_Potentiometer421:
L__Read_Potentiometer242:
	LDI        R27, 0
	STS        _treble+0, R27
L__Read_Potentiometer292:
L__Read_Potentiometer291:
;Digital_tone_Control_firmware.c,308 :: 		if(treble_rdg>=513 && treble_rdg<=615) treble=1;
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 1
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer422
	JMP        L__Read_Potentiometer294
L__Read_Potentiometer422:
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 103
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer423
	JMP        L__Read_Potentiometer293
L__Read_Potentiometer423:
L__Read_Potentiometer241:
	LDI        R27, 1
	STS        _treble+0, R27
L__Read_Potentiometer294:
L__Read_Potentiometer293:
;Digital_tone_Control_firmware.c,309 :: 		if(treble_rdg>=616 && treble_rdg<=717) treble=2;
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 104
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer424
	JMP        L__Read_Potentiometer296
L__Read_Potentiometer424:
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 205
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer425
	JMP        L__Read_Potentiometer295
L__Read_Potentiometer425:
L__Read_Potentiometer240:
	LDI        R27, 2
	STS        _treble+0, R27
L__Read_Potentiometer296:
L__Read_Potentiometer295:
;Digital_tone_Control_firmware.c,310 :: 		if(treble_rdg>=718 && treble_rdg<=819) treble=3;
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 206
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer426
	JMP        L__Read_Potentiometer298
L__Read_Potentiometer426:
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 51
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer427
	JMP        L__Read_Potentiometer297
L__Read_Potentiometer427:
L__Read_Potentiometer239:
	LDI        R27, 3
	STS        _treble+0, R27
L__Read_Potentiometer298:
L__Read_Potentiometer297:
;Digital_tone_Control_firmware.c,311 :: 		if(treble_rdg>=820 && treble_rdg<=921) treble=4;
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 52
	LDI        R17, 3
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer428
	JMP        L__Read_Potentiometer300
L__Read_Potentiometer428:
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 153
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer429
	JMP        L__Read_Potentiometer299
L__Read_Potentiometer429:
L__Read_Potentiometer238:
	LDI        R27, 4
	STS        _treble+0, R27
L__Read_Potentiometer300:
L__Read_Potentiometer299:
;Digital_tone_Control_firmware.c,312 :: 		if(treble_rdg>=922 && treble_rdg<=1023) treble=5;
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 154
	LDI        R17, 3
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer430
	JMP        L__Read_Potentiometer302
L__Read_Potentiometer430:
	LDS        R18, _treble_rdg+0
	LDS        R19, _treble_rdg+1
	LDI        R16, 255
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer431
	JMP        L__Read_Potentiometer301
L__Read_Potentiometer431:
L__Read_Potentiometer237:
	LDI        R27, 5
	STS        _treble+0, R27
L__Read_Potentiometer302:
L__Read_Potentiometer301:
;Digital_tone_Control_firmware.c,315 :: 		bass_rdg=ADC_Get_Sample(3);      //bass
	LDI        R27, 3
	MOV        R2, R27
	CALL       _ADC_Get_Sample+0
	STS        _bass_rdg+0, R16
	STS        _bass_rdg+1, R17
;Digital_tone_Control_firmware.c,316 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_Read_Potentiometer110:
	DEC        R16
	BRNE       L_Read_Potentiometer110
	DEC        R17
	BRNE       L_Read_Potentiometer110
	NOP
	NOP
;Digital_tone_Control_firmware.c,317 :: 		if(bass_rdg==0)   bass=0;
	LDS        R16, _bass_rdg+0
	LDS        R17, _bass_rdg+1
	CPI        R17, 0
	BRNE       L__Read_Potentiometer432
	CPI        R16, 0
L__Read_Potentiometer432:
	BREQ       L__Read_Potentiometer433
	JMP        L_Read_Potentiometer112
L__Read_Potentiometer433:
	LDI        R27, 0
	STS        _bass+0, R27
L_Read_Potentiometer112:
;Digital_tone_Control_firmware.c,318 :: 		if(bass_rdg>=0 && bass_rdg<=102)  bass=1;
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 0
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer434
	JMP        L__Read_Potentiometer304
L__Read_Potentiometer434:
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 102
	LDI        R17, 0
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer435
	JMP        L__Read_Potentiometer303
L__Read_Potentiometer435:
L__Read_Potentiometer236:
	LDI        R27, 1
	STS        _bass+0, R27
L__Read_Potentiometer304:
L__Read_Potentiometer303:
;Digital_tone_Control_firmware.c,319 :: 		if(bass_rdg>=103 && bass_rdg<=204)bass=2;
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 103
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer436
	JMP        L__Read_Potentiometer306
L__Read_Potentiometer436:
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 204
	LDI        R17, 0
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer437
	JMP        L__Read_Potentiometer305
L__Read_Potentiometer437:
L__Read_Potentiometer235:
	LDI        R27, 2
	STS        _bass+0, R27
L__Read_Potentiometer306:
L__Read_Potentiometer305:
;Digital_tone_Control_firmware.c,320 :: 		if(bass_rdg>=205 && bass_rdg<=306)bass=3;
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 205
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer438
	JMP        L__Read_Potentiometer308
L__Read_Potentiometer438:
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 50
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer439
	JMP        L__Read_Potentiometer307
L__Read_Potentiometer439:
L__Read_Potentiometer234:
	LDI        R27, 3
	STS        _bass+0, R27
L__Read_Potentiometer308:
L__Read_Potentiometer307:
;Digital_tone_Control_firmware.c,321 :: 		if(bass_rdg>=307 && bass_rdg<=408)bass=4;
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 51
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer440
	JMP        L__Read_Potentiometer310
L__Read_Potentiometer440:
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 152
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer441
	JMP        L__Read_Potentiometer309
L__Read_Potentiometer441:
L__Read_Potentiometer233:
	LDI        R27, 4
	STS        _bass+0, R27
L__Read_Potentiometer310:
L__Read_Potentiometer309:
;Digital_tone_Control_firmware.c,322 :: 		if(bass_rdg>=409 && bass_rdg<=510)bass=5;
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 153
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer442
	JMP        L__Read_Potentiometer312
L__Read_Potentiometer442:
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 254
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer443
	JMP        L__Read_Potentiometer311
L__Read_Potentiometer443:
L__Read_Potentiometer232:
	LDI        R27, 5
	STS        _bass+0, R27
L__Read_Potentiometer312:
L__Read_Potentiometer311:
;Digital_tone_Control_firmware.c,323 :: 		if(bass_rdg>=511 && bass_rdg<=612)bass=6;
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 255
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer444
	JMP        L__Read_Potentiometer314
L__Read_Potentiometer444:
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 100
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer445
	JMP        L__Read_Potentiometer313
L__Read_Potentiometer445:
L__Read_Potentiometer231:
	LDI        R27, 6
	STS        _bass+0, R27
L__Read_Potentiometer314:
L__Read_Potentiometer313:
;Digital_tone_Control_firmware.c,324 :: 		if(bass_rdg>=613 && bass_rdg<=714)bass=7;
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 101
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer446
	JMP        L__Read_Potentiometer316
L__Read_Potentiometer446:
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 202
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer447
	JMP        L__Read_Potentiometer315
L__Read_Potentiometer447:
L__Read_Potentiometer230:
	LDI        R27, 7
	STS        _bass+0, R27
L__Read_Potentiometer316:
L__Read_Potentiometer315:
;Digital_tone_Control_firmware.c,325 :: 		if(bass_rdg>=715 && bass_rdg<=816)bass=8;
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 203
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer448
	JMP        L__Read_Potentiometer318
L__Read_Potentiometer448:
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 48
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer449
	JMP        L__Read_Potentiometer317
L__Read_Potentiometer449:
L__Read_Potentiometer229:
	LDI        R27, 8
	STS        _bass+0, R27
L__Read_Potentiometer318:
L__Read_Potentiometer317:
;Digital_tone_Control_firmware.c,326 :: 		if(bass_rdg>=817 && bass_rdg<=918)bass=9;
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 49
	LDI        R17, 3
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer450
	JMP        L__Read_Potentiometer320
L__Read_Potentiometer450:
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 150
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer451
	JMP        L__Read_Potentiometer319
L__Read_Potentiometer451:
L__Read_Potentiometer228:
	LDI        R27, 9
	STS        _bass+0, R27
L__Read_Potentiometer320:
L__Read_Potentiometer319:
;Digital_tone_Control_firmware.c,327 :: 		if(bass_rdg>=919 && bass_rdg<=1023)bass=10;
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 151
	LDI        R17, 3
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer452
	JMP        L__Read_Potentiometer322
L__Read_Potentiometer452:
	LDS        R18, _bass_rdg+0
	LDS        R19, _bass_rdg+1
	LDI        R16, 255
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer453
	JMP        L__Read_Potentiometer321
L__Read_Potentiometer453:
L__Read_Potentiometer227:
	LDI        R27, 10
	STS        _bass+0, R27
L__Read_Potentiometer322:
L__Read_Potentiometer321:
;Digital_tone_Control_firmware.c,330 :: 		input_gain_rdg=ADC_Get_Sample(5);      //input_gain
	LDI        R27, 5
	MOV        R2, R27
	CALL       _ADC_Get_Sample+0
	STS        _input_gain_rdg+0, R16
	STS        _input_gain_rdg+1, R17
;Digital_tone_Control_firmware.c,331 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_Read_Potentiometer143:
	DEC        R16
	BRNE       L_Read_Potentiometer143
	DEC        R17
	BRNE       L_Read_Potentiometer143
	NOP
	NOP
;Digital_tone_Control_firmware.c,332 :: 		if(input_gain_rdg==0)   input_gain=0;
	LDS        R16, _input_gain_rdg+0
	LDS        R17, _input_gain_rdg+1
	CPI        R17, 0
	BRNE       L__Read_Potentiometer454
	CPI        R16, 0
L__Read_Potentiometer454:
	BREQ       L__Read_Potentiometer455
	JMP        L_Read_Potentiometer145
L__Read_Potentiometer455:
	LDI        R27, 0
	STS        _input_gain+0, R27
L_Read_Potentiometer145:
;Digital_tone_Control_firmware.c,333 :: 		if(input_gain_rdg>=0 && input_gain_rdg<=68)  input_gain=1;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 0
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer456
	JMP        L__Read_Potentiometer324
L__Read_Potentiometer456:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 68
	LDI        R17, 0
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer457
	JMP        L__Read_Potentiometer323
L__Read_Potentiometer457:
L__Read_Potentiometer226:
	LDI        R27, 1
	STS        _input_gain+0, R27
L__Read_Potentiometer324:
L__Read_Potentiometer323:
;Digital_tone_Control_firmware.c,334 :: 		if(input_gain_rdg>=69 && input_gain_rdg<=136)  input_gain=2;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 69
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer458
	JMP        L__Read_Potentiometer326
L__Read_Potentiometer458:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 136
	LDI        R17, 0
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer459
	JMP        L__Read_Potentiometer325
L__Read_Potentiometer459:
L__Read_Potentiometer225:
	LDI        R27, 2
	STS        _input_gain+0, R27
L__Read_Potentiometer326:
L__Read_Potentiometer325:
;Digital_tone_Control_firmware.c,335 :: 		if(input_gain_rdg>=137 && input_gain_rdg<=204)  input_gain=3;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 137
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer460
	JMP        L__Read_Potentiometer328
L__Read_Potentiometer460:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 204
	LDI        R17, 0
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer461
	JMP        L__Read_Potentiometer327
L__Read_Potentiometer461:
L__Read_Potentiometer224:
	LDI        R27, 3
	STS        _input_gain+0, R27
L__Read_Potentiometer328:
L__Read_Potentiometer327:
;Digital_tone_Control_firmware.c,336 :: 		if(input_gain_rdg>=205 && input_gain_rdg<=272)  input_gain=4;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 205
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer462
	JMP        L__Read_Potentiometer330
L__Read_Potentiometer462:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 16
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer463
	JMP        L__Read_Potentiometer329
L__Read_Potentiometer463:
L__Read_Potentiometer223:
	LDI        R27, 4
	STS        _input_gain+0, R27
L__Read_Potentiometer330:
L__Read_Potentiometer329:
;Digital_tone_Control_firmware.c,337 :: 		if(input_gain_rdg>=278 && input_gain_rdg<=340)  input_gain=5;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 22
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer464
	JMP        L__Read_Potentiometer332
L__Read_Potentiometer464:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 84
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer465
	JMP        L__Read_Potentiometer331
L__Read_Potentiometer465:
L__Read_Potentiometer222:
	LDI        R27, 5
	STS        _input_gain+0, R27
L__Read_Potentiometer332:
L__Read_Potentiometer331:
;Digital_tone_Control_firmware.c,338 :: 		if(input_gain_rdg>=341 && input_gain_rdg<=408)  input_gain=6;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 85
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer466
	JMP        L__Read_Potentiometer334
L__Read_Potentiometer466:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 152
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer467
	JMP        L__Read_Potentiometer333
L__Read_Potentiometer467:
L__Read_Potentiometer221:
	LDI        R27, 6
	STS        _input_gain+0, R27
L__Read_Potentiometer334:
L__Read_Potentiometer333:
;Digital_tone_Control_firmware.c,339 :: 		if(input_gain_rdg>=409 && input_gain_rdg<=476)  input_gain=7;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 153
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer468
	JMP        L__Read_Potentiometer336
L__Read_Potentiometer468:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 220
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer469
	JMP        L__Read_Potentiometer335
L__Read_Potentiometer469:
L__Read_Potentiometer220:
	LDI        R27, 7
	STS        _input_gain+0, R27
L__Read_Potentiometer336:
L__Read_Potentiometer335:
;Digital_tone_Control_firmware.c,340 :: 		if(input_gain_rdg>=477 && input_gain_rdg<=544)  input_gain=8;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 221
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer470
	JMP        L__Read_Potentiometer338
L__Read_Potentiometer470:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 32
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer471
	JMP        L__Read_Potentiometer337
L__Read_Potentiometer471:
L__Read_Potentiometer219:
	LDI        R27, 8
	STS        _input_gain+0, R27
L__Read_Potentiometer338:
L__Read_Potentiometer337:
;Digital_tone_Control_firmware.c,341 :: 		if(input_gain_rdg>=545 && input_gain_rdg<=612)  input_gain=9;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 33
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer472
	JMP        L__Read_Potentiometer340
L__Read_Potentiometer472:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 100
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer473
	JMP        L__Read_Potentiometer339
L__Read_Potentiometer473:
L__Read_Potentiometer218:
	LDI        R27, 9
	STS        _input_gain+0, R27
L__Read_Potentiometer340:
L__Read_Potentiometer339:
;Digital_tone_Control_firmware.c,342 :: 		if(input_gain_rdg>=613 && input_gain_rdg<=680)  input_gain=10;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 101
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer474
	JMP        L__Read_Potentiometer342
L__Read_Potentiometer474:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 168
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer475
	JMP        L__Read_Potentiometer341
L__Read_Potentiometer475:
L__Read_Potentiometer217:
	LDI        R27, 10
	STS        _input_gain+0, R27
L__Read_Potentiometer342:
L__Read_Potentiometer341:
;Digital_tone_Control_firmware.c,343 :: 		if(input_gain_rdg>=681 && input_gain_rdg<=748)  input_gain=11;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 169
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer476
	JMP        L__Read_Potentiometer344
L__Read_Potentiometer476:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 236
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer477
	JMP        L__Read_Potentiometer343
L__Read_Potentiometer477:
L__Read_Potentiometer216:
	LDI        R27, 11
	STS        _input_gain+0, R27
L__Read_Potentiometer344:
L__Read_Potentiometer343:
;Digital_tone_Control_firmware.c,344 :: 		if(input_gain_rdg>=749 && input_gain_rdg<=816)  input_gain=12;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 237
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer478
	JMP        L__Read_Potentiometer346
L__Read_Potentiometer478:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 48
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer479
	JMP        L__Read_Potentiometer345
L__Read_Potentiometer479:
L__Read_Potentiometer215:
	LDI        R27, 12
	STS        _input_gain+0, R27
L__Read_Potentiometer346:
L__Read_Potentiometer345:
;Digital_tone_Control_firmware.c,345 :: 		if(input_gain_rdg>=817 && input_gain_rdg<=884)  input_gain=13;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 49
	LDI        R17, 3
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer480
	JMP        L__Read_Potentiometer348
L__Read_Potentiometer480:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 116
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer481
	JMP        L__Read_Potentiometer347
L__Read_Potentiometer481:
L__Read_Potentiometer214:
	LDI        R27, 13
	STS        _input_gain+0, R27
L__Read_Potentiometer348:
L__Read_Potentiometer347:
;Digital_tone_Control_firmware.c,346 :: 		if(input_gain_rdg>=885 && input_gain_rdg<=952)  input_gain=14;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 117
	LDI        R17, 3
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer482
	JMP        L__Read_Potentiometer350
L__Read_Potentiometer482:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 184
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer483
	JMP        L__Read_Potentiometer349
L__Read_Potentiometer483:
L__Read_Potentiometer213:
	LDI        R27, 14
	STS        _input_gain+0, R27
L__Read_Potentiometer350:
L__Read_Potentiometer349:
;Digital_tone_Control_firmware.c,347 :: 		if(input_gain_rdg>=953 && input_gain_rdg<=1023) input_gain=15;
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 185
	LDI        R17, 3
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer484
	JMP        L__Read_Potentiometer352
L__Read_Potentiometer484:
	LDS        R18, _input_gain_rdg+0
	LDS        R19, _input_gain_rdg+1
	LDI        R16, 255
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer485
	JMP        L__Read_Potentiometer351
L__Read_Potentiometer485:
L__Read_Potentiometer212:
	LDI        R27, 15
	STS        _input_gain+0, R27
L__Read_Potentiometer352:
L__Read_Potentiometer351:
;Digital_tone_Control_firmware.c,349 :: 		channel_rdg=ADC_Get_Sample(4);   //read channel input selector
	LDI        R27, 4
	MOV        R2, R27
	CALL       _ADC_Get_Sample+0
	STS        _channel_rdg+0, R16
	STS        _channel_rdg+1, R17
;Digital_tone_Control_firmware.c,350 :: 		delay_us(1000);
	LDI        R17, 2
	LDI        R16, 75
L_Read_Potentiometer191:
	DEC        R16
	BRNE       L_Read_Potentiometer191
	DEC        R17
	BRNE       L_Read_Potentiometer191
	NOP
	NOP
;Digital_tone_Control_firmware.c,351 :: 		if(channel_rdg>=0 && channel_rdg<=256) channel_select=0;
	LDS        R18, _channel_rdg+0
	LDS        R19, _channel_rdg+1
	LDI        R16, 0
	LDI        R17, 0
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer486
	JMP        L__Read_Potentiometer354
L__Read_Potentiometer486:
	LDS        R18, _channel_rdg+0
	LDS        R19, _channel_rdg+1
	LDI        R16, 0
	LDI        R17, 1
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer487
	JMP        L__Read_Potentiometer353
L__Read_Potentiometer487:
L__Read_Potentiometer211:
	LDI        R27, 0
	STS        _channel_select+0, R27
L__Read_Potentiometer354:
L__Read_Potentiometer353:
;Digital_tone_Control_firmware.c,352 :: 		if(channel_rdg>=257 && channel_rdg<=512) channel_select=1;
	LDS        R18, _channel_rdg+0
	LDS        R19, _channel_rdg+1
	LDI        R16, 1
	LDI        R17, 1
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer488
	JMP        L__Read_Potentiometer356
L__Read_Potentiometer488:
	LDS        R18, _channel_rdg+0
	LDS        R19, _channel_rdg+1
	LDI        R16, 0
	LDI        R17, 2
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer489
	JMP        L__Read_Potentiometer355
L__Read_Potentiometer489:
L__Read_Potentiometer210:
	LDI        R27, 1
	STS        _channel_select+0, R27
L__Read_Potentiometer356:
L__Read_Potentiometer355:
;Digital_tone_Control_firmware.c,353 :: 		if(channel_rdg>=513 && channel_rdg<=768) channel_select=2;
	LDS        R18, _channel_rdg+0
	LDS        R19, _channel_rdg+1
	LDI        R16, 1
	LDI        R17, 2
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer490
	JMP        L__Read_Potentiometer358
L__Read_Potentiometer490:
	LDS        R18, _channel_rdg+0
	LDS        R19, _channel_rdg+1
	LDI        R16, 0
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer491
	JMP        L__Read_Potentiometer357
L__Read_Potentiometer491:
L__Read_Potentiometer209:
	LDI        R27, 2
	STS        _channel_select+0, R27
L__Read_Potentiometer358:
L__Read_Potentiometer357:
;Digital_tone_Control_firmware.c,354 :: 		if(channel_rdg>=769 && channel_rdg<=1023) channel_select=4;
	LDS        R18, _channel_rdg+0
	LDS        R19, _channel_rdg+1
	LDI        R16, 1
	LDI        R17, 3
	CP         R18, R16
	CPC        R19, R17
	BRGE       L__Read_Potentiometer492
	JMP        L__Read_Potentiometer360
L__Read_Potentiometer492:
	LDS        R18, _channel_rdg+0
	LDS        R19, _channel_rdg+1
	LDI        R16, 255
	LDI        R17, 3
	CP         R16, R18
	CPC        R17, R19
	BRGE       L__Read_Potentiometer493
	JMP        L__Read_Potentiometer359
L__Read_Potentiometer493:
L__Read_Potentiometer208:
	LDI        R27, 4
	STS        _channel_select+0, R27
L__Read_Potentiometer360:
L__Read_Potentiometer359:
;Digital_tone_Control_firmware.c,357 :: 		}
L_end_Read_Potentiometer:
	POP        R3
	POP        R2
	RET
; end of _Read_Potentiometer

_main:
	LDI        R27, 255
	OUT        SPL+0, R27
	LDI        R27, 0
	OUT        SPL+1, R27

;Digital_tone_Control_firmware.c,358 :: 		void main() {
;Digital_tone_Control_firmware.c,360 :: 		SPI_init();
	CALL       _SPI_init+0
;Digital_tone_Control_firmware.c,361 :: 		ADC_setup();
	CALL       _ADC_setup+0
;Digital_tone_Control_firmware.c,364 :: 		blink_Direction=1;            // set heartbeat pin as output
	IN         R27, DDD7_bit+0
	SBR        R27, BitMask(DDD7_bit+0)
	OUT        DDD7_bit+0, R27
;Digital_tone_Control_firmware.c,365 :: 		blink  = 0;                   // clear heartbeat
	IN         R27, PORTD7_bit+0
	CBR        R27, BitMask(PORTD7_bit+0)
	OUT        PORTD7_bit+0, R27
;Digital_tone_Control_firmware.c,367 :: 		SREG_I_bit = 1;               // Interrupt enable
	IN         R27, SREG_I_bit+0
	SBR        R27, BitMask(SREG_I_bit+0)
	OUT        SREG_I_bit+0, R27
;Digital_tone_Control_firmware.c,368 :: 		TOIE1_bit  = 1;               // Timer1 overflow interrupt enable
	LDS        R27, TOIE1_bit+0
	SBR        R27, BitMask(TOIE1_bit+0)
	STS        TOIE1_bit+0, R27
;Digital_tone_Control_firmware.c,369 :: 		TCCR1B = 1;                   // Start timer with prescaler
	LDI        R27, 1
	STS        TCCR1B+0, R27
;Digital_tone_Control_firmware.c,371 :: 		while (1)                     // Endless loop, port is changed inside Interrupt Service Routine (ISR)
L_main205:
;Digital_tone_Control_firmware.c,372 :: 		;
	JMP        L_main205
;Digital_tone_Control_firmware.c,373 :: 		}
L_end_main:
L__main_end_loop:
	JMP        L__main_end_loop
; end of _main
