//misc utilities

#ifndef UTIL_H
#define	UTIL_H
#include <xc.h>
#include "oled.h"
#include "io.h"

//tolerance for ADC convergence
#define R_TOLERANCE (200)
//series test resistor
#define R_TEST (10000)
//open circuit threshold, also helps us dodge /0
#define R_HIGH_ADC (1020)
//lead resistance
#define R_LEAD (63)
//nominal supply for voltage calculations, in mV, not used
//#define V_SUPPLY (5000)
//open circuit threshold, different for diodes due to leakage
#define D_HIGH_ADC (990)
//fudge factor for caps
#define C_FACTOR (2048)


long vf,vr; //forward and reverse ADC, used as globals
extern unsigned long bvolt; //battery voltage, set by main()
extern long t;              //needed for showD()

char getDigit(signed char p);  //get digit of t at pth decimal place (0 = ones)
void getV(void);                         //common ADC sample code
long getR(void);                         //get resistance, negative => invalid
long getDF(void);                        //get diode FV, result in mV
long getDR(void);                        //get diode RV, result in mV
long getC(void);                         //get cap in pF?
void getFVR(void);   //switch to FVR and read (and switch back)
void showD(void);                        //common code for DF/DR
void showC(void);
void showR(void);
char lzFix(char c); //suppress leading zero suppression for display reasons
unsigned long places(signed char n);    //this is smaller than a const array

#endif

