#include "util.h"
#include "oled.h"

unsigned long places(signed char n){
    unsigned long r=1;
    while(n--){r=r*10;}
    return r;    
}

char getDigit(signed char p){  //get digit at pth decimal place (0 = ones)
    unsigned long n=t;
    signed char res,pstart,zf;
    zf=0;
    pstart=9;
    while(pstart>=p){
        res=0;
        while(n>=places(pstart)){
            n=n-places(pstart);
            res++;
            zf=1;   //non zero digit detected
        }
        pstart=pstart-1;
    }
    if((zf==0)&&(res==0)&&(p!=0)){return F_SPACE;}  //zero blanking, ones position is never blanked
    return res;
}

void getV(void){                //common ADC sample code
    LATA5=1;
    LATA4=0;
    __delay_us(200);
    vf=getADC();
    //set reverse
    LATA5=0;
    LATA4=1;
    __delay_us(200);
    vr=getADC();
    //set normal
    LATA5=1;
    LATA4=0;    
    vr=(ADC_OS*1023)-vr;    
}

long getR(void){                         //get resistance, negative => invalid
    //getV();
    long temp;
    if(abs(vf-vr)>R_TOLERANCE){return -1;}  //check if same behaviour in reverse
    vf=vf+vr;                               //combine/average
    if(vf>(R_HIGH_ADC*ADC_OS*2)){return -1;}//if high, return error
    temp=(R_TEST*vf)/((ADC_OS*1023*2)-vf)-R_LEAD;    
    if(temp<0){return 0;}else{return temp;}    
}

long getDF(void){                         //get diode FV, result in mV, negative value for invalid
    //getV();
    if(vr>D_HIGH_ADC*ADC_OS){       //appears open circuit reversed
        if(vf<D_HIGH_ADC*ADC_OS){   //conducting in forward
            return (vf*bvolt)/(ADC_OS*1023);
        }
    }
    return -1;
}

long getDR(void){
    long temp;          //swap
    temp=vf;
    vf=vr;
    vr=temp;
    return getDF();     //use forward function
}

long getC(void){
    int j,k;
    k=1023;
    unsigned char n=255;
    LATA5=0;
    LATA4=0;
    ADCON0bits.ADGO=1;          //start
    while(ADCON0bits.ADGO){}    //wait till done
    j=ADRES;
    while((k&512)&&n){
        n--;
        ADCON0bits.ADGO=1;          //start
        while(ADCON0bits.ADGO){}    //wait till done
        k=ADRES;
    }
    LATA5=1;
    LATA4=0;
    //if j<512, probably invalid (too fast discharge)
    //if j==k, very large value
    if(j<512){return -1;}   //first reading not valid, low value
    if(j<=k){return -2;}    //no difference, high value, avoid div/0
    return ((long)j*(255-n)*C_FACTOR)/(j-k);
}

void getFVR(void){
    unsigned char chs;
    int res;
    FVRCON=0x81;            //FVR on with ADFVR=1.024V
    chs=ADCON0;             //save
    ADCON0bits.CHS=0x1F;    //FVR
    while(!FVRCONbits.FVRRDY){}        //wait till ready    
    res=getADC();
    FVRCON=0;               //shut down FVR
    ADCON0=chs;             //restore
    if(res<2800){
        bvolt=6000;         //6V=> limit of PIC    
    }else{
        bvolt=(1L<<24)/res;     //16384*1024mV
    }
}

void showD(void){
    OLEDcharb(F_SPACE);
    OLEDcharb(lzFix(getDigit(3)));
    OLEDcharb(F_POINT);                                
    OLEDcharb(lzFix(getDigit(2)));
    OLEDcharb(F_VOLT);                
}

void showC(void){
    //returned in pF, but ~1n is smallest, read down to 0.1 nF
    if(t<100000L){
        OLEDcharb(getDigit(4));
        OLEDcharb(lzFix(getDigit(3)));
        OLEDcharb(F_POINT);                                    
        OLEDcharb(lzFix(getDigit(2)));
        OLEDcharb(F_NANO);                                            
        OLEDcharb(F_FARAD);    
    }else if(t<1000000L){
        OLEDcharb(F_SPACE);
        OLEDcharb(getDigit(5));
        OLEDcharb(getDigit(4));
        OLEDcharb(lzFix(getDigit(3)));
        OLEDcharb(F_NANO);                                            
        OLEDcharb(F_FARAD);    
    }else if(t<100000000L){
        OLEDcharb(getDigit(7));
        OLEDcharb(lzFix(getDigit(6)));
        OLEDcharb(F_POINT);                                    
        OLEDcharb(lzFix(getDigit(5)));
        OLEDcharb(F_MICRO);                                            
        OLEDcharb(F_FARAD);    
    }else{
        OLEDcharb(F_SPACE);
        OLEDcharb(getDigit(8));
        OLEDcharb(getDigit(7));
        OLEDcharb(lzFix(getDigit(6)));
        OLEDcharb(F_MICRO);                                            
        OLEDcharb(F_FARAD);            
    }
}

void showR(void){
    if(t<1000L){
        OLEDcharb(F_SPACE);
        OLEDcharb(F_SPACE);
        OLEDcharb(getDigit(2));
        OLEDcharb(getDigit(1));
        OLEDcharb(getDigit(0));
        OLEDcharb(F_OHM);                
    }else if(t<10000L){
        OLEDcharb(getDigit(3));
        OLEDcharb(F_POINT);                                
        OLEDcharb(getDigit(2));
        OLEDcharb(getDigit(1));
        OLEDcharb(F_KILO);                
        OLEDcharb(F_OHM);                                
    }else if(t<100000L){
        OLEDcharb(getDigit(4));
        OLEDcharb(getDigit(3));
        OLEDcharb(F_POINT);                                
        OLEDcharb(getDigit(2));
        OLEDcharb(F_KILO);                
        OLEDcharb(F_OHM);                                
    }else if(t<1000000L){
        OLEDcharb(F_SPACE);
        OLEDcharb(getDigit(5));
        OLEDcharb(getDigit(4));
        OLEDcharb(getDigit(3));
        OLEDcharb(F_KILO);                
        OLEDcharb(F_OHM);                                
    }else{
        OLEDcharb(getDigit(6));
        OLEDcharb(F_POINT);                                
        OLEDcharb(getDigit(5));
        OLEDcharb(getDigit(4));
        OLEDcharb(F_MEGA);                
        OLEDcharb(F_OHM);                                                
    }    
}

char lzFix(char c){ //suppress leading zero suppression for display reasons
    if(c==F_SPACE){return 0;}
    return c;
}