//SSD1306/SH1106 OLED implementation for 16F1455

#include "oled.h"
#include "softi2c.h"

void OLEDsendCommand(unsigned char c){
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x80); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDsendData(unsigned char c){     //not used only does a single byte
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x40); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDinit(void){
    __delay_ms(200);        //startup delay for display
    OLEDsendCommand(0x20);  //set addressing mode
    OLEDsendCommand(0x02);  //set page addressing mode (SH1106 only supports page mode)
    OLEDsendCommand(0x8D);  //Charge pump setting
    OLEDsendCommand(0x14);  //Enable Charge pump
    OLEDsendCommand(0xA1);  //column reverse
    //OLEDsendCommand(0xA0);  //column normal
    OLEDsendCommand(0xC8);  //row reverse
    //OLEDsendCommand(0xC0);  //row normal
    OLEDsendCommand(0xAF);  //display on
    OLEDsendCommand(0x81);  //set contrast
    OLEDsendCommand(0xFF);  //to max
    OLEDclear();
}

void OLEDclear(void){
    unsigned char i,j;
    for(i=0;i<8;i++){
        OLEDsetpage(i);
        OLEDsendCommand(0xB0+i); //cycle through pages
        //OLEDsendCommand(0x00);   //column=0 (lower nybble)     
        OLEDsendCommand(0x10);   //column=0 (upper nybble)
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x40); //write data
        for(j=0;j<128;j++){
            I2Cbyte(0x00);
        }
        I2Cstop();
    }
}

void OLEDsetpage(unsigned char p){
    //p=7-p;      //flipped
    OLEDsendCommand(0xB0 + (p&7));      //set page address    
}

void OLEDsetcolumn(unsigned char c){
    //c=127-c;     //flipped
    c=c+OLED_X_OFFSET;
    OLEDsendCommand(0x00 + (c & 0x0F));  //set column lower address
    OLEDsendCommand(0x10 + ((c>>4)&0x0F));   //set column higher address    
}

//8 bit version, skips every second column
void OLEDchar(char c){
    unsigned char i,j;
    if(c>21){return;}
    i=c*8;
    I2Cstart();
    I2Cbyte(OLED_ADDRESS);  //write
    I2Cbyte(0x40);          //write data
    for(j=i;j<i+8;j=j+2){     //font columns
        I2Cbyte(font8[j]);
    }
    I2Cbyte(0);
    I2Cstop();
}

void OLEDcharb(char c){
    unsigned char i,j,k;
    char t;
    if(c>21){return;}
    i=c*8;
    for(k=0;k<4;k++){
        OLEDsetcolumn(col);
        OLEDsetpage(4+k);
        I2Cstart();
        I2Cbyte(OLED_ADDRESS);  //write
        I2Cbyte(0x40);          //write data
        for(j=0;j<8;j++){       //8 font columns
            t=getbits(j+i,k);
            I2Cbyte(t);
        }
        I2Cbyte(0);
        I2Cbyte(0);
        I2Cbyte(0);
        I2Cstop();
    }    
    col=col+11;
}
/*
char getbits(unsigned char j,char y){   // j is as above x,y <=> (0,3)
    unsigned char t;
    t=font8[j];
    switch(y&3){
        case 3: t=t>>2;
        case 2: t=t>>2;
        case 1: t=t>>2;
        default:
            break;
    }
    return bitb[t&3];
}
*/
char getbits(unsigned char j,char y){
    unsigned char t;
    t=font8[j];
    y=y&3;
    while(y--){
        t=t>>2;
    }
    return bitb[t&3];
}