#include "config.h"
#include <xc.h>
#include "io.h"
#include "softi2c.h"
#include "oled.h"
#include "font.h"
#include "util.h"

char i,j;
long t;
unsigned long bvolt;
char col; //column variable

void main(void) {
    OSCCONbits.IRCF=0b1101; //4MHz => 1MHz clock
    ioinit();
    I2Cstop();          //this sets up I2C to idle state
    OLEDinit();         //does clear too
    j=20;
    while(1){
        getFVR();         //this is battery voltage and ADC reference, put in bvolt
        col=0;        
        t=getC();        
        if(t>0){
            showC();
            j=20;
        }else{        
            getV();
            t=getR();
            if(t>=0){
                j=20;
                showR();
            }else{
                t=getDF();
                if(t>=0){
                    j=20;
                    showD();
                    OLEDcharb(F_DF);                                                
                }else{
                    t=getDR();
                    if(t>=0){
                        j=20;
                        showD();
                        OLEDcharb(F_DR);                                                
                    }else{      //if not valid show battery
                        t=bvolt;
                        OLEDcharb(F_BAT);
                        OLEDcharb(getDigit(3));
                        OLEDcharb(F_POINT);                                
                        OLEDcharb(getDigit(2));
                        OLEDcharb(getDigit(1));
                        OLEDcharb(F_VOLT);                
                    }
                }      
            }
        }
        __delay_us(200000L);
        if(j){
            j--;
        }else{
            //go to sleep until triggered
            j=20;                       //reset counter
            OLEDsendCommand(0xAE);      //display off
            ADCON0bits.ADON=0;          //turn off
            VREGCONbits.VREGPM=1;       //this should help, but doesn't seem to
            ANSELA=0;                   //digital for INT
            OPTION_REGbits.INTEDG=0;    //falling edge
            INTCONbits.INTF=0;          //clear
            INTCONbits.INTE=1;          //enable
            SLEEP();                    //sleep
            NOP();                      //ensure next instruction is executed
            INTCONbits.INTE=0;          //disable
            ANSELA=1<<2;                //AN2 on RA2 only            
            ADCON0bits.ADON=1;          //turn on
            OLEDsendCommand(0xAF);      //display on
        }
    }
    return;
}
