#include "softi2c.h"

//write only:

void I2Cbit(unsigned char n){      //send one bit, return bit
    if(n){
        SDAHI
    }else{
        SDALO
    }
    SCLHI
    SCLLO
}

void I2Cbyte(unsigned char n){     //send byte,return read byte + ACK
    I2Cbit(n&128);
    I2Cbit(n& 64);
    I2Cbit(n& 32);
    I2Cbit(n& 16);
    I2Cbit(n&  8);
    I2Cbit(n&  4);
    I2Cbit(n&  2);
    I2Cbit(n&  1);
    I2Cbit(1);  //ack bit
}

void I2Cstart(void){                 //send start condition
    //SDAHI                            //allow repeated start
    SDALO
    SCLLO
}

void I2Cstop(void){                  //send stop condition
    SDALO
    SCLHI
    SDAHI
}
