void getAnalogs()  // uses the analog voltages both sides of each Resistor.  Gives Battery Voltages, Calculates Battery Current and highest Voltage and Current
{

  highestVolts = 0;
  highestAmps = 0;

  for (int i = 1; i < 5; i++) // 1 to 4
  {
    if (bIn[i])  //battery inserted in bay
    {
      if (vc[i] < v[i])
      {
        vc[i] = v[i]; // if charge V is less than Battery V
      }
      //Calculate Currents
      if (vc[i] - v [i] >= 10) //10mV == 10 mA minimum reading
      {
        a[i] = (vc[i] - v[i] ) * 10 / 10;// calculate currents using 1 ohm sensing resistor
      }
      else
      {
        a[i] = 0;
      }
      // Calculate Highest Voltage
      if (v[i] > highestVolts)
      {
        highestVolts = v[i];
      }

      // Calculate Highest Current
      if (a[i] > highestAmps)
      {
        highestAmps = a[i];
      }
      if (highestAmps > 600)//High amps safety cut Off
      {
        highCurrentCounter ++;
        Serial.println ("High Amps:" + String (highestAmps));
        if (highCurrentCounter > 5)
        {
          Serial.println ("High Amps Counter:" + String (highCurrentCounter));
          goStop("Stopped due to excessive Current.");
          highCurrentCounter = 0;
        }
      }
      else
      {
        highCurrentCounter = 0;
      }
    }
    else // Zero voltage and current in this bay if no battery inserted
    {
      v[i] = 0;
      a[i] = 0;
    }
  }


  currentError = (a[0] - highestAmps);
  currentError = abs(currentError);  //Note Note Note abs() will not work if other functions are used in brackets

  //Serial.println ("*********a0:" + String (a[0]));
  //Serial.println ("*********HA:" + String (highestAmps));
  //Serial.println ("*********CE:" + String (currentError));
  //Serial.println ("*********HV:" + String (highestVolts));
  //Serial.println ("VoltsC:" + String (vc[1]) + ":" + String (vc[2]) + ":" + String (vc[3]) + ":" + String (vc[4]));
  //Serial.println ("VoltsB:" + String (v[1]) + ":" + String (v[2]) + ":" + String (v[3]) + ":" + String (v[4]));
  //Serial.println ("Amps  :" + String (a[1]) + ":" + String (a[2]) + ":" + String (a[3]) + ":" + String (a[4]));
  //Serial.println("PWM:" + String (outPwm) +  " E:" + String (highestAmps - a[0]) + " HA:" + String (highestAmps));
}
