void handle_Commands()
{
  String request = processReq(server.uri());
  Serial.println (request);
  if (heartBeat == "*")
  {
    heartBeat = "";
  }
  else
  {
    heartBeat = "*";
  }
  if (request == "/favicon")
  {

  }
  else if (request == "/stop")
  {
    if (controlMode == "On")
    {
      goStop("Stop button pressed.");
      //Serial.println("Stop");
    }

  }
  else if (request == "/start")
  {
    if (controlMode == "Off")
    {

      goStart("Start button pressed.");
      // Serial.println("Start");
    }
  }
  else if (request == "/version")
  {
    message = versionNum ;
  }
  else if (request =="/clearMessage")
  {
    message="";
    message1 = " ";
  }
  else if (request == "/stopAdjust")
  {
    adjust = false;
    //Serial.println("Adjust Stop");
    message = " ";
    
  }
  else if (request == "/startAdjust" and controlMode =="Off")
  {
    adjust = true;
    //Serial.println("Adjust Start");
    message = "";
  }
  //***Preset Currents ***
  else if (request.substring (0, 8) == "/presetm")
  {
    a[0] = request.substring(8).toInt();
    if (a[0] <= 20 )
    {
      a[0] = 20;
    }
    if (a[0] > 500)
    {
      a[0] = 500;
    }
    //Serial.println (String (a[0]) + "mA set.");
    message = String (a[0]) + "mA set.";
  }
  //***Preset Voltages***
  else if (request.substring (0, 8) == "/presetV")
  {
    v[0] = request.substring(8).toInt();
    if (v[0] <= 1000 )
    {
      v[0] = 1000;
    }
    if (v[0] > 4200)
    {
      v[0] = 4200;
    }
    //Serial.println (String (convert3Dp(v[0])) + "V set.");
    message = String (convert3Dp(v[0])) + "V set.";
  }
  //***Decrease***
  else if (request.substring (0, 9) == "/decrease")
  {
    if (request.substring (9) == "V")
    {
      v[0] = v[0] - incrementV;
      if (v[0] < 1000)
      {
        v[0] = 1000;
      }
    }
    else if (request.substring (9) == "A")
    {
      a[0] = a[0] - incrementA;
      if (a[0] < 20)
      {
        a[0] = 20;
      }
    }
    else if (request.substring (9) == "T")
    {
      t[0] = t[0] - incrementT;
      if (t[0] < 100)
      {
        t[0] = 100;
      }
    }
    else if (request.substring (9) == "M")
    {
      setMinutes = setMinutes - incrementM;
      if (setMinutes < 15)
      {
        setMinutes =15;
      }
      if (controlMode == "On" and timerMinutes > 30)
      {
        timerMinutes = timerMinutes - incrementM ;
      }
      if (setMinutes < 0)
      {
        setMinutes = 0;
      }
    }
  }
  //***Increase***
  else if (request.substring (0, 9) == "/increase")
  {
    if (request.substring (9) == "V")
    {
      v[0] = v[0] + incrementV;
      if (v[0] > 4200)
      {
        v[0] = 4200;
      }
    }
    else if (request.substring (9) == "A")
    {
      a[0] = a[0] + incrementA;
      if (a[0] > 500)
      {
        a[0] = 500;
      }
    }
    else if (request.substring (9) == "T")
    {
      t[0] = t[0] + incrementT;
      if (t[0] > 1000)
      {
        t[0] = 1000;
      }
    }
    else if (request.substring (9) == "M")
    {
      setMinutes = setMinutes + incrementM;
      if (controlMode == "On" and setMinutes < 930)
      {
        timerMinutes = timerMinutes + incrementM;
      }
      if (setMinutes > 960)
      {
        setMinutes = 960;
      }
    }
  }
  else if (request.substring(0, 5) == "/incV")
  {
    incrementV = request.substring(5).toInt();
    message = "Voltage Increment Value is: " + String (incrementV) + " mV.";
  }
  else if (request.substring(0, 5) == "/incA")
  {
    incrementA = request.substring(5).toInt();
    message = "Current Increment Value is: " + String (incrementA) + " mA.";
  }
  else if (request.substring(0, 5) == "/incT")
  {
    incrementT = request.substring(5).toInt();
    message = "Temp Increment Value is: " + String (int (incrementV) / 100) + " C.";
  }
  else if (request.substring(0, 5) == "/incM")
  {
    incrementM = request.substring(5).toInt();
    message = "Time Increment Value is: " + String (incrementM) + " mins.";
  }
  else if ( request == "/saveSettings")
  {
    saveData("Settings");
  }
  else if ( request == "/saveDefaults")
  {
    saveData("Defaults");
  }
  else if ( request == "/viewDefaults")
  {
    message = "View Defaults:<p>";
    message += String (convert3Dp(defaultV)) + " V.<p>";
    message += String (defaultA) + " mA.<p>";
    message += String (int(defaultT / 100)) + " C.<p>";
    message += String (defaultM) + " mins.";
  }
  else if ( request == "/viewSettings")
  {
    message = "Settings:<p>";
    message += "Page refresh rate: " + String (htmlRefresh) + " secs<p>";
    message += "Voltage increment: " + convert3Dp(incrementV) + " V <p>";
    message += "Current increment: " + String (incrementA) + " mA<p>";
    message += "Temperature increment: " + String (String(int(incrementT / 100))) + " C<p>  ";
    message += "Time increment: " + String (incrementM) + " mins<p>";
  }
  else if ( request == "/mainView")
  {
    htmlMode = "Main View";
  }
  else if ( request == "/batteryView")
  {
    htmlMode = "Battery View";
  }
  else if ( request == "/settingsView")
  {
    htmlMode = "Settings View";
  }
  //***Preset Currents ***
  else if (request.substring (0, 4) == "/ref")
  {
    htmlRefresh = request.substring(4).toInt();
    if (htmlRefresh < 5 )
    {
      htmlRefresh = 5;
    }
    if (htmlRefresh > 60)
    {
      htmlRefresh  = 60;
    }
    message = "Page refresh rate is: " + String (htmlRefresh) + " secs.";
  }
  else if (request == "/viewNetwork" and controlMode == "Off")
  {
    message = "View Network Settings.<p>";
    message += ("SSID: " + String(ssid)+ "<p>");
    message += ("Password: " + String ( password)+ "<p>");
    message += ("IP: " + ipAddress2String (ipAdd)+ "<p>");
    message += ("IP GW: " + ipAddress2String (ipGw)+ "<p>");
    message += ("IP DNS: " + ipAddress2String(ipDns)+ "<p>");
    message += ("IP SNM: " + ipAddress2String(ipSnm)+ "<p>");
    message += ("Server Port: " + String (serverPort));
  }
  commandSuccess = true;// sets the Address bar to IP/done
  server.send(200, "text/html", SendHTML());
}
