void controlLoop()
{
  if (tempReading)//analog readings are erroneous after Temperature reading
  {
    tempReading = false ;
  }
  else
  {
    getADS1115();  //get the analog values
  }
  getAnalogs();  //process analogs

  if (controlMode == "On")
  {
    for (int i = 1; i < 5; i++)//Check each battery for end of Charge
    {
      //Voltage Limit and Current fall STOP
      //Check if Voltage end point reached when current falls to <50% 
      //Serial.println("Current ratio:" + String (a[0]/highestAmps));
      if (a[i] > 0) //to avoid zero division and ESP crash
      {
        if (v[0] - v[i] <= 10 or v[i] >= v[0])
        {
          if ((a[0] / a[i]) >= 2) //at voltage limit (10 mV and 50% current // watch zero division
          {
            Serial.println ("Voltage Limit and 50% current");
            goStopBattery(i, "Voltage Limit & 50% Current.");
          }
        }
      }
      //Temperature STOP
      if ( t[i] - t[5] > t[0] ) //t[5] is ambient, t[0] is delta T limit if highest - ambient > delta
      {
        goStopBattery (i, "Temperature limit. " + String (convert2Dp(t[i])) + "C");
      }
    }
    // Calculate Errors and apply gain factors
    //Voltage Error
    int kP = 50; //
    int vError = int(kP * (v[0] - highestVolts - 10) / 100); // 10 mv dead band to stop hunting
    //Serial.println("******PWM  ERROR  :" + String (vError) + "PWM Volts");

    // Current Error
    kP = 20; //Higher number higher gain faster response but less stable and theoretically lower dead band.
    //Lower the number lower gain more stability but slower response and wider dead band
    int aError = int (kP * (a[0] - highestAmps) / 100);
    //Serial.println("******PWM  ERROR  :" + String (aError) + "PWM Amps");

    //Temperature Error - Not used
    //kP = 1;
    //int tError = int (kP * (t[5] - highestTemp + t[0]) / 10); // t[0] Delta T, t[5] Ambient
    //Serial.println("******PWM  ERROR  :" + String (tError) + "PWM Deg C");

    // CONTROL LOOP
    // Remember PWM is inverted
    if (vError < 0 ) //Voltage High then decrease
    {
      outPwm = outPwm + vError; // vError is negative - decrease based on voltage
      messageControl = "V-";
      //Serial.println("<V");
    }
    else if (aError < 0) //Current High then decrease
    {
      outPwm = outPwm + aError; // aError is negative - decrease based on current

      messageControl = "A-";
      //Serial.println("<A");
    }
    else if (aError > 0 and vError > 0)
    {
      if (aError < vError) // choose smallest Error
      {
        outPwm = outPwm + aError; // aError is positive - increase based on current
        messageControl = "A+";
        //Serial.println(">A");
      }
      else
      {
        outPwm = outPwm + vError; // vError is positive -increase based on voltage
        messageControl = "V+";
        //Serial.println(">V");
      }
    }
    else
    {
      // Close to Set Point - do nothing
      messageControl = "=";
    }
  }
  else
  {
    if (!adjust) //not adjusting
    {
      outPwm = 0; //Off
    }
  }// end If Control Mode == "On"

  if (outPwm >= 1024 ) // If 1024 then current output is zero
  {
    outPwm = 1024;
  }
  if (outPwm < 0 )
  {
    outPwm = 0;
  }
  if (adjust)
  {
    if (adjustCtr <= 0)
    {
      adjustCtr = 50;
      if (outPwm < 512)
      {
        outPwm = 1023;
        message = "Output is High.  <p>";
        message += "Adjust LM2956 module pot.  <p>";
        message += "Set Output to no more than 5.5V";

      }
      else
      {
        outPwm = 0;

        message = "Output is Low. <p> ";
        message += "Adjust ADC pot slowly.  <p> ";
        message += "Set Output to 1.35V  <p>";
        message += "Stop Adjust after a few Iterations.";
      }
    }
    adjustCtr--;
  }
  analogWrite(D8, 1024 - outPwm); // invert pulse
  delay (200); //settling
  //***************************************************

  //Serial.println( controlMode + "-" + String (v[0]) + ":" + String (vc[1]) + "/" + String (v[1]) + ":" + String (vc[2]) + "/" + String (v[2]) + ":" + String (vc[3]) + "/" + String (v[3]) + ":" + String (vc[4]) + "/" +  String (v[4]) + " HA:" + String (highestAmps) + " MAError:" + String (highestAmps - a[0]) + " MVError:" + String (highestVolts - v[0]) + " PWM:" + String (outPwm));
  if (controlMode == "On")
  {
    message1 =  String (a[0] - highestAmps) + " mA Error.   " +  String (v[0] - highestVolts) +  " mV Error.   " + String (outPwm) + " PWM." ;
  }
  //Serial.println( "v0=" + String (v[0]));
  //Serial.println( "v1=" + String (v[1]));
  //Serial.println( "v2=" + String (v[2]));
  //Serial.println( "v3=" + String (v[3]));
  //Serial.println( "v4=" + String (v[4]));
  //Serial.println ("a0=" + String (a[0]));
  //Serial.println ("a1=" + String (a[1]));
  //Serial.println ("a2=" + String (a[2]));
  //Serial.println ("a3=" + String (a[3]));
  //Serial.println ("a4=" + String (a[4]));
  //Serial.println ("highestAmps:" + String (highestAmps));
  //Serial.println ("current Error:" + String (highestAmps -a[0]));
  //Serial.println ("highestVolts:" + String (highestVolts));

}
