/*
   Battery Charger
   Wemos D1 Mini with web Server and Browser Control Panel
   P Webb Hope Valley South Australia
   May 2020
*/


#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <DallasTemperature.h>
#include <EEPROM.h>
#include <Wire.h>

#define ONE_WIRE_BUS D3 // pin D3 for OWB
OneWire ds(ONE_WIRE_BUS);
DallasTemperature sensors(&ds);

String versionNum = "Copyright PW Ver 1.0 7/5/2020";
//********************************************************************
//IMPORTANT
//Replace items below with your network credentials CHANGE ALL: ssid, password, ipAdd, doneString ipAddress, ipGW, ipDns, ipSnm
//IT WILL NOT WORK UNLESS YOU GET ALL THESE TO MATCH YOUR WiFi ROUTER DETAILS
//LOG INTO YOUR ROUTER TO GET THE NETWORK DETAILS or
//ON Apple devices go to Settings - WiFi and tap on the (i)Information Icon alongside the connected WiFI name to see the Network Details.  Make ipAdd unique eg if your apple Device is 192.168.1.5 then make the BC ipAdd 192.168.1.120
//ON Android devices do a web search for instructions.  Good luck, you will need it.  No two Android systems are the same.
//ON Windows 7, Click Network Icon in System tray or Search Network Connections, Open Network and Sharing Centre, select Local Area Connection, Select Details. 
//ON Windows >7, Search "View Network Connections", Click "View Network Connections Control panel", Right Mouse on the Active Network Icon, Select Details. 

//The next 7 lines must be modified to suit you network connection
const char* ssid = "ssid";        // REPLACE_WITH_YOUR_WIFI_SSID
const char* password = "password";  //REPLACE_WITH_YOUR_WIFI_PASSWORD
IPAddress ipAdd(10, 0, 0, 20);      //REPLACE with The fixed IP Address you want for your ESP8266 **** IMPORTANT **** put this IP Address in the next line also! doneString with dots as separators
String doneString = "window.location.assign('http://10.0.0.20/done')\n"; //**** MANDATORY ****  put the IPAddress here also but with dots eg 10.0.0.1
IPAddress ipGw(10, 0, 0, 138);     //The GateWay Address. The IP Address of your Router     eg "192,168,1,150";
IPAddress ipDns(10, 0, 0, 138);    //The DNS Address.     The IP Address of your Router     eg "192,168,1,150";
IPAddress ipSnm(255, 255, 255, 0); //SubNet Mask - Usually 255,255,255,0

const unsigned int serverPort = 80;
ESP8266WebServer server(serverPort);// Web server port. could be a port number such as 2500.  Use it to Call up the web page using http://IPaddress:PortNumber eg http://10.0.0.20:80
//************************************************************************

int lastMinute;   // For decrementing the minuteTimer
int timerMinutes; // Time Countdown
int setMinutes = 960;   // Setting Time Limit Minutes

bool adjust = false; // used to adjust the pots to achieve optimum voltage out range
int adjustCtr = 0; // used to swap from full PWN to Zero PWM when in adjust mode
int outPwm = 0;

bool bIn[5] = {false}; // true if a battery is inserted prior to Start

int defaultV = 2000; //default  values 2.0V
int defaultA = 100;// 100 mA
int defaultT = 300;//3 degrees
int defaultM = 960;//Minutes


//Voltages
int v[5] = {0} ;      // 0 = Voltage limit, 1,2,3,4 battery mV
int vc[5] = {0} ;     // Charge Voltage mV
int highestVolts = 0; // Highest Battery Voltage mV
int vCalFactor[5] = {1000}; // Voltage calibration factor for analogs 1000 = 1.0
unsigned int incrementV = 10;

//Currents
int a[6] = {0}; // 0 == current limit mA, 1,2,3,4 battery mA, 5 = current error mA
int highestAmps = 0; // mA
int currentError = 0; // mA
int highCurrentCounter = 0; //if successive excessive currents then Stop
unsigned int incrementA = 10;

//Temperatures
int t[6] = {0}; // 0 = Cut off Delta Temp:(limit degC *100), 1,2,3,4 Battery Temp:(Temp. *100), 5 = Ambient Temp: (Temp.*100// 23.45C = 2345.
int highestTemp = 0;
bool tempReading = false;
unsigned int incrementT = 100; //100 == 1 degree

//Capacity c has to be long as is thousands of mAHr
unsigned long c[5] = {0}; // 1000 * actual mAHr



//Timers
unsigned long timerStart = 0;
unsigned const long timerTick = 14400;// milliseconds calc mAHrs  around 4/1000 of an hour
unsigned int secNum = 0;
unsigned int minNum = 0;
unsigned int hrNum = 0;
unsigned long timeStart = 0;
unsigned int htmlRefresh = 10; //The HTML page automatic refresh rate
unsigned int incrementM = 30;
//Relays
const unsigned int relay1 = 16; // D0
const unsigned int relay2 = 14; // D5
const unsigned int relay3 = 12; // D6
const unsigned int relay4 = 2;  // D4

//Control
String controlMode = "Off";  // "On", "Off"
unsigned int pwmInitial = 100; // initial PWM - To decide the value, Insert 1.2V battery, set minimum current and observe PWM in messages.

bool commandSuccess = false; //Send a /Done to prevent web page re-fresh and stop commands repeating
String message = "Battery Charger is on line."; // General operation messages
String message1 =" "; //  Error and PWM message
String messageControl = "";
String htmlMode = "Main View"; // "Battery View", "Settings View"
String heartBeat = "*";

//*************************
void setup()
{
  Serial.begin(9600);
  Serial.println (" ");
  Serial.println ("**********Booting Battery Charger*********** ");

  Wire.begin();
  I2CAddressScanner();        //D1 is SCL, D2 is SDA
  pinMode(D8, OUTPUT);        //PWM output
  digitalWrite(D8, HIGH);     //turn off PWM
  pinMode(D7, OUTPUT);        //Charging on/off
  digitalWrite(D7, HIGH);     // turn off
  pinMode(relay1, OUTPUT);    //R1
  digitalWrite(relay1, HIGH); // turn off
  pinMode(relay2, OUTPUT);    //R2
  digitalWrite(relay2, HIGH); // turn off
  pinMode(relay3, OUTPUT);    //R3
  digitalWrite(relay3, HIGH); // turn off
  pinMode(relay4, OUTPUT);    //R4
  digitalWrite(relay4, HIGH); // turn off
  EEPROM.begin(50);
  readData();                 // read the Defaults and other Settings
  analogWriteFreq(10000);     // set the PWM frequency to 10kHz
  sensors.begin();
  sensors.setResolution(10);  // can be 9 to 12 bits.  Higher res takes longer
  getTemperatures();
  WiFi.config(ipAdd, ipGw, ipSnm, ipDns);
  WiFi.begin(ssid, password);
  Serial.println (ssid);
  Serial.println (password);
  Serial.println (ipAdd );
  Serial.println (ipGw);
  Serial.println (ipSnm);
  Serial.println (ipDns);
  //check wi-fi is connected to wi-fi network
  while (WiFi.status() != WL_CONNECTED)
  {
    delay(1000);
    Serial.print(".");
  }
  for (int i = 0; i < 4; i++)//flash LED when connected to WiFi.
  {
    digitalWrite(D8, LOW);     // turn on PWM LED
    delay(250);
    digitalWrite(D8, HIGH);     // turn off PWM LED
    delay(250);
  }
  Serial.println("");
  Serial.println("WiFi connected..!");
  Serial.print("Got IP: ");  Serial.println(WiFi.localIP());

  //Server Handlers. handle_Commands is the main Command Processor
  server.on("/", handle_OnConnect);
  server.on("/done", handle_done);
  server.onNotFound(handle_Commands); //Handle all the other commands
  server.begin();
  Serial.println("HTTP server started");
  timeStart = millis();
}

//*************************
void loop()
{
  server.handleClient();
  controlLoop();  // must be here to ensure PWM is set to zero when "Off"
  checkMinutes(); //For Time Control

  if (millis() - timerStart > timerTick)  // Calculate Capacity and Temperatures and check minutes
  {
    unsigned int period = millis() - timerStart;
    timerStart = millis();
    if (heartBeat == "*")
    {
      heartBeat = "";
    }
    else
    {
      heartBeat = "*";
    }

    if (controlMode == "On");
    {
      calcMAHrs( period); // use the actual elapsed time rather than tick time
      getTemperatures();  //
      tempReading = true;
    }
  }
}
//*************************
void handle_OnConnect()
{
  Serial.println("handle_OnConnect");
  commandSuccess = true;
  server.send(200, "text/html", SendHTML());
}
//*************************
void handle_done()
{
  commandSuccess = false; // don't reset the Command Line
  server.send(200, "text/html", SendHTML());
}




