void getADS1115()
//ADS1115 is a tricky beast. Need a conversion delay for MUX to suit SPS for corrrect operation.
//Tried many libraries with varying success.  Decided to just write the necessary I2C commands
//Also found resetting the ADS1115 before readings improved reliability of readings.
{
  unsigned long val = 0;
  byte writeBuf[6];
  byte msb;
  byte lsb;
  writeBuf[1] = 0b01000000; // MSB 15-8 single shot off <== NEW - single ended conversion/ AIN0 & GND 100/ 6.144V/ Continuous (0)
  writeBuf[2] = 0b01010000; // MSB 15-8 single shot off <== NEW - single ended conversion/ AIN1 & GND 101/ 6.144V/ Continuous (0)
  writeBuf[3] = 0b01100000; // MSB 15-8 single shot off <== NEW - single ended conversion/ AIN2 & GND 110/ 6.144V/ Continuous (0)
  writeBuf[4] = 0b01110000; // MSB 15-8 single shot off <== NEW - single ended conversion/ AIN3 & GND 111 / 6.144V/ Continuous (0)
  writeBuf[5] = 0b10000000; // LSB 7-0,  128SPS, assert after 1

  for (int i = 0; i <= 3; i++)
  {
    // Reset first ADS1115
    Wire.beginTransmission(0x0);
    Wire.write(0x06); //Reset
    Wire.endTransmission();
    delay (2);
    
    // Configure first ADS1115
    Wire.beginTransmission(0x48);  // ADC
    Wire.write(1); //Select Config reg
    Wire.write(writeBuf[i + 1]); //MSB config Reg - Selects Input
    Wire.write(writeBuf[5]);  //LSB Config Reg
    Wire.endTransmission();

    //Read Register
    /*
      //Wire.beginTransmission(0x48);  // ADC
      Wire.beginTransmission(0b10010001);  // 0X49 plus + High R/NotW bit
      Wire.write(1); //Select Config reg
      Wire.requestFrom(0x48, 2);//get 2 bytes
      while (Wire.available())
      {
        msb = Wire.read();
        lsb = Wire.read();
      }
      Wire.endTransmission();
      Serial.print("0x48" );
      Serial.print("-");
      Serial.println(String (i));
      Serial.println(msb, BIN);
      Serial.println(lsb, BIN);
    */
    // Conversion
    Wire.beginTransmission(0x48);  // DAC
    Wire.write(0);  // Select pointer to conversion register
    Wire.endTransmission();
    delay (10);  // 1/128 == 7.8mS.
    Wire.requestFrom(0x48, 2);//get 2 bytes
    msb = Wire.read();
    lsb = Wire.read();
    Wire.endTransmission();
    val = ((msb << 8) | lsb ) * 1875 / 10000; // shift MSB left 8 bits then append //32768/6.144 = 1875mV per count
      if (i == 0)
    {
      vc[1] = val;
    }
    if (i == 1)
    {
      v[1] = val;
    }
    if (i == 2)
    {
      vc[2] = val;
    }
    if (i == 3)
    {
      v[2] = val;
    }
    // Reset second ADS1115
    Wire.beginTransmission(0x0);
    Wire.write(0x06); //Reset
    Wire.endTransmission();
    delay (2);
    
    // Configure second ADS1115
    Wire.beginTransmission(0x49);  // ADC
    Wire.write(1); //Select Config reg
    Wire.write(writeBuf[i + 1]); //MSB config Reg - Selects Input
    Wire.write(writeBuf[5]);  //LSB Config Reg
    Wire.endTransmission();
    
    // Conversion
    Wire.beginTransmission(0x49);  //
    //Wire.beginTransmission(0b10010010);  // ADC
    Wire.write(0);  // Select pointer to conversion register
    Wire.endTransmission();
    delay (10);// must have this to settle MUX and conversion otherwise output of a0 to a3 gets crossed
    //Get conversion
    Wire.requestFrom(0x49, 2);//get 2 bytes
      msb = Wire.read();
      lsb = Wire.read();
    Wire.endTransmission();
    val = ((msb << 8 ) | lsb ) * 1875 / 10000; // shift MSB left 8 bits then append //32768/6.144 = 1875mV per count

    if (i == 0)
    {
      vc[3] = val;
    }
    if (i == 1)
    {
      v[3] = val;
    }
    if (i == 2)
    {
      vc[4] = val;
    }
    if (i == 3)
    {
      v[4] = val;
    }
    delay(10);

    // Serial.println ("VoltsC:" + String (vc[1]) + ":" + String (vc[2]) + ":" + String (vc[3]) + ":" + String (vc[4]));
    // Serial.println ("VoltsB:" + String (v[1]) + ":" + String (v[2]) + ":" + String (v[3]) + ":" + String (v[4]));
  }
  // }

}

