String SendHTML()
{
  String ptr = "<!DOCTYPE html> <html>\n";
  ptr += "<meta HTTP-equiv='refresh' content = " + String(htmlRefresh) + ">\n";
  ptr += "<head>\n";
  ptr += "<title>Battery Charger</title>\n"; //This is the browser tab title
  ptr += "<link rel = 'icon' href = 'data:,'>\n";//suppresses '/favicon'
  ptr += "<style>html { font-family: Arial; display: inline-block; margin: 5px auto; text-align: left;}\n";
  ptr += "body{margin-top: 5px;} h1 {color: #444444;margin: 5px auto 5px;} h3 {color: #444444;margin-bottom: 15px;}\n";
  ptr += ".button {display: block;width: 50px;background-color: rgb(0,200,0);border: none;color: white;padding: 10px 20px;text-decoration: none;font-size: 15px;margin: 0px auto 5px;cursor: pointer;border-radius: 10px;}";
  ptr += "</style>\n";
  ptr += "<style>table, th, td {border: 2px solid black;text-align: center; inline-block;}</style>";
  ptr += "</head>\n";
  if (commandSuccess)
  {
    ptr += "<script>\n";
    ptr += doneString; //ptr += "window.location.assign( 'http://10.0.0.20:80/done')\n";  // to prevent repeated refresh IP Address == ESP8266 IP address
    ptr += "</script>\n";
  }
  else
  {
    commandSuccess = false;
  }
  ptr += "<body>\n";
  ptr += "<h2>Battery Charger ( " + htmlMode  +" ) </h2>";

  //***Start of Controls Table
  if (htmlMode == "Main View")
  {
    ptr += "<h3><table>";
    ptr += "<tr><th style = 'width: 115px'>Start/Stop</th> <th style = 'width: 115px'>   Setting   </th><th style = 'width: 115px'> Decrease </th><th style = 'width: 115px'> Increase</th></tr>";
    //***Stop Start Button
    if (controlMode == "On")
    {
      ptr += "<tr><td><a class =\"button button\" href =\"/stop\"   style = 'background-color: rgb(255,0,0)'>Stop</td>";
    }
    else
    {
      ptr += "<tr><td><a class =\"button button\" href =\"/start\">Start</td>";
    }
    //***Voltage Setting
    ptr += "<td>" + String (convert3Dp(v[0])) + " V  </td>";
    //***Decrease V Button
    ptr += "<td><a class =\" button button-on\" href =\"/decreaseV\">Volts-";
    //***Increase V Button
    ptr += "<td><a class =\" button button-on\" href =\"/increaseV\">Volts+";

    //***Current Setting
    ptr += "<tr><td>" + heartBeat + "   " + messageControl + "</td><td>" + String (a[0]) + " mA  </td>";
    //***Decrease A Button
    ptr += "<td><a class =\" button button-on\" href =\"/decreaseA\">Amp-</td>";
    //***Increase A Button
    ptr += "<td><a class =\" button button-on\" href =\"/increaseA\">Amp+ </td>";

    //***Temperature Setting
    ptr += "<tr><td>" + convert2Dp(t[0] + t[5]) + " C   </td><td>" + String (int((t[0] / 100))) + " C  </td>";
    //***Decrease T Button
    ptr += "<td><a class =\" button button-on\" href =\"/decreaseT\">Temp-</td>";
    //***Increase T Button
    ptr += "<td><a class =\" button button-on\" href =\"/increaseT\">Temp+ </td>";

    //***Time Setting
    ptr += "<tr><td>" + String (timerMinutes) + " mins   </td><td>" + String (setMinutes) + " mins  </td>";
    //***Decrease Minutes Button
    ptr += "<td><a class =\" button button-on\" href =\"/decreaseM\">Time-</td>";
    //***Increase Minutes Button
    ptr += "<td><a class =\" button button-on\" href =\"/increaseM\">Time+ </td>";
    ptr += "</td> </tr></table></h3>";
    //ptr += "<p class = 'small'>";
  }
  //***End of Table
  //***Start of Batteries Table
  if (htmlMode == "Main View" or htmlMode == "Battery View")
  {
    ptr += "<h3><table>";
    ptr += "<tr><th style = 'width: 115px'> Battery 1 </th> <th style = 'width: 115px' >  Battery 2  </th><th style = 'width: 115px'> Battery 3 </th><th style = 'width: 115px'> Battery 4 </th></tr>";
    ptr += "<tr><td>" + String (convert3Dp(v[1])) + " V   </td><td>" + String (convert3Dp(v[2])) + " V  </td><td>" + String (convert3Dp(v[3])) + " V  </td><td>" + String (convert3Dp(v[4])) + " V</td></tr>";
    ptr += "<tr bgcolor = lightgrey> <td>" + String (a[1]) + " mA   </td><td>" + String (a[2]) + " mA  </td><td>" + String (a[3]) + " mA  </td><td>" + String (a[4]) + " mA</td></tr>";
    ptr += "<tr><td>" + String (int(c[1] / 1000)) + " mAHr   </td><td>" + String (int (c[2] / 1000)) + " mAHr  </td><td>" + String (int (c[3] / 1000)) + " mAHr  </td><td>" + String (int (c[4] / 1000)) + " mAHr</td></tr>";
    ptr += "<tr><td>" + String (convert2Dp(t[1])) + "  C   </td><td>" + String (convert2Dp(t[2])) + " C  </td><td>" + String (convert2Dp(t[3])) + " C  </td><td>" + String (convert2Dp(t[4])) + " C</td>";
    ptr += "</table></h3>\n";
  }
  //***end of Table

  //***Start of Presets Table
  if (htmlMode == "Main View")
  {
    ptr += "<h3><table>";
    ptr += "<tr><th colspan = '5'> Presets </th></tr>";
    ptr += "<tr>";
    ptr += "<td><a class =\"button button\" href =\"/presetV1500\">1.5V</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetV2000\">2.0V</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetV3700\">3.7V</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetV4100\">4.1V</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetV4200\">4.2V</td>";
    ptr += "</tr>";
    ptr += "<tr>";
    ptr += "<td><a class =\"button button\" href =\"/presetm50\">50mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetm100\">100mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetm150\">150mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetm200\">200mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetm250\">250mA</td>";
    ptr += "</tr>";
    ptr += "<tr>";
    ptr += "<td><a class =\"button button\" href =\"/presetm300\">300mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetm350\">350mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetm400\">400mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetm450\">450mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/presetm500\">500mA</td>";
    ptr += "</tr>";
    ptr += "</table></h3>";
    //***end of Table
  }
  //***Start of Message Table
    ptr += "<h4><table>";
    ptr += "<tr><th style = 'width: 480px' > Messages. </th></tr>";
    ptr += "<tr><td>" + message1 + "</td></tr>";
    ptr += "<tr><td>" + message + "</td></tr>";
    ptr += "</table></h4>";
    //***end of Table
  

  //***Start of Extras Table
  if (htmlMode == "Main View" )
  {
    ptr += "<h4><table>";
    
    ptr += "<tr><h4>";
    ptr += "<td><a class =\"button button\" href =\"/batteryView\">Battery View</td>";
    ptr += "<td><a class =\"button button\" href =\"/settingsView\">Settings View</td>";
    ptr += "<td><a class =\"button button\" href =\"/saveDefaults\">Save Defaults</td>";
    ptr += "<td><a class =\"button button\" href =\"/viewDefaults\">View Defaults</td>";
    ptr += "<td><a class =\"button button\" href =\"/clearMessage\">Clear Message</td>";    ptr += "</tr>";
    ptr += "<tr>";
    if (adjust)
    {
      ptr += "<td><a class =\"button button\" href =\"/stopAdjust\">Stop Adjust</td>";
    }
    else
    {
      ptr += "<td><a class =\"button button\" href =\"/startAdjust\">Start Adjust</td>";
    }
    ptr += "<td><a class =\"button button\" href =\"/version\">FW Version</td>";
    ptr += "<td></td>";
    ptr += "<td></td>";
    ptr += "<td></td>";
    ptr += "</tr></table></h4>";
  }
  if (htmlMode == "Battery View")
  {
    ptr += "<table><tr><td><h4><a class =\"button button\" href =\"/mainView\">Main View</td>";
    if (controlMode == "On")
    {
      ptr += "<td><a class =\"button button\" href =\"/stop\"   style = 'background-color: rgb(255,0,0)'>Stop</td>";
    }
    else
    {
      ptr += "<td><a class =\"button button\" href =\"/start\">Start</td>";
    }
    ptr += "<td><a class =\"button button\" href =\"/clearMessage\">Clear Message</td>";
    ptr += "</tr></table></h4>";
  }
  //*** End of Table

  if (htmlMode == "Settings View")
  {
    ptr += "<h4><table>";
    //ptr += "<tr><th> Preset </th> <th>   Preset </th><th> Preset </th><th>Preset</th><th> Preset</th></tr>";
    
    ptr += "<tr><td><a class =\"button button\" href =\"/mainView\">Main View</td>";
    ptr += "<td><a class =\"button button\" href =\"/viewSettings\"> View Settings</td>";
    ptr += "<td><a class =\"button button\" href =\"/saveSettings\"> Save Settings</td>";
    ptr += "<td><a class =\"button button\" href =\"/viewNetwork\"> View Network</td>";
    ptr += "<td><a class =\"button button\" href =\"/clearMessage\">Clear Message</td>";
    ptr += "</tr>";
    ptr += "<tr><td><a class =\"button button\" href =\"/ref5\"> Refresh  5 secs</td>";
    ptr += "<td><a class =\"button button\" href =\"/ref10\"> Refresh  10 secs</td>";
    ptr += "<td><a class =\"button button\" href =\"/ref15\"> Refresh 15 secs</td>";
    ptr += "<td><a class =\"button button\" href =\"/ref30\"> Refresh 30 secs</td>";
    ptr += "<td><a class =\"button button\" href =\"/ref60\">Refresh 60 secs</td>";
    ptr += "</tr>";
    ptr += "<tr><td><a class =\"button button\" href =\"/incV10\">Inc 10mV</td>";
    ptr += "<td><a class =\"button button\" href =\"/incV20\">Inc 20mV</td>";
    ptr += "<td><a class =\"button button\" href =\"/incV50\">Inc 50mV</td>";
    ptr += "<td><a class =\"button button\" href =\"/incV100\">Inc 100mV</td>";
    ptr += "<td><a class =\"button button\" href =\"/incV500\">Inc 500mV</td>";
    ptr += "</tr>";
    ptr += "<tr><td><a class =\"button button\" href =\"/incA10\">Inc 10mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/incA20\">Inc 20mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/incA50\">Inc 50mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/incA100\">Inc 100mA</td>";
    ptr += "<td><a class =\"button button\" href =\"/incA150\">Inc 150mA</td>";
    ptr += "</tr>";
    ptr += "<tr><td><a class =\"button button\" href =\"/incM30\">Inc 30 mins</td>";
    ptr += "<td><a class =\"button button\" href =\"/incM60\">Inc 60 mins</td>";
    ptr += "<td><a class =\"button button\" href =\"/incM120\">Inc 120 mins</td>";
    ptr += "<td><a class =\"button button\" href =\"/incM180\">Inc 180 mins</td>";
    ptr += "<td><a class =\"button button\" href =\"/incM240\">Inc 240 mins</td>";
    ptr += "</tr>";
    ptr += "</table></h4>";
  }
  //*** End of Table
  ptr += "</body>\n";
  ptr += "</html>\n";
  return ptr;
}
