void saveData(String item)
{
  if (item == "Defaults")
  {
    EEPROM.write(10, lowByte(v[0]));
    EEPROM.write(11, highByte(v[0]));
    EEPROM.write(12, lowByte(a[0]));
    EEPROM.write(13, highByte(a[0]));
    EEPROM.write(14, lowByte(t[0]));
    EEPROM.write(15, highByte(t[0]));
    EEPROM.write(16, lowByte(setMinutes));
    EEPROM.write(17, highByte(setMinutes));
    EEPROM.commit();
    message = "Defaults Saved:<p>";
    message += "Voltage: " + convert3Dp(v[0]) + "V <p>";
    message += "Current: " + String (a[0]) + " mA<p>";
    message += "Temperature: " + String (int(t[0] / 100)) + " C<p>  ";
    message += "Time: " + String (setMinutes) + " mins<p>";

  }
  if (item == "Settings")
  {
    EEPROM.write(18, lowByte(incrementV));
    EEPROM.write(19, highByte(incrementV));
    EEPROM.write(20, lowByte(incrementA));
    EEPROM.write(21, highByte(incrementA));
    EEPROM.write(22, lowByte(incrementT));
    EEPROM.write(23, highByte(incrementT));
    EEPROM.write(24, lowByte(incrementM));
    EEPROM.write(25, highByte(incrementM));
    EEPROM.write(26, lowByte(htmlRefresh));
    EEPROM.write(27, highByte(htmlRefresh));

    EEPROM.commit();
    message = "Settings Saved:<p>";
    message += "Page refresh rate: " + String (htmlRefresh) + " secs<p>";
    message += "Voltage increment: " + convert3Dp(incrementV) + " V <p>";
    message += "Current increment: " + String (incrementA) + " mA<p>";
    message += "Temperature increment: " + String (String(int(incrementT / 100))) + " C<p>  ";
    message += "Time increment: " + String (incrementM) + " mins<p>";

  }
}
