; Electronic Ignition

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB3  & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _XT_OSC

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations

; Bank 0 RAM

SUPPLY			equ	H'20'	; 12V supply monitor
TIMERH			equ	H'21'	; timer 1 high byte store
TIMERL			equ	H'22'	; timer 1 low byte store
DWELL_H			equ	H'23'	; dwell value high byte
DWELL_L			equ	H'24'	; dwell value low byte
SPARK_DURH		equ	H'25'	; spark duration ms byte
SPARK_DURL		equ	H'26'	; spark duration ls byte
STORE1			equ	H'27'	; temporary working store
PORT_FLG		equ	H'28'	; port change flag
OVFLOW_FLG		equ H'29'	; timeout flag
DWELL_CALC		equ	H'2A'	; calculated dwell based on supply and links
TEMP_STO		equ	H'2B'	; temporary store 0
TEMP_STO1		equ	H'2C'	; temporary store 1
TIMER_OVR		equ	H'2D'	; timer overflow
TIMER_COUNT1	equ	H'2E'	; timeout counter
TIMER_COUNT2	equ	H'2F'	; timeout counter
DELAY_COUNT1	equ	H'30'	; delay for debounce
DELAY_COUNT2	equ	H'31'	; delay for debounce
DELAY_COUNT3	equ	H'32'	; interrupt delay for debounce
DELAY_COUNT4	equ	H'33'	; interrupt delay for debounce
DEBOUNCE		equ	H'34'	; debounce
MULTIPLY		equ	H'36'	; multiplier
HIGH_AD			equ	H'37'	; high byte of analog to digital converter
CONVERSION		equ	H'38'	; delay for setting up A/D
TIMEOLDH		equ	H'39'	; old timer value
TIMEOLDL	 	equ	H'3A'
SUB_H			equ	H'3B'	; subtracted timer value
SUB_L			equ	H'3C'
STORE3			equ	H'3D'	; delay count
STORE2			equ	H'3E'
		
; All Banks RAM

W_TMP			equ	H'72'	; storage of w before interrupt
STATUS_TMP		equ	H'73'	; status storage before interrupt
PCLATH_STO		equ	H'74'	; PCLATH
FIRE_FLG		equ	H'75'	; fire flag, included to reduce latency @6us & 7us for normal and follow. 
; start at memory 0

	org	0
	goto	SETUP
	org	4	
; interrupt		
	btfss	FIRE_FLG,0	; if set fire
	goto	INTERRUPT
	clrf	CCP1CON
	bcf		PORTB,3
	goto	INTERRUPT

; **********************************************************************************************
; lookup table for dwell variation with voltage
DWELL_LOOK
	addwf	PCL,f		; add value to program counter
	retlw	H'04'		; for below 117
	retlw	H'04'		; for 118
	retlw	H'04'		; for 119
	retlw	H'04'		; for 120
	retlw	H'04'		; for 121
	retlw	H'04'		; for 122
	retlw	H'04'		; for 123
	retlw	H'04'		; for 124
	retlw	H'04'		; for 125
	retlw	H'04'		; for 126
	retlw	H'04'		; for 127
	retlw	H'04'		; for 128
	retlw	H'04'		; for 129
	retlw	H'04'		; for 130
	retlw	H'04'		; for 131
	retlw	H'04'		; for 132
	retlw	H'04'		; for 133
	retlw	H'04'		; for 134
	retlw	H'04'		; for 135
	retlw	H'04'		; for 136
	retlw	H'04'		; for 137
	retlw	H'04'		; for 138
	retlw	H'03'		; for 139
	retlw	H'03'		; for 140
	retlw	H'03'		; for 141
	retlw	H'03'		; for 142
	retlw	H'03'		; for 143
	retlw	H'03'		; for 144
	retlw	H'03'		; for 145
	retlw	H'03'		; for 146
	retlw	H'03'		; for 147
	retlw	H'03'		; for 148
	retlw	H'03'		; for 149
	retlw	H'03'		; for 150
	retlw	H'03'		; for 151
	retlw	H'03'		; for 152
	retlw	H'03'		; for 153
	retlw	H'03'		; for 154
	retlw	H'03'		; for 155
	retlw	H'03'		; for 156
	retlw	H'03'		; for 157
	retlw	H'03'		; for 158
	retlw	H'03'		; for 159
	retlw	H'03'		; for 160
	retlw	H'03'		; for 161
	retlw	H'03'		; for 162
	retlw	H'03'		; for 163
	retlw	H'03'		; for 164
	retlw	H'02'		; for 165
	retlw	H'02'		; for 166	;
	retlw	H'02'		; for 167
	retlw	H'02'		; for 168
	retlw	H'02'		; for 169
	retlw	H'02'		; for 170
	retlw	H'02'		; for 171
	retlw	H'02'		; for 172
	retlw	H'02'		; for 173
	retlw	H'02'		; for 174
	retlw	H'02'		; for 175
	retlw	H'02'		; for 176
	retlw	H'02'		; for 177
	retlw	H'02'		; for 178
	retlw	H'02'		; for 179
	retlw	H'02'		; for 180
	retlw	H'02'		; for 181
	retlw	H'02'		; for 182
	retlw	H'02'		; for 183
	retlw	H'02'		; for 184
	retlw	H'02'		; for 185
	retlw	H'02'		; for 186
	retlw	H'02'		; for 187
	retlw	H'02'		; for 188
	retlw	H'01'		; for 189
	retlw	H'01'		; for 190
	retlw	H'01'		; for 191
	retlw	H'01'		; for 192
	retlw	H'01'		; for 193
	retlw	H'01'		; for 194
	retlw	H'01'		; for 195
	retlw	H'01'		; for 196

	org		H'100'
NON_LINEAR ; make trim pot less sensitive at low anticlockwise levels
	addwf	PCL,f		; add value to program counter
	retlw	D'1'		; 0
	retlw	D'1'
	retlw	D'1'
	retlw	D'1'
	retlw	D'1'		; 4
	retlw	D'2'		; 5
	retlw	D'2'
	retlw	D'2'
	retlw	D'2'
	retlw	D'2'		; 9
	retlw	D'3'		; 10
	retlw	D'3'
	retlw	D'3'
	retlw	D'3'
	retlw	D'3'		; 14
	retlw	D'4'		; 15
	retlw	D'4'
	retlw	D'4'
	retlw	D'4'
	retlw	D'5'		; 19
	retlw	D'5'		; 20
	retlw	D'5'
	retlw	D'5'
	retlw	D'6'
	retlw	D'6'		; 24
	retlw	D'6'		; 25
	retlw	D'6'
	retlw	D'7'
	retlw	D'7'
	retlw	D'7'		; 29
	retlw	D'7'		; 30
	retlw	D'8'
	retlw	D'8'
	retlw	D'8'
	retlw	D'8'		; 34
	retlw	D'9'		; 35
	retlw	D'9'
	retlw	D'9'
	retlw	D'9'
	retlw	D'10'		; 39
	retlw	D'10'		; 40
	retlw	D'10'
	retlw	D'10'		; 
	retlw	D'11'		; 
	retlw	D'11'
	retlw	D'11'
	retlw	D'11'
	retlw	D'12'		; 
	retlw	D'12'		; 
	retlw	D'12'
	retlw	D'12'
	retlw	D'13'
	retlw	D'13'		; 
	retlw	D'13'		; 
	retlw	D'13'
	retlw	D'14'
	retlw	D'14'
	retlw	D'14'		; 
	retlw	D'14'		; 
	retlw	D'15'
	retlw	D'15'
	retlw	D'15'
	retlw	D'16'		; 
	retlw	D'16'		; 
	retlw	D'16'
	retlw	D'17'
	retlw	D'17'
	retlw	D'17'		; 
	retlw	D'18'		; 
	retlw	D'18'
	retlw	D'18'
	retlw	D'19'
	retlw	D'19'		; 
	retlw	D'19'		; 
	retlw	D'20'
	retlw	D'20'
	retlw	D'20'
	retlw	D'21'		; 77
	retlw	D'21'		; 
	retlw	D'21'
	retlw	D'22'
	retlw	D'22'
	retlw	D'22'		; 
	retlw	D'23'		; 
	retlw	D'23'
	retlw	D'24'
	retlw	D'24'
	retlw	D'25'		; 
	retlw	D'25'		; 
	retlw	D'26'
	retlw	D'26'
	retlw	D'27'
	retlw	D'27'		; 
	retlw	D'28'		; 
	retlw	D'28'
	retlw	D'29'
	retlw	D'30'
	retlw	D'31'		; 
	retlw	D'32'		; 
	retlw	D'33'
	retlw	D'34'
	retlw	D'35'
	retlw	D'36'		; 
	retlw	D'37'		; 
	retlw	D'38'
	retlw	D'39'
	retlw	D'40'
	retlw	D'41'		; 
	retlw	D'42'		; 
	retlw	D'43'
	retlw	D'44'
	retlw	D'45'
	retlw	D'46'		; 
	retlw	D'47'		; 
	retlw	D'48'
	retlw	D'49'		; 
	retlw	D'50'		; 
	retlw	D'51'
	retlw	D'52'
	retlw	D'53'
	retlw	D'54'		; 
	retlw	D'55'		; 
	retlw	D'56'
	retlw	D'57'
	retlw	D'58'
	retlw	D'59'		; 
	retlw	D'60'		; 
	retlw	D'61'
	retlw	D'62'
	retlw	D'63'
	retlw	D'64'		; 
	retlw	D'65'		; 131
	retlw	D'67'
	retlw	D'69'
	retlw	D'71'
	retlw	D'73'		; 
	retlw	D'75'		; 
	retlw	D'77'
	retlw	D'79'
	retlw	D'81'
	retlw	D'83'		; 
	retlw	D'85'		; 
	retlw	D'87'
	retlw	D'89'
	retlw	D'91'
	retlw	D'93'		; 
	retlw	D'95'		; 
	retlw	D'97'
	retlw	D'99'
	retlw	D'101'		; 149
	retlw	D'103'		; 150
	retlw	D'105'		; 
	retlw	D'107'		; 
	retlw	D'109'
	retlw	D'111'
	retlw	D'113'
	retlw	D'115'		; 
	retlw	D'117'		; 
	retlw	D'119'
	retlw	D'121'
	retlw	D'123'
	retlw	D'125'		; 
	retlw	D'127'		; 
	retlw	D'129'
	retlw	D'131'
	retlw	D'133'		; 165
	retlw	D'135'		; 166
	retlw	D'137'		; 
	retlw	D'139'		; 
	retlw	D'141'
	retlw	D'143'
	retlw	D'145'
	retlw	D'147'		; 
	retlw	D'149'		; 
	retlw	D'151'
	retlw	D'153'
	retlw	D'155'
	retlw	D'157'		; 
	retlw	D'159'		; 
	retlw	D'161'
	retlw	D'163'
	retlw	D'165'		; 181
	retlw	D'167'		; 182
	retlw	D'169'	
	retlw	D'171'
	retlw	D'173'		; 
	retlw	D'175'		; 
	retlw	D'177'
	retlw	D'179'
	retlw	D'181'
	retlw	D'183'		; 
	retlw	D'185'		; 
	retlw	D'187'
	retlw	D'189'
	retlw	D'191'		; 
	retlw	D'193'		; 195
	retlw	D'195'	
	retlw	D'197'
	retlw	D'199'
	retlw	D'201'		; 199
	retlw	D'203'		; 200
	retlw	D'203'		; 200

SETUP
	movlw	B'00000000'
	movwf	PORTB		; portB,3 output low so coil off
	bsf		STATUS,RP0	; select memory bank 1

	movlw	D'255'

	movwf	STORE3
DELAY
	movlw	D'30'
	movwf	STORE2
LOOP#
	decfsz	STORE2,f
	goto	LOOP#
	decfsz	STORE3,f
	goto	DELAY	

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11100101'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00100110'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled TMR0/256)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'01000110'	; AN1,2,6 analog inputs
	movwf	ANSEL
	movlw	B'01000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0

	movlw	B'01010000'	; Fosc, channel 2 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

	movlw	B'00110001'	; timer 1 fosc/4 /8
	movwf	T1CON

; initial conditions
INITIAL

	movlw	H'00'
	movwf	CCP1CON		; reset compare mode
	bcf		PORTB,3		; coil off

	bcf		OVFLOW_FLG,0	; timeout flag
	movlw	H'06'
	movwf	DWELL_CALC		; set at high dwell
	clrf	TIMER_OVR		; overflow flag
	clrf	TIMER_COUNT1	; timeout counter
	clrf	TIMER_COUNT2	; timeout counter
	clrf	TIMEOLDH		; old timer value
	clrf	TIMEOLDL		; old timer value


; *********************************************************************
; spark test
SPARK_TEST

; spark test

	btfsc	PORTB,6
	goto	CK_MODE

	bcf		INTCON,GIE	; clear global interrupt enable
	movlw	H'00'
	movwf	CCP1CON		; reset compare mode
	bcf		PORTB,3		; coil off

	
; A/D conversion
; use debounce for frequency of spark
; debounce for 167us-5ms in 30 steps/ 167us / step 
; check debounce setting
; Channel 2 A/D value debounce VR2
; set A/D to channel 2
	movlw	B'01010001'	; Fosc, channel,2 etc
	movwf	ADCON0
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	DEBOUNCE	; keep value

	movlw	D'50'
	addwf	DEBOUNCE,w
	btfss	STATUS,C
	goto	DWELL1			; if over set at 205
	movlw	D'205'
	movwf	DEBOUNCE	; ensure it is 205 or less

DWELL1
; alter dwell with VR1 setting
; set A/D to channel 1. dwell
	movlw	B'01001001'	; Fosc, channel,1 etc
	movwf	ADCON0
	call	ACQUIRE_AD	; get value
	movf	ADRESH,w
; remove first 55 digits to counteract non linearity of trim pot at lower end	
	movwf	MULTIPLY
	movlw	D'55'
	subwf	MULTIPLY,w
	btfss	STATUS,C
	clrw				; if negative set at 0
	movwf	MULTIPLY

; nonlinearise pot travel
	movf	MULTIPLY,w
	bsf		PCLATH,0
	call	NON_LINEAR
	movwf	DWELL_CALC

; wait for timer 0
WAIT1
	btfss	INTCON,TMR0IF
	goto	WAIT1
	clrf	TMR0
	movf	DEBOUNCE,w
	movwf	TMR0
	bcf		INTCON,TMR0IF

DWELL_PER;iod
; dwell period
	bsf		PORTB,3			; coil on
	movf	DWELL_CALC,w
	movwf	DELAY_COUNT1	; initial values
LOOP8
	movlw	D'31'
	movwf	DELAY_COUNT2
LOOP7	
	nop
	decfsz	DELAY_COUNT2,f	; reduce
	goto	LOOP7
	decfsz	DELAY_COUNT1,f
	goto	LOOP8

	bcf		PORTB,3			; coil off/ spark

	goto	SPARK_TEST

; *********************************************************************

CK_MODE
	btfss	PORTB,6
	goto	SPARK_TEST

CK_POINTS ; or NORMAL
; check for points mode (follow) or normal
; check LK1 if low then follow for points mode
	bcf		PORTB,3
	btfss	PORTB,5		; if set normal
	goto	POINTS_MODE	; points mode of operation

; spark duration minimum value at 1ms
SET_SPARK_DUR
	movlw	H'00'		; 
	movwf	SPARK_DURH
	movlw	D'125'		; 
	movwf	SPARK_DURL

; setup interrupt edge
SET_EDGE

	btfsc	PORTB,2		; if high invert
	goto	L_INT1		; set high going edge
	bsf		STATUS,RP0	; select memory bank 1
	bcf		OPTION_REG,INTEDG	; low going interrupt edge
	goto	BY_L_INT1
L_INT1
	bsf		STATUS,RP0	; select memory bank 1		
	bsf		OPTION_REG,INTEDG	; high going interrupt edge
BY_L_INT1		
	bcf		STATUS,RP0	; select memory bank 0

; allow interrupts
ALL_INTERRUPTS
	bcf		INTCON,INTF ; clear interrupt edge flag 
	bsf		INTCON,INTE	; interrupt level at RB0
 
BACKGROUND
	btfss	PORTB,6
	goto	SPARK_TEST
	btfss	PORTB,5		; check normal mode
	goto	CK_POINTS

; timeout for coil to go off after 1s if no interrupts of ignition firing
	btfsc	OVFLOW_FLG,0	; if set already timed out
	goto	A_D
	incfsz	TIMER_COUNT1,f	; ls byte next count
	goto	A_D
	incfsz	TIMER_COUNT2,f	; ms byte
	goto	A_D
	movlw	H'00'
	movwf	CCP1CON		; reset compare mode
	bcf		PORTB,3		; coil off
	bsf		OVFLOW_FLG,0

; A/D conversion
A_D

; debounce for 167us-5ms in 30 steps/ 167us / step 
; check debounce setting
; Channel 2 A/D value debounce VR2
; set A/D to channel 2
	movlw	B'01010001'	; Fosc, channel,2 etc
	movwf	ADCON0
	call	ACQUIRE_AD
; divide by 8
	bcf		STATUS,C
	rrf		ADRESH,f	;
	bcf		STATUS,C
	rrf		ADRESH,f
	bcf		STATUS,C
	rrf		ADRESH,w
	movwf	DEBOUNCE	; keep value
; remove first 2 digits to counteract non linearity of trim pot at lower end	
	movlw	D'2'
	subwf	DEBOUNCE,w
	btfss	STATUS,C
	clrw				; if negative set at 0
	addlw	D'1'
	movwf	DEBOUNCE	; ensure it is 1 or more

; Channel 6 A/D value Batt. Voltage
; set A/D to channel 6
	movlw	B'01110001'	; Fosc, channel,6 etc
	movwf	ADCON0
	call	ACQUIRE_AD
	
; alter dwell with voltage 

; test for >195 and <118 (equivalent to 12V and 7.2V respectively)
	movlw	D'195'
	subwf	ADRESH,w
	btfsc	STATUS,C	; 
	goto	GRT_V		; > 12V
	movlw	D'118'
	subwf	ADRESH,w
	btfss	STATUS,C
	goto	LESS_V		; < 7.2V
	call	DWELL_LOOK	; lookup table to alter dwell depending on voltage
	goto	SET_DWELL
GRT_V
; set at minimum (x1)
	movlw	H'01'		; for min dwell at 12V and above
	goto	SET_DWELL
LESS_V
; set at x4
	movlw	D'04'		; max dwell below 7.2V

SET_DWELL
	movwf	TEMP_STO
	
; alter dwell with VR1 setting
; set A/D to channel 1. dwell
	movlw	B'01001001'	; Fosc, channel,1 etc
	movwf	ADCON0
	call	ACQUIRE_AD	; get value
	movf	ADRESH,w
; remove first 55 digits to counteract non linearity of trim pot at lower end	
	movwf	MULTIPLY
	movlw	D'55'
	subwf	MULTIPLY,w
	btfss	STATUS,C
	clrw				; if negative set at 0
	movwf	MULTIPLY
	movf	MULTIPLY,w	; if zero then value x1
	btfsc	STATUS,Z
	goto	SET_VAL		; no change to value

; nonlinearise pot travel
	movf	MULTIPLY,w
	bsf		PCLATH,0
	call	NON_LINEAR
	clrf	PCLATH
	movwf	MULTIPLY	
	movf	TEMP_STO,w	; original value
NEXT_MULT
	addwf	TEMP_STO,f	; add to multiply by next number
	btfsc	STATUS,C	; if carry is set then over 255
	goto	SET_MAX_VAL	
	decfsz	MULTIPLY,f	; if zero leave multiply (continue till value is zero)
	goto	NEXT_MULT

SET_VAL
	movf	TEMP_STO,w
SET_VAL2
	movwf	DWELL_CALC
	bsf		INTCON,GIE	; set global interrupt enable
	goto	BACKGROUND
SET_MAX_VAL
	movlw	D'255'
	goto	SET_VAL2
	
 ; ******************************************************************************************************
; INTERRUPT
	
INTERRUPT
	
; check for points mode or normal
; check LK1 if low then points mode
	btfss	PORTB,5		; if set normal
	goto	INTERRUPT_POINTS ; 'follow' for points mode of operation
; start interrupt by saving w and status registers 
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	bcf		STATUS,RP0	; select memory bank 0
;	movf	PCLATH,w
;	movwf	PCLATH_STO
;	clrf	PCLATH

; edge interrupt:


; reverse interrupt edge

	bsf		STATUS,RP0	; select memory bank 1
	btfss	OPTION_REG,INTEDG	; check edge
	goto	SET_EDGES
	bcf		OPTION_REG,INTEDG	; opposite edge
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTB,4
	goto	CHK_EDGE_LEVEL
SET_EDGES
	bsf		OPTION_REG,INTEDG	; set 
	bcf		STATUS,RP0	; select memory bank 0
	bsf		PORTB,4
CHK_EDGE_LEVEL 
 
	btfss	PORTB,2		; if high and INTEG low fire coil
	goto	L_INTEGH		; 
	
	bsf		STATUS,RP0	; select memory bank 1
	btfss	OPTION_REG,INTEDG	; if low fire coil
	goto	FIRE
	bsf		FIRE_FLG,0
	goto	RECLAIM
L_INTEGH
	bsf		STATUS,RP0	; select memory bank 1		
	btfsc	OPTION_REG,INTEDG	; if high fire coil
	goto	FIRE
	bsf		FIRE_FLG,0
	goto	RECLAIM

; on interrupt for edge
FIRE
	bcf		STATUS,RP0	; select memory bank 0
	bcf		FIRE_FLG,0
	bcf		OVFLOW_FLG,0; clear overflow flag

; set RB3 for ignition firing point
	movlw	H'00'
	movwf	CCP1CON		; change settings to allow RB3 high on next settings change

	movlw	B'00001000'	; compare mode set output low on match
	movwf	CCP1CON		; sets RB3 low

; clear timeout counters

	clrf	TIMER_COUNT1	; timeout counter

; check debounce
	movf	DEBOUNCE,w
	sublw	D'12'			; check debounce value
	movlw	D'200'			; setup for 10s timeout
	btfsc	STATUS,C
	movlw	D'248'			; use shorter timeout (1s) for <2ms debounce
	movwf	TIMER_COUNT2

	bcf		PIR1,TMR1IF	; clear flag 
	bcf		TIMER_OVR,0	; overflow flag cleared

; read timer 1
	movf	TMR1H,w		; timer high byte
	movwf	TIMERH
	movf	TMR1L,w		; timer low byte
	movwf	TIMERL
	movf	TMR1H,w		; read again to check if changed
	xorwf	TIMERH,w
	btfsc	STATUS,Z	; if the same continue
	goto	SUB_OLD_NEW	; otherwise read timer because of timer count rollover
	movf	TMR1H,w		; timer high byte
	movwf	TIMERH
	movf	TMR1L,w		; timer low byte
	movwf	TIMERL

SUB_OLD_NEW

; subtract new from older timer values. If old is > then add subtracted value to dwell

	movf	TIMERH,w	; ms byte
	subwf	TIMEOLDH,w	; subtract ms bytes
	movwf	SUB_H
	movf	TIMERL,w	; low byte
	subwf	TIMEOLDL,w
	movwf	SUB_L
	btfss	STATUS,C
	decf	SUB_H,f		; decrease if ls bytes carry

; update old timer value
	movf	TIMERH,w
	movwf	TIMEOLDH
	movf	TIMERL,w
	movwf	TIMEOLDL
	

RESET_TIME

; Reset timer1
	bcf		T1CON,0		; stop timer
	clrf	TMR1L		; low byte of timer clear
	clrf	TMR1H		; high byte clear	
	bsf		T1CON,0		; restart timer 

; read timer 1 and subtract (DWELL). Store subtracted value into capture 
; If less than 1ms 
; then set coil on at 1ms. if > 1ms then set coil on at subtracted value 

; set coil charge period using capture compare

	movf	DWELL_CALC,w ; calculated dwell value
	movwf	DWELL_H		; high byte dwell
	clrf	DWELL_L		; ls byte cleared
; divide by 2
	bcf		STATUS,C
	rrf		DWELL_H,f
	rrf		DWELL_L,f
; divide by 4
	bcf		STATUS,C
	rrf		DWELL_H,f
	rrf		DWELL_L,f
; divide by 8
	bcf		STATUS,C
	rrf		DWELL_H,f
	rrf		DWELL_L,f
; divide by 16
	bcf		STATUS,C
	rrf		DWELL_H,f
	rrf		DWELL_L,f
	
	btfsc	SUB_H,7		; if clear then add subtracted value to dwell
	goto	CK_DWELL_TIMER
; high
	movf	SUB_H,w		; subtracted value ms byts
	addwf	DWELL_H,f
	btfsc	STATUS,C	; if over set at FF
	goto	SET_MAX
; low
	movf	SUB_L,w
	addwf	DWELL_L,f
	movlw	D'1'
	btfsc	STATUS,C	; if overrange	
	addwf	DWELL_H,f
	btfss	STATUS,C	; if over set at FF
	goto	CK_DWELL_TIMER
SET_MAX	
	movlw	H'FF'
	movwf	DWELL_H
	movwf	DWELL_L

CK_DWELL_TIMER
; check if DWELL>TIMER if so then set at spark duration
	movf	TIMERH,w	; ms byte
	subwf	DWELL_H,w	; see if larger (value is plus if larger)
	movwf	STORE1		; save
	movf	TIMERL,w
	subwf	DWELL_L,w
	btfss	STATUS,C
	decf	STORE1,f
	btfss	STORE1,7	; see if set
	goto	SET_SPARK	; set at 1ms 
	
; subtract TIMERH TIMERL - DWELL_H DWELL_L = TIMERH TIMERL
	movf	DWELL_H,w	; ms byte
	subwf	TIMERH,f	; subtract ms bytes
	movf	DWELL_L,w	; low byte
	subwf	TIMERL,f
	btfss	STATUS,C
	decf	TIMERH,f	; decrease if ls bytes carry	

; compare with SPARK_DURation

	movf	TIMERH,w	; ms byte
	subwf	SPARK_DURH,w; spark duration ms byte 
	movwf	STORE1
	movf	TIMERL,w
	subwf	SPARK_DURL,w; check ls byte
	btfss	STATUS,C	; if negative then decrease MS value
	decf	STORE1,f
	btfss	STORE1,7	; if set then greater
	goto	SET_SPARK
SUBTRACTED
	movf	TIMERH,w	; timer value for coil on again
	movwf	CCPR1H		; compare ms byte
	movf	TIMERL,w
	movwf	CCPR1L		; compare ls byte
	goto	RECLAIM

SET_SPARK


	movf	SPARK_DURH,w; spark duration high byte
	movwf	CCPR1H		; ms byte of compare timer
	movf	SPARK_DURL,w; minimum value
	movwf	CCPR1L		; ls byte of compare


RECLAIM
	bcf		STATUS,RP0	; select memory bank 0
; add delay for debounce
	movf	DEBOUNCE,w	; gives debounce period
	movwf	DELAY_COUNT1	; initial values
LOOP2
	movlw	D'40'
	movwf	DELAY_COUNT2
LOOP1	
	nop
	decfsz	DELAY_COUNT2,f	; reduce
	goto	LOOP1
	decfsz	DELAY_COUNT1,f
	goto	LOOP2

	bcf		INTCON,INTF ; clear interrupt edge flag 

; end of interrupt reclaim w and status 
;	movf	PCLATH_STO,w; restore PCLATH
;	movwf	PCLATH
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

; xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

; Subroutines

; subroutine to wait for conversion

ACQUIRE_AD
; wait for >20us
	movlw	D'24'
	movwf	CONVERSION
LOOP_CONV
	decfsz	CONVERSION,f	; decrease 
	goto	LOOP_CONV	
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return


; XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

POINTS_MODE

; Initially set coil off 

	bcf		PORTB,3		; coil off
	clrf	CCP1CON		; clear capture/compare
; setup interrupt edge

	btfsc	PORTB,2		; if high invert
	goto	L_INT5		; set high going edge
	bsf		STATUS,RP0	; select memory bank 1
	bcf		OPTION_REG,INTEDG	; low going interrupt edge
	goto	BY_L_INT5
L_INT5
	bsf		STATUS,RP0	; select memory bank 1		
	bsf		OPTION_REG,INTEDG	; high going interrupt edge
BY_L_INT5		
	bcf		STATUS,RP0	; select memory bank 0

; allow interrupts

	bcf		INTCON,INTF ; clear interrupt edge flag 
	bsf		INTCON,INTE	; interrupt level at RB0
;	bsf		STATUS,RP0	; select memory bank 1	
;	bsf		PIE1, TMR1IF; set overflow interrupt	
;	bcf		STATUS,RP0	; select memory bank 0
		 
	bsf		INTCON,GIE	; set global interrupt enable 

BACKGROUND1
	btfsc	PORTB,5		; check follow mode
	goto	CK_POINTS
; timeout for coil to go off after 1 or 10s if no interrupts of ignition firing
	btfsc	OVFLOW_FLG,0	; if set already timed out
	goto	A_D1
	incfsz	TIMER_COUNT1,f	; ls byte next count
	goto	A_D1
	incfsz	TIMER_COUNT2,f	; ms byte
	goto	A_D1
	movlw	H'00'
	movwf	CCP1CON		; reset compare mode
	bcf		PORTB,3		; coil off
	bsf		OVFLOW_FLG,0

; A/D conversion
A_D1
; debounce for 167us-5ms in 30 steps/ 167us / step 
; check debounce setting
; Channel 2 A/D value debounce VR2
; set A/D to channel 2
	movlw	B'01010001'	; Fosc, channel,2 etc
	movwf	ADCON0
	call	ACQUIRE_AD
; divide by 8
	bcf		STATUS,C
	rrf		ADRESH,f	;
	bcf		STATUS,C
	rrf		ADRESH,f
	bcf		STATUS,C
	rrf		ADRESH,w
	movwf	DEBOUNCE	; keep value
; remove first 2 digits to counteract non linearity of trim pot at lower end	
	movlw	D'2'
	subwf	DEBOUNCE,w
	btfss	STATUS,C
	clrw				; if negative set at 0
	addlw	D'1'
	movwf	DEBOUNCE	; ensure it is 1 or more

	goto	BACKGROUND1
	

	
; INTERRUPT for points mode

; start interrupt by saving w and status registers 
	
INTERRUPT_POINTS
	
; INTERRUPT

; start interrupt by saving w and status registers 
	
	
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	bcf		STATUS,RP0	; select memory bank 0
FOLLOW1
; check interrupt source
; on edge interrupt:

; reverse interrupt edge

	bsf		STATUS,RP0	; select memory bank 1
	btfss	OPTION_REG,INTEDG	; check edge
	goto	SET_EDGES4
	bcf		OPTION_REG,INTEDG	; opposite edge
	bcf		STATUS,RP0
	bcf		PORTB,4
; output
	btfsc	PORTB,2		; level invert or non-invert
	goto	OUT1
	bsf		PORTB,3
	bsf		FIRE_FLG,0
	goto	RECLAIM_FOLLOW
OUT1
	bcf		PORTB,3	
	bcf		FIRE_FLG,0	
	goto	RECLAIM_FOLLOW	
	
SET_EDGES4
	bsf		OPTION_REG,INTEDG	; set 
	bcf		STATUS,RP0	; 
	bsf		PORTB,4
; output
	btfsc	PORTB,2
	goto	OUT2
	bcf		PORTB,3
	bcf		FIRE_FLG,0
	goto	RECLAIM_FOLLOW
OUT2
	bsf		PORTB,3
	bsf		FIRE_FLG,0	

RECLAIM_FOLLOW
	
; add delay for debounce
	movf	DEBOUNCE,w	; gives debounce period
	movwf	DELAY_COUNT1	; initial values
LOOP4
	movlw	D'40'
	movwf	DELAY_COUNT2
LOOP3	
	nop
	decfsz	DELAY_COUNT2,f	; reduce
	goto	LOOP3
	decfsz	DELAY_COUNT1,f
	goto	LOOP4

	bcf		INTCON,INTF ; clear interrupt edge flag 
	bcf		OVFLOW_FLG,0
	bcf		TIMER_OVR,0	; overflow flag cleared
; clear timeout counters

	clrf	TIMER_COUNT1	; timeout counter
; use 1s for debounce less than 2ms 10s for >2ms so single cylinder slow motors can be started with kick starter
	movf	DEBOUNCE,w
	sublw	D'12'			; check debounce value
	movlw	D'0'			; setup for 10s timeout
	btfsc	STATUS,C
	movlw	D'229'			; use shorter timeout (1s) for <2ms debounce
	movwf	TIMER_COUNT2

; end of interrupt reclaim w and status 

	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt



	end
