//Tim Blythman
#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
extern volatile unsigned char C;            //generic counter
extern volatile unsigned char DELCTR;       // used by DELAYBYW
extern volatile unsigned char FLAGS;        // bit0=ball, 1 =P1, 2=P2, 3=scores
extern volatile unsigned char NUMPAR;       // use by score display, bits 0-2 = line number, bits 3-6=number to display
extern volatile unsigned char P1SCORE;      //
extern volatile unsigned char P2SCORE;      //
extern volatile unsigned char P1BAT;        // Y pos
extern volatile unsigned char P2BAT;        // Y pos
extern volatile unsigned char LINENO;       // current display line number

extern volatile unsigned char BALLX;        //
extern volatile unsigned char BALLY;        //
extern volatile signed char BALLU;          //
extern volatile signed char BALLV;          //
extern volatile unsigned char GAMEPHASE;    // 0=normal,1=1 to serve,2=2 to serve,3 = finished,1 won, 4=finished, 2 won
extern volatile unsigned char HITCOUNT;     // to set speed/difficulty
extern volatile unsigned char SOUND;        // sound to play
extern volatile unsigned char FIELDCOUNT;   // for animation timing

//extern volatile unsigned char TEST;

void ioinit(void);
void assem(void);

//macros:
#define SETLUM asm("BSF PORTA, 0x5");
#define CLEARLUM asm("BCF PORTA, 0x5");
//DELAYBW sub takes 4 cycles to call/set up, and takes 4 cycles if DELCTR=1; ie minimum is 8 asm("NOP");
#define NOPS_004 asm("NOP");asm("NOP");asm("NOP");asm("NOP");
#define NOPS_005 asm("NOP");asm("NOP");asm("NOP");asm("NOP");asm("NOP");
#define NOPS_009 asm("MOVLW 1");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");asm("NOP");
#define NOPS_010 asm("MOVLW 1");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");asm("NOP");asm("NOP");
#define NOPS_014 asm("MOVLW 3");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");
#define NOPS_015 asm("MOVLW 3");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");asm("NOP");
#define NOPS_019 asm("MOVLW 4");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");asm("NOP");asm("NOP");
#define NOPS_020 asm("MOVLW 5");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");
#define NOPS_024 asm("MOVLW 6");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");asm("NOP");
#define NOPS_026 asm("MOVLW 7");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");

#define VSYNC asm("CALL VSYNCLINE");asm("CALL VSYNCLINE");asm("CALL VSYNCLINE");asm("CALL VSYNCLINE");asm("CALL VSYNCLINE");asm("CALL VSYNCLINE");
#define BLANK10 asm("CALL BLANKLINE");asm("CALL BLANKLINE");asm("CALL BLANKLINE");asm("CALL BLANKLINE");asm("CALL BLANKLINE");asm("CALL BLANKLINE");asm("CALL BLANKLINE");asm("CALL BLANKLINE");asm("CALL BLANKLINE");asm("CALL BLANKLINE");

#define SPC asm("GOTO BITMAP00");
//S
#define S_1 asm("GOTO BITMAP14");
#define S_2 asm("GOTO BITMAP17");
#define S_3 asm("GOTO BITMAP01");
#define S_4 asm("GOTO BITMAP14");
#define S_5 asm("GOTO BITMAP16");
#define S_6 asm("GOTO BITMAP17");
#define S_7 asm("GOTO BITMAP14");
//I
#define I_1 asm("GOTO BITMAP14");
#define I_2 asm("GOTO BITMAP04");
#define I_3 asm("GOTO BITMAP04");
#define I_4 asm("GOTO BITMAP04");
#define I_5 asm("GOTO BITMAP04");
#define I_6 asm("GOTO BITMAP04");
#define I_7 asm("GOTO BITMAP14");
//L
#define L_1 asm("GOTO BITMAP01");
#define L_2 asm("GOTO BITMAP01");
#define L_3 asm("GOTO BITMAP01");
#define L_4 asm("GOTO BITMAP01");
#define L_5 asm("GOTO BITMAP01");
#define L_6 asm("GOTO BITMAP01");
#define L_7 asm("GOTO BITMAP31");
//C
#define C_1 asm("GOTO BITMAP14");
#define C_2 asm("GOTO BITMAP17");
#define C_3 asm("GOTO BITMAP01");
#define C_4 asm("GOTO BITMAP01");
#define C_5 asm("GOTO BITMAP01");
#define C_6 asm("GOTO BITMAP17");
#define C_7 asm("GOTO BITMAP14");
//N
#define N_1 asm("GOTO BITMAP17");
#define N_2 asm("GOTO BITMAP19");
#define N_3 asm("GOTO BITMAP21");
#define N_4 asm("GOTO BITMAP21");
#define N_5 asm("GOTO BITMAP25");
#define N_6 asm("GOTO BITMAP17");
#define N_7 asm("GOTO BITMAP17");
//H
#define H_1 asm("GOTO BITMAP17");
#define H_2 asm("GOTO BITMAP17");
#define H_3 asm("GOTO BITMAP17");
#define H_4 asm("GOTO BITMAP31");
#define H_5 asm("GOTO BITMAP17");
#define H_6 asm("GOTO BITMAP17");
#define H_7 asm("GOTO BITMAP17");
//P
#define P_1 asm("GOTO BITMAP15");
#define P_2 asm("GOTO BITMAP17");
#define P_3 asm("GOTO BITMAP17");
#define P_4 asm("GOTO BITMAP15");
#define P_5 asm("GOTO BITMAP01");
#define P_6 asm("GOTO BITMAP01");
#define P_7 asm("GOTO BITMAP01");
//O
#define O_1 asm("GOTO BITMAP14");
#define O_2 asm("GOTO BITMAP17");
#define O_3 asm("GOTO BITMAP17");
#define O_4 asm("GOTO BITMAP17");
#define O_5 asm("GOTO BITMAP17");
#define O_6 asm("GOTO BITMAP17");
#define O_7 asm("GOTO BITMAP14");
//A
#define A_1 asm("GOTO BITMAP14");
#define A_2 asm("GOTO BITMAP17");
#define A_3 asm("GOTO BITMAP17");
#define A_4 asm("GOTO BITMAP17");
#define A_5 asm("GOTO BITMAP31");
#define A_6 asm("GOTO BITMAP17");
#define A_7 asm("GOTO BITMAP17");
//G
#define G_1 asm("GOTO BITMAP14");
#define G_2 asm("GOTO BITMAP17");
#define G_3 asm("GOTO BITMAP01");
#define G_4 asm("GOTO BITMAP29");
#define G_5 asm("GOTO BITMAP17");
#define G_6 asm("GOTO BITMAP17");
#define G_7 asm("GOTO BITMAP14");
//more defs
#define BM_00 asm("GOTO BITMAP00");
#define BM_01 asm("GOTO BITMAP01");
#define BM_02 asm("GOTO BITMAP02");
#define BM_03 asm("GOTO BITMAP03");
#define BM_04 asm("GOTO BITMAP04");
#define BM_05 asm("GOTO BITMAP05");
#define BM_06 asm("GOTO BITMAP06");
#define BM_07 asm("GOTO BITMAP07");
#define BM_08 asm("GOTO BITMAP08");
#define BM_09 asm("GOTO BITMAP09");
#define BM_10 asm("GOTO BITMAP10");
#define BM_11 asm("GOTO BITMAP11");
#define BM_12 asm("GOTO BITMAP12");
#define BM_13 asm("GOTO BITMAP13");
#define BM_14 asm("GOTO BITMAP14");
#define BM_15 asm("GOTO BITMAP15");
#define BM_16 asm("GOTO BITMAP16");
#define BM_17 asm("GOTO BITMAP17");
#define BM_18 asm("GOTO BITMAP18");
#define BM_19 asm("GOTO BITMAP19");
#define BM_20 asm("GOTO BITMAP20");
#define BM_21 asm("GOTO BITMAP21");
#define BM_22 asm("GOTO BITMAP22");
#define BM_23 asm("GOTO BITMAP23");
#define BM_24 asm("GOTO BITMAP24");
#define BM_25 asm("GOTO BITMAP25");
#define BM_26 asm("GOTO BITMAP26");
#define BM_27 asm("GOTO BITMAP27");
#define BM_28 asm("GOTO BITMAP28");
#define BM_29 asm("GOTO BITMAP29");
#define BM_30 asm("GOTO BITMAP30");
#define BM_31 asm("GOTO BITMAP31");




#endif	/* IO_H */

