#include "config.h"
#include <xc.h>
#include "io.h"

//up to 16 bytes fit in common ram (0x70-0x7F, but 7E,7D used by compiler)
//up to 80 bytes fit into zero page ram (0x20-0x6F)
//near to be on shared memory (any bank)
volatile unsigned char C           __at(0x70);  //generic counter
volatile unsigned char DELCTR      __at(0x71);  // used by DELAYBYW
volatile unsigned char FLAGS       __at(0x72);  // bit0=ball, 1 =P1, 2=P2, 3=scores
volatile unsigned char NUMPAR      __at(0x73);  // use by score display, bits 0-2 = line number, bits 3-6=number to display
volatile unsigned char P1SCORE     __at(0x74);  //
volatile unsigned char P2SCORE     __at(0x75);  //
volatile unsigned char P1BAT       __at(0x76);  // Y pos
volatile unsigned char P2BAT       __at(0x77);  // Y pos
volatile unsigned char LINENO      __at(0x78);  // current display line number
volatile unsigned char BALLX       __at(0x79);  // horiz pos
volatile unsigned char BALLY       __at(0x7A);  // vert pos
volatile signed char BALLU         __at(0x7B);  // horiz speed
volatile signed char BALLV         __at(0x7C);  // vert speed
volatile unsigned char GAMEPHASE   __at(0x7D);  //bitmap 76543210
//GAMEPHASE bit7=P2 to serve, bit6=P1 to serve, bit0=rally in progress, one hot, also bit5 = P2 has won, bit4=P1 has won

volatile unsigned char HITCOUNT    __at(0x2E);  // to set speed/difficulty
volatile unsigned char SOUND       __at(0x2F);  // sound to play
volatile unsigned char FIELDCOUNT  __at(0x30);  // for animation timing
volatile unsigned char P1RAW       __at(0x31);  // P1 ADC raw (8bit)
volatile unsigned char P2RAW       __at(0x32);  // P2 ADC raw (8bit)

//volatile unsigned char c @ 0x7D;                   //this syntax for XC v1.45

void main(void) {
    unsigned char i;
    OSCCONbits.IRCF=0b1110; //use 8MHz HFINTOSC (=>32MHz if PLLEN is on)
    ioinit();
    C=0;
    P1SCORE=0;
    P2SCORE=0;
    P1BAT=128;
    P2BAT=128;
    P1RAW=128;
    P2RAW=128;
    BALLX=90;
    BALLY=100;
    BALLU=0;
    BALLV=0;
    GAMEPHASE=0x40; //P1 to serve
    HITCOUNT=0;
    FIELDCOUNT=0;
    SOUND=0;
    LINENO=0;
    assem();        //our assembly routine that does the hard stuff (and runs forever)
    while(1){   }
    return;
}
