//Tim Blythman
#include "io.h"

void ioinit(void){
    ANSELA=0;       //no analog yet    
    TRISAbits.TRISA5=0; //lum
    TRISAbits.TRISA4=0; //sync
    //black level
    RA5=0;
    RA4=1;
 
    //set up PWM1 on RA5 (alt) for ball output, standard mode, period is 64us/512 processor cycles/2048 FOSC cycles
    //ball position=phase, ball width = DC-phase, can be set per frame
    PWM1CON=0;              //reset, std mode, active high, output off
    PWM1CLKCONbits.CS=0;    //FOSC
    PWM1CLKCONbits.PS=3;    //PS/8
    PWM1OFCON=0;            //independent, no offset
    PWM1PR= 255;
    PWM1TMR=0;  //reset counter
    PWM1PH=0;   //reset
    PWM1DC=0;   //reset
    APFCONbits.P1SEL=1; //PWM1 on RA5

    TRISAbits.TRISA2=0; //audio
    //set up PWM3 on RA2 for audio, standard mode
    PWM3CON=0;              //reset, std mode, active high, output off
    PWM3CLKCONbits.CS=0;    //FOSC
    PWM3CLKCONbits.PS=2;    //PS/4
    PWM3OFCON=0;            //independent, no offset
    PWM3PRL=0;
    PWM3PRH=60;             //any value at or below DCH will give silence
    PWM3TMR=0;  //reset counter
    PWM3PH=0;   //reset
    PWM3DCL=0;   //reset
    PWM3DCH=20;   //set below PR of highest required note
    PWM3CONbits.OE=1;
    //PWM3CONbits.EN=1;   //run
    //these settings give (value placed in PRH)
//  C3 238// D3 212//  E3 189//  F3 178//  G3 159//  A3 142//  B3 126
//  C4 119//  D4 106//  E4 94//  F4 89//  G4 79//  A4 71//  B4 63
//  C5 59//  D5 53//  E5 47//  F5 44//  G5 39//  A5 35//  B5 31
//  C6 29//  D6 26

    TRISAbits.TRISA1=1; //Player 2 ADC on RA1
    ANSELAbits.ANSA1=1; //RA1
    TRISAbits.TRISA0=1; //Player 1 ADC on RA0
    ANSELAbits.ANSA0=1; //RA0
    ADCON0=0;           //ADC reset
    ADCON0bits.CHS=0;   //AN1=RA1, AN0=RA0
    ADCON1bits.ADFM=0;  //Left justify (using 8 MSB in ADRESH only)
    //ADCON1bits.ADCS=2;  //FOSC/32=> 1us   (appears to be too fast)
    ADCON1bits.ADCS=3;  //FRC
    //ADCON1bits.ADCS=6;  //FOSC/64=2us
    ADCON1bits.ADPREF=0;//VDD = VREF+
    ADCON2=0;           //no trigger
    ADCON0bits.ADON=1;  //on and ready
    ADCON0bits.ADGO=1;  //start
}

void assem(void){
asm("MOVLB 0");          //back to bank 0
//asm("GOTO SCREENLOOP");
asm("SPLASHLOOP:");
VSYNC;  ///6lines
BLANK10;BLANK10;BLANK10;BLANK10;BLANK10;    //+50 lines
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");//+35
BLANK10;
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");//+35
BLANK10;
BLANK10;
BLANK10;
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE"); //<same as following
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE"); //<same as following
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");//+35
BLANK10;
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE"); //<same as following
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");
asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE");asm("CALL GLINE2");//+35

BLANK10;BLANK10;    //+20 lines
BLANK10;BLANK10;BLANK10;BLANK10;BLANK10;    //+50 lines
asm("CALL BLANKLINE");
asm("CALL BLANKLINE");
asm("CLRF _C,F");
asm("DECFSZ _FIELDCOUNT,F");
asm("GOTO SPLASHLOOP");

//each line routine needs to use 510 cycles (+2cycles for call=512=64us)
asm("SCREENLOOP:");
asm("CALL VSYNCLINE");   //1,2  //line 1
asm("CALL VSYNCLINE");   //1,2
asm("CALL VSYNCLINE");   //1,2
asm("CALL VSYNCLINE");   //1,2
asm("CALL VSYNCLINE");   //1,2
asm("CALL VSYNCLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2  //line xx0
asm("CALL BLANKLINE");   //1,2  //line xx1
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2  //line xx0
asm("CALL BLANKLINE");   //1,2  //line xx1
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2  //line xx0
asm("CALL BLANKLINE");   //1,2  //line xx1
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BATLINE");//35, active video line:0
asm("CALL BATLINE");//36, active video line:1
asm("CALL BATLINE");//37, active video line:2
asm("CALL BATLINE");//38, active video line:3
asm("CALL BATLINE");//39, active video line:4
asm("CALL BATLINE");//40, active video line:5
asm("CALL BATLINE");//41, active video line:6
asm("CALL BATLINE");//42, active video line:7
asm("CALL BATLINE");//43, active video line:8
asm("CALL BATLINE");//44, active video line:9
asm("CALL BATLINE");//45, active video line:10
asm("CALL BATLINE");//46, active video line:11
asm("CALL BATLINE");//47, active video line:12
asm("CALL BATLINE");//48, active video line:13
asm("CALL BATLINE");//49, active video line:14
asm("CALL BATLINE");//50, active video line:15
asm("CALL BATLINE");//51, active video line:16
asm("CALL BATLINE");//52, active video line:17
asm("CALL BATLINE");//53, active video line:18
asm("CALL BATLINE");//54, active video line:19
asm("CALL BATLINE");//55, active video line:20
asm("CALL BATLINE");//56, active video line:21
asm("CALL BATLINE");//57, active video line:22
asm("CALL BATLINE");//58, active video line:23
asm("CALL BATLINE");//59, active video line:24
asm("CALL BATLINE");//60, active video line:25
asm("CALL BATLINE");//61, active video line:26
asm("CALL BATLINE");//62, active video line:27
asm("CALL BATLINE");//63, active video line:28
asm("CALL BATLINE");//64, active video line:29
asm("CALL BATLINE");//65, active video line:30
asm("CALL BATLINE");//66, active video line:31
asm("CALL BATLINE");//67, active video line:32
asm("CALL BATLINE");//68, active video line:33
asm("CALL BATLINE");//69, active video line:34
asm("CALL BATLINE");//70, active video line:35
asm("CALL BATLINE");//71, active video line:36
asm("CALL BATLINE");//72, active video line:37
asm("CALL BATLINE");//73, active video line:38
asm("CALL BATLINE");//74, active video line:39
asm("CALL BATLINE");//75, active video line:40
asm("CALL BATLINE");//76, active video line:41
asm("CALL BATLINE");//77, active video line:42
asm("CALL BATLINE");//78, active video line:43
asm("CALL BATLINE");//79, active video line:44
asm("CALL BATLINE");//80, active video line:45
asm("CALL BATLINE");//81, active video line:46
asm("CALL BATLINE");//82, active video line:47
asm("CALL BATLINE");//83, active video line:48
asm("CALL BATLINE");//84, active video line:49
asm("CALL BATLINE");//85, active video line:50
asm("CALL BATLINE");//86, active video line:51
asm("CALL BATLINE");//87, active video line:52
asm("CALL BATLINE");//88, active video line:53
asm("CALL BATLINE");//89, active video line:54
asm("CALL BATLINE");//90, active video line:55
asm("CALL BATLINE");//91, active video line:56
asm("CALL BATLINE");//92, active video line:57
asm("CALL BATLINE");//93, active video line:58
asm("CALL BATLINE");//94, active video line:59
asm("CALL BATLINE");//95, active video line:60
asm("CALL BATLINE");//96, active video line:61
asm("CALL BATLINE");//97, active video line:62
asm("CALL BATLINE");//98, active video line:63
asm("CALL BATLINE");//99, active video line:64
asm("CALL BATLINE");//100, active video line:65
asm("CALL BATLINE");//101, active video line:66
asm("CALL BATLINE");//102, active video line:67
asm("CALL BATLINE");//103, active video line:68
asm("CALL BATLINE");//104, active video line:69
asm("CALL BATLINE");//105, active video line:70
asm("CALL BATLINE");//106, active video line:71
asm("CALL BATLINE");//107, active video line:72
asm("CALL BATLINE");//108, active video line:73
asm("CALL BATLINE");//109, active video line:74
asm("CALL BATLINE");//110, active video line:75
asm("CALL BATLINE");//111, active video line:76
asm("CALL BATLINE");//112, active video line:77
asm("CALL BATLINE");//113, active video line:78
asm("CALL BATLINE");//114, active video line:79
asm("CALL BATLINE");//115, active video line:80
asm("CALL BATLINE");//116, active video line:81
asm("CALL BATLINE");//117, active video line:82
asm("CALL BATLINE");//118, active video line:83
asm("CALL BATLINE");//119, active video line:84
asm("CALL BATLINE");//120, active video line:85
asm("CALL BATLINE");//121, active video line:86
asm("CALL BATLINE");//122, active video line:87
asm("CALL BATLINE");//123, active video line:88
asm("CALL BATLINE");//124, active video line:89
asm("CALL BATLINE");//125, active video line:90
asm("CALL BATLINE");//126, active video line:91
asm("CALL BATLINE");//127, active video line:92
asm("CALL BATLINE");//128, active video line:93
asm("CALL BATLINE");//129, active video line:94
asm("CALL BATLINE");//130, active video line:95
asm("CALL BATLINE");//131, active video line:96
asm("CALL BATLINE");//132, active video line:97
asm("CALL BATLINE");//133, active video line:98
asm("CALL BATLINE");//134, active video line:99
asm("CALL BATLINE");//135, active video line:100
asm("CALL BATLINE");//136, active video line:101
asm("CALL BATLINE");//137, active video line:102
asm("CALL BATLINE");//138, active video line:103
asm("CALL BATLINE");//139, active video line:104
asm("CALL BATLINE");//140, active video line:105
asm("CALL BATLINE");//141, active video line:106
asm("CALL BATLINE");//142, active video line:107
asm("CALL BATLINE");//143, active video line:108
asm("CALL BATLINE");//144, active video line:109
asm("CALL BATLINE");//145, active video line:110
asm("CALL BATLINE");//146, active video line:111
asm("CALL BATLINE");//147, active video line:112
asm("CALL BATLINE");//148, active video line:113
asm("CALL BATLINE");//149, active video line:114
asm("CALL BATLINE");//150, active video line:115
asm("CALL BATLINE");//151, active video line:116
asm("CALL BATLINE");//152, active video line:117
asm("CALL BATLINE");//153, active video line:118
asm("CALL BATLINE");//154, active video line:119
asm("CALL BATLINE");//155, active video line:120
asm("CALL BATLINE");//156, active video line:121
asm("CALL BATLINE");//157, active video line:122
asm("CALL BATLINE");//158, active video line:123
asm("CALL BATLINE");//159, active video line:124
asm("CALL BATLINE");//160, active video line:125
asm("CALL BATLINE");//161, active video line:126
asm("CALL BATLINE");//162, active video line:127
asm("CALL BATLINE");//163, active video line:128
asm("CALL BATLINE");//164, active video line:129
asm("CALL BATLINE");//165, active video line:130
asm("CALL BATLINE");//166, active video line:131
asm("CALL BATLINE");//167, active video line:132
asm("CALL BATLINE");//168, active video line:133
asm("CALL BATLINE");//169, active video line:134
asm("CALL BATLINE");//170, active video line:135
asm("CALL BATLINE");//171, active video line:136
asm("CALL BATLINE");//172, active video line:137
asm("CALL BATLINE");//173, active video line:138
asm("CALL BATLINE");//174, active video line:139
asm("CALL BATLINE");//175, active video line:140
asm("CALL BATLINE");//176, active video line:141
asm("CALL BATLINE");//177, active video line:142
asm("CALL BATLINE");//178, active video line:143
asm("CALL BATLINE");//179, active video line:144
asm("CALL BATLINE");//180, active video line:145
asm("CALL BATLINE");//181, active video line:146
asm("CALL BATLINE");//182, active video line:147
asm("CALL BATLINE");//183, active video line:148
asm("CALL BATLINE");//184, active video line:149
asm("CALL BATLINE");//185, active video line:150
asm("CALL BATLINE");//186, active video line:151
asm("CALL BATLINE");//187, active video line:152
asm("CALL BATLINE");//188, active video line:153
asm("CALL BATLINE");//189, active video line:154
asm("CALL BATLINE");//190, active video line:155
asm("CALL BATLINE");//191, active video line:156
asm("CALL BATLINE");//192, active video line:157
asm("CALL BATLINE");//193, active video line:158
asm("CALL BATLINE");//194, active video line:159
asm("CALL BATLINE");//195, active video line:160
asm("CALL BATLINE");//196, active video line:161
asm("CALL BATLINE");//197, active video line:162
asm("CALL BATLINE");//198, active video line:163
asm("CALL BATLINE");//199, active video line:164
asm("CALL BATLINE");//200, active video line:165
asm("CALL BATLINE");//201, active video line:166
asm("CALL BATLINE");//202, active video line:167
asm("CALL BATLINE");//203, active video line:168
asm("CALL BATLINE");//204, active video line:169
asm("CALL BATLINE");//205, active video line:170
asm("CALL BATLINE");//206, active video line:171
asm("CALL BATLINE");//207, active video line:172
asm("CALL BATLINE");//208, active video line:173
asm("CALL BATLINE");//209, active video line:174
asm("CALL BATLINE");//210, active video line:175
asm("CALL BATLINE");//211, active video line:176
asm("CALL BATLINE");//212, active video line:177
asm("CALL BATLINE");//213, active video line:178
asm("CALL BATLINE");//214, active video line:179
asm("CALL BATLINE");//215, active video line:180
asm("CALL BATLINE");//216, active video line:181
asm("CALL BATLINE");//217, active video line:182
asm("CALL BATLINE");//218, active video line:183
asm("CALL BATLINE");//219, active video line:184
asm("CALL BATLINE");//220, active video line:185
asm("CALL BATLINE");//221, active video line:186
asm("CALL BATLINE");//222, active video line:187
asm("CALL BATLINE");//223, active video line:188
asm("CALL BATLINE");//224, active video line:189
asm("CALL BATLINE");//225, active video line:190
asm("CALL BATLINE");//226, active video line:191
asm("CALL BATLINE");//227, active video line:192
asm("CALL BATLINE");//228, active video line:193
asm("CALL BATLINE");//229, active video line:194
asm("CALL BATLINE");//230, active video line:195
asm("CALL BATLINE");//231, active video line:196
asm("CALL BATLINE");//232, active video line:197
asm("CALL BATLINE");//233, active video line:198
asm("CALL BATLINE");//234, active video line:199
asm("CALL BATLINE");//235, active video line:200
asm("CALL BATLINE");//236, active video line:201
asm("CALL BATLINE");//237, active video line:202
asm("CALL BATLINE");//238, active video line:203
asm("CALL BATLINE");//239, active video line:204
asm("CALL BATLINE");//240, active video line:205
asm("CALL BATLINE");//241, active video line:206
asm("CALL BATLINE");//242, active video line:207
asm("CALL BATLINE");//243, active video line:208
asm("CALL BATLINE");//244, active video line:209
asm("CALL BATLINE");//245, active video line:210
asm("CALL BATLINE");//246, active video line:211
asm("CALL BATLINE");//247, active video line:212
asm("CALL BATLINE");//248, active video line:213
asm("CALL BATLINE");//249, active video line:214
asm("CALL BATLINE");//250, active video line:215
asm("CALL BATLINE");//251, active video line:216
asm("CALL BATLINE");//252, active video line:217
asm("CALL BATLINE");//253, active video line:218
asm("CALL BATLINE");//254, active video line:219
asm("CALL BATLINE");//255, active video line:220
asm("CALL BATLINE");//256, active video line:221
asm("CALL BATLINE");//257, active video line:222
asm("CALL BATLINE");//258, active video line:223
asm("CALL BATLINE");//259, active video line:224
asm("CALL BATLINE");//260, active video line:225
asm("CALL BATLINE");//261, active video line:226
asm("CALL BATLINE");//262, active video line:227
asm("CALL BATLINE");//263, active video line:228
asm("CALL BATLINE");//264, active video line:229
asm("CALL BATLINE");//265, active video line:230
asm("CALL BATLINE");//266, active video line:231
asm("CALL BATLINE");//267, active video line:232
asm("CALL BATLINE");//268, active video line:233
asm("CALL BATLINE");//269, active video line:234
asm("CALL BATLINE");//270, active video line:235
asm("CALL BATLINE");//271, active video line:236
asm("CALL BATLINE");//272, active video line:237
asm("CALL BATLINE");//273, active video line:238
asm("CALL BATLINE");//274, active video line:239
asm("CALL BATLINE");//275, active video line:240
asm("CALL BATLINE");//276, active video line:241
asm("CALL BATLINE");//277, active video line:242
asm("CALL BATLINE");//278, active video line:243
asm("CALL BATLINE");//279, active video line:244
asm("CALL BATLINE");//280, active video line:245
asm("CALL BATLINE");//281, active video line:246
asm("CALL BATLINE");//282, active video line:247
asm("CALL BATLINE");//283, active video line:248
asm("CALL BATLINE");//284, active video line:249
asm("CALL BATLINE");//285, active video line:250
asm("CALL BATLINE");//286, active video line:251
asm("CALL BATLINE");//287, active video line:252
asm("CALL BATLINE");//288, active video line:253
asm("CALL BATLINE");//289, active video line:254
asm("CALL BATLINE");//290, active video line:255
asm("CALL BLANKLINE");   //1,2  //line xx1
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2  //line xx0
asm("CALL BLANKLINE");   //1,2  //line xx1
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2
asm("CALL BLANKLINE");   //1,2  //line xx0
asm("CALL BLANKLINE");   //1,2  //line xx1
asm("CALL BLANKLINE2");   //1,2 //line 312, this line is shorter to cater for goto
asm("GOTO SCREENLOOP;");     //loop

//delay routine, costs 3 * _DELCTR +1 clocks
asm("DELAYBYW:");
asm("DECFSZ _DELCTR,F");   //1
asm("GOTO DELAYBYW;");     //2,3 loop
asm("RETURN");             //3,4    if _DELCTR=1, otherwise add *3

//draws a blank line with sync only
asm("BLANKLINE:");
asm("BCF PORTA, 0x4");  //1
asm("MOVLW 0x0B");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //2,3,4,5 + 34 =>39 sync low
asm("BSF PORTA, 0x4");  //40
asm("MOVLW 0x9A");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //41,42,43,44+ 463 => 507
asm("NOP");                //508
asm("RETURN");             //509,510

//draws blank line with sync, allows per field housekeeping/screen updates
//end is -2 opcodes to allow goto loop to top of field
asm("BLANKLINE2:");     
asm("BCF PORTA, 0x4");  //1
asm("INCF _FIELDCOUNT,F");  //count up              //2
asm("MOVF _FIELDCOUNT,W");  //also store in W       //3
asm("MOVLB 0x1");           //ADC bank              //4
asm("MOVWF _C");            //move to common RAM    //5
//get ADC value and set for next cycle
asm("BTFSS _C,0");                                  //6
asm("BCF ADCON0,2");        //set channel= LSB of FIELDCOUNT
asm("BTFSC _C,0");                                  //8
asm("BSF ADCON0,2");        //set channel= LSB of FIELDCOUNT
asm("MOVF ADRESH,W");       //get last value        //10
asm("BSF ADCON0,1");        //go for next cycle     //11
asm("MOVLB 0x0");           //home bank             //12
asm("BTFSS _FIELDCOUNT,0");                         //13
asm("MOVWF _P1RAW");        //save P1               //14
asm("BTFSC _FIELDCOUNT,0");                         //15
asm("MOVWF _P2RAW");        //save P2               //16
//test and save P1 bat
asm("MOVF _P1RAW,W");                               //17
asm("ADDLW 0x40");          //range adjust
asm("MOVWF _C");            //store
asm("LSLF _C,W");           //double
asm("BTFSC _C,7");          //test if in range
asm("MOVWF _P1BAT");        //save adjusted         //22
//test and save P2 bat
asm("MOVF _P2RAW,W");                               //23
asm("ADDLW 0x40");          //range adjust
asm("MOVWF _C");            //store
asm("LSLF _C,W");           //double
asm("BTFSC _C,7");          //test if in range
asm("MOVWF _P2BAT");        //save adjusted         //28
//sync pulse end
asm("NOP");                                         //29
asm("MOVLW 0x02");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //29-32 + 7 =>39 sync low
asm("BSF PORTA, 0x4");      //40
//clear flags to avoid smear on wraparound
asm("BCF _FLAGS,0");       //41    //avoid smearing from top of screen
asm("BCF _FLAGS,1");       //42
asm("BCF _FLAGS,2");       //43
asm("CLRF _LINENO");       //44, clear line count
//check if we need to reset score on game start
asm("CLRF _C");            //clear flag                 //45
asm("BTFSC _GAMEPHASE,5"); //bit 5 set                  //46
asm("BSF _C,0");           //set flag
asm("BTFSC _GAMEPHASE,4"); //or bit 4 set
asm("BSF _C,0");           //set flag
asm("BTFSS _GAMEPHASE,0"); //and rally start
asm("BCF _C,0");           //clear flag
asm("BTFSC _GAMEPHASE,6"); //and not P1 to serve
asm("BCF _C,0");           //clear flag
asm("BTFSC _GAMEPHASE,7"); //and not P2 to serve
asm("BCF _C,0");           //clear flag
asm("BTFSC _C,0");         //check flag
asm("CLRF _P1SCORE");      //clear score
asm("BTFSC _C,0");         //check flag
asm("CLRF _P2SCORE");      //clear score
asm("MOVLW 0x01");         //rally state
asm("BTFSC _C,0");         //check flag
asm("MOVWF _GAMEPHASE");   //clear game over flags      //62
//game phase
//bit 0 set, normal, nothing special needs to happen
//check scores to see if win has occurred
//if P2 score, P2 has won
asm("MOVF _P2SCORE,W");                                 //63
asm("ADDLW 0xF5");
asm("BTFSC STATUS,0");     //if carry
asm("BSF _GAMEPHASE,5");   //P2 has won                 //66
//if P1 score, P1 has won
asm("MOVF _P1SCORE,W");                                 //67
asm("ADDLW 0xF5");
asm("BTFSC STATUS,0");     //if carry
asm("BSF _GAMEPHASE,4");   //P1 has won                 //70
//bit 6 set, P1 to serve, set ball to bat and wait for press
asm("CLRF _C");            //clear flag                 //71
asm("BTFSC _GAMEPHASE,6"); //bit 6 set
asm("BSF _C,0");           //set flag
asm("MOVF _P1BAT,W");      //load P1 BAT
asm("BTFSC _C,0");         //if flag
asm("MOVWF _BALLY");       //load ball pos
asm("MOVLW 0x58");         //ballx>87
asm("BTFSC _C,0");         //if flag
asm("MOVWF _BALLX");       //load ball pos
asm("MOVF _P1RAW,W");      //load raw bat     
asm("ADDLW 0xF0");         //checking if <16
asm("BTFSC STATUS,0");     //if carry
asm("BCF _C,0");           //clear flag
asm("BTFSC _C,0");          //check flag
asm("BSF _GAMEPHASE,0");    //rally start
asm("BTFSC _C,0");          //check flag
asm("BCF _GAMEPHASE,6");    //P1 has served
asm("MOVLW 0x01");         //
asm("BTFSC _C,0");         //check flag
asm("MOVWF _BALLU");       //ball moving right          //90
//bit 7 set, P2 to serve, set ball to bat and wait for press
asm("CLRF _C");            //clear flag                 //91
asm("BTFSC _GAMEPHASE,7"); //bit 7 set
asm("BSF _C,0");           //set flag
asm("MOVF _P2BAT,W");      //load P1 BAT
asm("BTFSC _C,0");         //if flag
asm("MOVWF _BALLY");       //load ball pos
asm("MOVLW 0xCE");         //ballx
asm("BTFSC _C,0");         //if flag
asm("MOVWF _BALLX");       //load ball pos
asm("MOVF _P2RAW,W");      //load raw bat     
asm("ADDLW 0xF0");         //checking if <16
asm("BTFSC STATUS,0");     //if carry
asm("BCF _C,0");           //clear flag
asm("BTFSC _C,0");          //check flag
asm("BSF _GAMEPHASE,0");    //rally start
asm("BTFSC _C,0");          //check flag
asm("BCF _GAMEPHASE,7");    //P2 has served
asm("MOVLW 0xFF");         //
asm("BTFSC _C,0");         //check flag
asm("MOVWF _BALLU");       //ball moving left          //110
//check if BALLX is 84-87 (P1 BAT)
asm("CLRF _C");            //clear flag                 //111
asm("MOVF _BALLX,W");      //load
asm("ADDLW 0xAC");         //-84
asm("BTFSC STATUS,0");     //if no carry
asm("BSF _C,0");           //set flag
asm("MOVF _BALLX,W");      //load
asm("ADDLW 0xA9");         //-87
asm("BTFSC STATUS,0");     //if no carry
asm("BCF _C,0");           //clear flag                 //119
//check if struck bat (16)
asm("MOVF _BALLY,W");      //load                       //120
asm("ADDLW 0xF8");         //offset
asm("XORLW 0xFF");         //subtract
asm("ADDWF _P1BAT,W");     //add
asm("ANDLW 0xF0");         //mask
asm("BTFSS STATUS,2");     //if nonzero
asm("BCF _C,0");           //clear flag                 //126
//if flag, set BALLV from relative positions
asm("MOVF _P1BAT,W");      //load                       //127
asm("XORLW 0xFF");         //subtract
asm("ADDWF _BALLY,W");     //add
asm("MOVWF _DELCTR");      //use as temp
asm("ASRF _DELCTR,W");     //halve
asm("BTFSC _C,0");         //check flag
asm("MOVWF _BALLV");       //return fixed value         //133
//if flag still set, bounce ball, flip BALLU
asm("BTFSS _BALLU,7");     //if already positive        //134
asm("BCF _C,0");           //set second flag
asm("MOVF _BALLU,W");      //move to W
asm("XORLW 0xFF");         //flip bits
asm("ADDLW 0x01");         //add one
asm("BTFSC _C,0");         //check flag
asm("MOVWF _BALLU");       //return fixed value
asm("BTFSC _C,0");         //check flag
asm("INCF _HITCOUNT,F");   //rally length               //142
//play sound on hit
asm("MOVLW 0x6A");
asm("BTFSC _C,0");        //check flag
asm("MOVWF _SOUND");      //request sound               //145
//check if BALLX is 207-210 (P2 BAT)
asm("CLRF _C");            //clear flag                 //146
asm("MOVF _BALLX,W");      //load
asm("ADDLW 0x31");         //-207
asm("BTFSC STATUS,0");     //if no carry
asm("BSF _C,0");           //set flag
asm("MOVF _BALLX,W");      //load
asm("ADDLW 0x2E");         //-210
asm("BTFSC STATUS,0");     //if no carry
asm("BCF _C,0");           //clear flag                 //154
//check if struck bat (16)
asm("MOVF _BALLY,W");      //load                       //155
asm("ADDLW 0xF8");         //offset
asm("XORLW 0xFF");         //subtract
asm("ADDWF _P2BAT,W");     //add
asm("ANDLW 0xF0");         //mask
asm("BTFSS STATUS,2");     //if nonzero
asm("BCF _C,0");           //clear flag                 //161
//if flag, set BALLV from relative positions
asm("MOVF _P2BAT,W");      //load                       //162
asm("XORLW 0xFF");         //subtract
asm("ADDWF _BALLY,W");     //add
asm("MOVWF _DELCTR");      //use as temp
asm("ASRF _DELCTR,W");     //halve
asm("BTFSC _C,0");         //check flag
asm("MOVWF _BALLV");       //return fixed value         //168
//if flag still set, bounce ball, flip BALLU
asm("BTFSC _BALLU,7");     //if already negative        //169
asm("BCF _C,0");           //set second flag
asm("MOVF _BALLU,W");      //move to W
asm("XORLW 0xFF");         //flip bits
asm("ADDLW 0x01");         //add one
asm("BTFSC _C,0");         //check flag
asm("MOVWF _BALLU");       //return fixed value
asm("BTFSC _C,0");         //check flag
asm("INCF _HITCOUNT,F");   //rally length               //177
//play sound on hit
asm("MOVLW 0x77");
asm("BTFSC _C,0");        //check flag
asm("MOVWF _SOUND");      //request sound               //180
//catch if BALLX < P1 Bat (54)=P2 has won point
asm("BCF _C,0");           //clear flag                 //181
asm("MOVF _BALLX,W");      //load
asm("ADDLW 0xCA");         //-54
asm("BTFSS STATUS,0");     //if no carry
asm("BSF _C,0");           //set flag
asm("BTFSC _C,0");         //check flag
asm("CLRF _BALLU");        //stop ball
asm("BTFSC _C,0");         //check flag
asm("CLRF _BALLV");        //stop ball
asm("BTFSC _C,0");          //check flag
asm("INCF _P2SCORE,F");     //score
asm("BTFSC _C,0");          //check flag
asm("CLRF _HITCOUNT");      //end rally
asm("BTFSC _C,0");          //check flag
asm("BCF _GAMEPHASE,0");     //rally over
asm("BTFSC _C,0");          //check flag
asm("BSF _GAMEPHASE,7");     //P2 to serve              //197
//catch if BALLX > P2 Bat (240)=P1 has won point
asm("BCF _C,0");           //clear flag                 //198
asm("MOVF _BALLX,W");      //load
asm("ADDLW 0x10");         //-240
asm("BTFSC STATUS,0");     //if no carry
asm("BSF _C,0");           //set flag
asm("BTFSC _C,0");         //check flag
asm("CLRF _BALLU");        //stop ball
asm("BTFSC _C,0");         //check flag
asm("CLRF _BALLV");        //stop ball
asm("BTFSC _C,0");         //check flag
asm("INCF _P1SCORE,F");     //score
asm("BTFSC _C,0");          //check flag
asm("CLRF _HITCOUNT");      //end rally
asm("BTFSC _C,0");          //check flag
asm("BCF _GAMEPHASE,0");     //rally over
asm("BTFSC _C,0");          //check flag
asm("BSF _GAMEPHASE,6");     //P1 to serve          //214
//speedups
//at HITCOUNT 12, 1->2
asm("CLRF _C");            //clear flag             //215
asm("MOVF _HITCOUNT,W");   //load
asm("XORLW 0xC");          //match with 12
asm("BTFSC STATUS,2");     //on non-match
asm("BSF _C,0");           //clear
asm("MOVF _BALLU,W");      //load BALLU
asm("XORLW 0x01");         //match with 1
asm("BTFSS STATUS,2");     //on non-match
asm("BCF _C,0");           //clear
asm("MOVLW 0x2");          //load new
asm("BTFSC _C,0");         //non-match
asm("MOVWF _BALLU");       //load BALLU             //226
//at HITCOUNT 12, -1->-2
asm("CLRF _C");            //clear flag             //227
asm("MOVF _HITCOUNT,W");   //load
asm("XORLW 0xC");          //match with 12
asm("BTFSC STATUS,2");     //on non-match
asm("BSF _C,0");           //clear
asm("MOVF _BALLU,W");      //load BALLU
asm("XORLW 0xFF");         //match with -1
asm("BTFSS STATUS,2");     //on non-match
asm("BCF _C,0");           //clear
asm("MOVLW 0xFE");          //load new
asm("BTFSC _C,0");         //non-match
asm("MOVWF _BALLU");       //load BALLU             //238
//at HITCOUNT 24, 2->3
asm("CLRF _C");            //clear flag             //239
asm("MOVF _HITCOUNT,W");   //load
asm("XORLW 0x18");         //match with 24
asm("BTFSC STATUS,2");     //on non-match
asm("BSF _C,0");           //clear
asm("MOVF _BALLU,W");      //load BALLU
asm("XORLW 0x02");         //match with 2
asm("BTFSS STATUS,2");     //on non-match
asm("BCF _C,0");           //clear
asm("MOVLW 0x3");          //load new 3
asm("BTFSC _C,0");         //non-match
asm("MOVWF _BALLU");       //load BALLU             //250
//at HITCOUNT 24, -2->-3
asm("CLRF _C");            //clear flag             //251
asm("MOVF _HITCOUNT,W");   //load
asm("XORLW 0x18");         //match with 24
asm("BTFSC STATUS,2");     //on non-match
asm("BSF _C,0");           //clear
asm("MOVF _BALLU,W");      //load BALLU
asm("XORLW 0xFE");         //match with -2
asm("BTFSS STATUS,2");     //on non-match
asm("BCF _C,0");           //clear
asm("MOVLW 0xFD");         //load new -3
asm("BTFSC _C,0");         //non-match
asm("MOVWF _BALLU");       //load BALLU             //262
//vertical bounces:
//set BALLV to + if <8
asm("BCF _C,0");           //clear flag             //263
asm("MOVF _BALLY,W");      //load   
asm("ADDLW 0xF8");         //-8
asm("BTFSS STATUS,0");     //if no carry
asm("BSF _C,0");           //set flag
asm("BTFSS _BALLV,7");     //if already positive
asm("BCF _C,0");           //clear flag
asm("MOVF _BALLV,W");      //move to W
asm("XORLW 0xFF");         //flip bits
asm("ADDLW 0x01");         //add one
asm("BTFSC _C,0");         //check flag
asm("MOVWF _BALLV");       //return fixed value     //274
//play sound on hit
asm("MOVLW 0x47");              
asm("BTFSC _C,0");        //check flag
asm("MOVWF _SOUND");      //request sound           //277
//set BALLV to - if >247
asm("BCF _C,0");           //clear flag             //278
asm("MOVF _BALLY,W");      //load
asm("ADDLW 0x08");         //-248
asm("BTFSC STATUS,0");     //if carry
asm("BSF _C,0");           //set flag
asm("BTFSC _BALLV,7");     //if already negative
asm("BCF _C,0");           //clear flag
asm("MOVF _BALLV,W");      //move to W
asm("XORLW 0xFF");         //flip bits
asm("ADDLW 0x01");         //add one
asm("BTFSC _C,0");         //check flag
asm("MOVWF _BALLV");       //return fixed value     //289
//play sound on hit
asm("MOVLW 0x3F");
asm("BTFSC _C,0");        //check flag
asm("MOVWF _SOUND");      //request sound           //292
//motion updates
asm("MOVF _BALLU,W");       //increment ball x and y
asm("ADDWF _BALLX,F");
asm("MOVF _BALLV,W");
asm("ADDWF _BALLY,F");                              //296
//play winning sounds
asm("CLRF _C");            //clear flag             //297
asm("BTFSC _GAMEPHASE,4"); //P1 has won
asm("BSF _C,0");           //set
asm("BTFSC _GAMEPHASE,5"); //P2 has won
asm("BSF _C,0");           //set
asm("MOVF _FIELDCOUNT,W"); //use this as sound generator
asm("BTFSC _FIELDCOUNT,2");//alternate frames
asm("BCF _C,0");           //clear
asm("BTFSC _FIELDCOUNT,4");//alternate frames
asm("BCF _C,0");           //clear
asm("XORLW 0xFF");         //negate to invert
asm("ANDLW 0x3F");         //reduce span
asm("ADDLW 0x40");         //put into audible range (0x3F-0x7F =>B3-E5)
asm("BTFSC _C,0");
asm("MOVWF _SOUND");       //load if flag set       //311
//audio updates
asm("MOVF _SOUND,W");       //load sound value      //312
asm("MOVLB 0x1B");          //PWM in bank 27   
asm("MOVWF PWM3PRH");
asm("BTFSC STATUS,2");      //turn off PWM if zero
asm("BCF PWM3CON,7");
asm("BTFSS STATUS,2");      //turn on if non-zero
asm("BSF PWM3CON,7");
asm("MOVLB 0");             //back to bank 0        
asm("MOVLW 0");             //default silence, also flags PWM shutdown
asm("MOVWF _SOUND");        //return to silence unless sound requested  //321
asm("MOVLW 0x38");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //322-325+ 169 => 494
asm("NOP");     //495
asm("NOP");     //496
//reset ball PWM at end of every frame
//this must be at this time to align with physics
asm("MOVF _BALLX,W");       //                    //497
asm("MOVLB 0x1B");          //PWM in bank 27      //498
asm("MOVWF PWM1PHL");                             //499
asm("ADDLW 6");             //ball width          //500
asm("MOVWF PWM1DCL");                             //501
asm("BCF PWM1CON,7");       //reset                 502
asm("CLRF PWM1TMRH");       //clear timer           503
asm("CLRF PWM1TMRL");
asm("BSF PWM1CON,7");       //reenable              505
asm("MOVLB 0");             //back to bank 0        506
asm("RETURN");              //507,508(509/510 in goto start)

asm("VSYNCLINE:");      //vertical sync is same as blank but with inverted sync levels- not serrated but commonly used.
asm("BSF PORTA, 0x4");  //1
asm("MOVLW 0x0B");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //2,3,4,5 + 34 =>39 sync low
asm("BCF PORTA, 0x4");  //40
asm("MOVLW 0x9A");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //41,42,43,44+ 463 => 507
asm("NOP");                //508
asm("RETURN");             //509,510

//this is what draws everything that appears in the play area
//draws sync, sets flags for P1, P2 and ball- this is where the heights are set
//calls BATLINENOBALL if ball is not needed/visible
//enables PWM output for ball if it is on this line
//performs polarity inversion for bats and net
//jumps to score displays as needed
// bat1,score1,net,score2,bat2
//many tweaks of opcode count as number does not seem accurate
//increments line number at the end
asm("BATLINE:");        //actual play area is 162-418, net at 290, this version inverts the phase to display items
asm("BCF PORTA, 0x4");  //1
asm("MOVLW 0x0B");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //2,3,4,5 + 34 =>39 sync low
asm("BSF PORTA, 0x4");  //40
//set up bat and ball flags
//P1 flag, 10 inst =50
asm("MOVF _LINENO,W");  //load
asm("ADDLW 0x08");      //add bat positive height
asm("XORWF _P1BAT,W");  //compare line
asm("BTFSC STATUS,2");  //check for match
asm("BSF _FLAGS,1");    //set P1
asm("MOVF _LINENO,W");  //load
asm("ADDLW 0xF8");      //add bat (negative) height
asm("XORWF _P1BAT,W");  //compare line
asm("BTFSC STATUS,2");  //check for match
asm("BCF _FLAGS,1");    //clear P1
//P2 flag, 10 inst =60
asm("MOVF _LINENO,W");  //load
asm("ADDLW 0x08");      //add bat positive height
asm("XORWF _P2BAT,W");  //compare line
asm("BTFSC STATUS,2");  //check for match
asm("BSF _FLAGS,2");    //set P2
asm("MOVF _LINENO,W");  //load
asm("ADDLW 0xF8");      //add bat (negative) height
asm("XORWF _P2BAT,W");  //compare line
asm("BTFSC STATUS,2");  //check for match
asm("BCF _FLAGS,2");    //clear P2
//Ball flag, 10 inst =70
asm("MOVF _LINENO,W");  //load
asm("ADDLW 0x06");      //add ball height
asm("XORWF _BALLY,W");  //compare line
asm("BTFSC STATUS,2");  //check for match
asm("BSF _FLAGS,0");    //set P2
asm("MOVF _LINENO,W");  //load
asm("ADDLW 0xFA");      //add ball negative height
asm("XORWF _BALLY,W");  //compare line
asm("BTFSC STATUS,2");  //check for match
asm("BCF _FLAGS,0");    //clear BALL
asm("MOVLW 0x5");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //70-73 + 16 =>89 start of visible area
//enable ball
asm("MOVLB 0x1B");          //PWM in bank 27    //90
asm("BTFSS _FLAGS,0");      //check BALL        //91
asm("GOTO BATLINENOBALL");   //if no ball, use alt routine, 92
asm("BSF PWM1CON,6");       //OE                //93
//wait for P1 Bat
asm("MOVLW 0x15");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //94-97 + 64 =>161
//invert pol for P1 Bat
asm("BTFSC _FLAGS,1");asm("BSF PWM1CON,4");asm("NOP");asm("NOP");asm("NOP");asm("NOP");asm("NOP");asm("BCF PWM1CON,4");    //162-169
//wait for net
asm("CALL DOP1SCORE");   //170-291 inc call and return
//invert pol for net
asm("BSF PWM1CON,4");asm("NOP");asm("BCF PWM1CON,4");asm("NOP");asm("BSF PWM1CON,4");asm("NOP");asm("BCF PWM1CON,4");    //292-298
//wait for P2 Bat
asm("CALL DOP2SCORE");   //299-420 inc call and return
//invert pol for P2 Bat
asm("BTFSC _FLAGS,2");asm("BSF PWM1CON,4");asm("NOP");asm("NOP");asm("NOP");asm("NOP");asm("NOP");asm("BCF PWM1CON,4");    //421-428
//wait for end of visible area
asm("MOVLW 0x15");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //429-432 + 64 =>496
asm("BCF PWM1CON,6");       //OE off            //497
asm("MOVLB 0");             //back to bank 0    //498
//asm("NOP");                //499
asm("NOP");                //500 (end of visible area)
asm("NOP");                //501
asm("NOP");                //502
asm("NOP");                //503
asm("NOP");                //504
asm("NOP");                //505
asm("NOP");                //506
asm("NOP");                //507
asm("INCF _LINENO,F");     //508
asm("RETURN");             //509,510

//this does the drawing if the ball is not on this line
//does not need access to bank 27/PWM, so everything is back in bank 0
//drawing is done by setting output hi
//jumps to score displays as needed
// bat1,score1,net,score2,bat2
//many tweaks of opcode count as number does not seem accurate
//increments line number at the end

asm("BATLINENOBALL:");     //
//goto is 92,93
asm("MOVLB 0");             //back to bank 0    //94
//wait for P1 Bat
asm("NOP");                //95
asm("NOP");                //96
asm("MOVLW 0x14");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //97-100 + 61 =>161
//set high for P1 Bat
asm("BTFSC _FLAGS,1");asm("BSF PORTA, 0x5");asm("NOP");asm("NOP");asm("NOP");asm("NOP");asm("NOP");asm("BCF PORTA, 0x5");    //162-169
//wait for net
asm("CALL DOP1SCORE");   //170-291 inc call and return
//toggle for net
asm("BSF PORTA, 0x5");asm("NOP");asm("BCF PORTA, 0x5");asm("NOP");asm("BSF PORTA, 0x5");asm("NOP");asm("BCF PORTA, 0x5");    //292-298
//wait for P2 Bat
asm("CALL DOP2SCORE");   //299-420 inc call and return
//set high for P2 Bat
asm("BTFSC _FLAGS,2");asm("BSF PORTA, 0x5");asm("NOP");asm("NOP");asm("NOP");asm("NOP");asm("NOP");asm("BCF PORTA, 0x5");    //421-428
//wait for end of visible area
asm("MOVLW 0x18");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //429-432 + 73 =>505
//asm("NOP");                //506 ?
asm("NOP");                //507
asm("INCF _LINENO,F");     //508
asm("RETURN");             //509,510

asm("DOP1SCORE:");       //outputs P1 score 122 clocks including incoming call
//call=1,2
asm("SWAPF _P1SCORE,W");            //3
asm("ANDLW 0xF0");                  //4
asm("MOVWF _NUMPAR");    //4 bottom bits of score in 4 upper bits of NUMPAR
asm("LSRF _LINENO,W");   // 07654321
asm("ANDLW 0xF");        //in W with bottom bits clear 00004321
asm("IORWF _NUMPAR,F");  //combine SSSSLLLL
asm("LSRF _NUMPAR,F");   //0SSSSLLL //9
asm("NOP");                         //10
asm("BTFSC _GAMEPHASE,4");  //if P1 win
asm("BSF _NUMPAR,7");       //set blank flag
asm("GOTO DOCOMSCORE");             //13,14

asm("DOP2SCORE:");       //outputs P2 score 122 clocks including incoming call
//call=1,2
asm("SWAPF _P2SCORE,W");            //3
asm("ANDLW 0xF0");                  //4
asm("MOVWF _NUMPAR");    //4 bottom bits of score in 4 upper bits of NUMPAR
asm("LSRF _LINENO,W");   // 07654321
asm("ANDLW 0xF");        //in W with bottom bits clear 00004321
asm("IORWF _NUMPAR,F");  //combine SSSSLLLL
asm("LSRF _NUMPAR,F");   //0SSSSLLL //9
asm("NOP");                         //10
asm("BTFSC _GAMEPHASE,5");  //if P2 win
asm("BSF _NUMPAR,7");       //set blank flag
asm("GOTO DOCOMSCORE");             //13,14

asm("DOCOMSCORE:");        //takes score as set up by DOP1SCORE or DOP2SCORE
asm("MOVF BSR,W");         //save Bank                  //15
asm("MOVWF _C");           //in C                       //16
asm("MOVLB 0x0");          //home bank for _FIELDCOUNT  //17
asm("BTFSC _FIELDCOUNT,4"); //arbitrary flash rate      //18
asm("BCF _NUMPAR,7");       //clear blank flag          //19
asm("MOVF _C,W");           //restore                   //20
asm("MOVWF BSR");           //into Bank                 //21
asm("BTFSC _NUMPAR,7");     // check if MSB set for blanking    //22
asm("GOTO NONUMBER2");      //stub for nonumber                 //23(24)
asm("MOVF _LINENO,W");     //load line      24
asm("ANDLW 0xE0");         //top 3 bits     25
asm("XORLW 0x20");         //match          26 (try multiples of 0x20)
asm("BTFSS STATUS,2");     //if non zero    27
asm("GOTO NONUMBER");      //skip drawing   28(29)
asm("NOP");                //29
asm("MOVLW 0x01");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //30-33 + 4 =>37
asm("MOVF BSR,W");         //save Bank                  //38
asm("MOVWF _C");           //in C                       //39
asm("MOVLB 0x1B");          //PWM in bank 27            //40
asm("BCF PWM1CON,6");       //OE off                    //41
asm("MOVLB 0");             //back to bank 0            //42
asm("CALL DONUMBER");      //show number (34 clocks, 43-76)
asm("MOVLB 0x1B");          //PWM in bank 27            //77
asm("BTFSC _FLAGS,0");      //check BALL                //78
asm("BSF PWM1CON,6");       //OE if ball active         //79
asm("MOVLB 0");             //back to bank 0            //80
asm("MOVLW 0x0A");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //81-84 + 31 =>115
asm("MOVF _C,W");           //restore c 116
asm("MOVWF BSR");          //into Bank 117
asm("NOP");                //118
asm("RETURN");             //119,120

asm("NONUMBER2:");         //timing stub for nonumber
asm("NOP");                //25
asm("NOP");                //26
asm("NOP");                //27
asm("GOTO NONUMBER");      //28,29

asm("NONUMBER:");           //delay goto'd if number is not needed on this line
asm("MOVLW 0x1C");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //30-33 + 85 =>118
asm("NOP");                //119
asm("NOP");                //120
asm("RETURN");             //121,122

asm("DONUMBER:");       //computed goto with value in NUMPAR, bits 0-2 = line number, bits 3-6=number to display
asm("MOVF _NUMPAR,w");  //1
asm("ANDLW 0x7F");      //2,trim
asm("BRW");             //3,4
asm("GOTO BITMAP14");   //5,6, this is the lookup table
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP14");
asm("GOTO BITMAP00");
asm("GOTO BITMAP04");
asm("GOTO BITMAP06");
asm("GOTO BITMAP04");
asm("GOTO BITMAP04");
asm("GOTO BITMAP04");
asm("GOTO BITMAP04");
asm("GOTO BITMAP14");
asm("GOTO BITMAP00");
asm("GOTO BITMAP14");
asm("GOTO BITMAP17");
asm("GOTO BITMAP16");
asm("GOTO BITMAP12");
asm("GOTO BITMAP02");
asm("GOTO BITMAP01");
asm("GOTO BITMAP31");
asm("GOTO BITMAP00");
asm("GOTO BITMAP14");
asm("GOTO BITMAP17");
asm("GOTO BITMAP16");
asm("GOTO BITMAP12");
asm("GOTO BITMAP16");
asm("GOTO BITMAP17");
asm("GOTO BITMAP14");
asm("GOTO BITMAP00");
asm("GOTO BITMAP08");
asm("GOTO BITMAP12");
asm("GOTO BITMAP10");
asm("GOTO BITMAP10");
asm("GOTO BITMAP09");
asm("GOTO BITMAP31");
asm("GOTO BITMAP08");
asm("GOTO BITMAP00");
asm("GOTO BITMAP31");
asm("GOTO BITMAP01");
asm("GOTO BITMAP15");
asm("GOTO BITMAP16");
asm("GOTO BITMAP16");
asm("GOTO BITMAP17");
asm("GOTO BITMAP14");
asm("GOTO BITMAP00");
asm("GOTO BITMAP12");
asm("GOTO BITMAP02");
asm("GOTO BITMAP01");
asm("GOTO BITMAP15");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP14");
asm("GOTO BITMAP00");
asm("GOTO BITMAP31");
asm("GOTO BITMAP16");
asm("GOTO BITMAP16");
asm("GOTO BITMAP08");
asm("GOTO BITMAP08");
asm("GOTO BITMAP04");
asm("GOTO BITMAP04");
asm("GOTO BITMAP00");
asm("GOTO BITMAP14");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP14");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP14");
asm("GOTO BITMAP00");
asm("GOTO BITMAP14");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP30");
asm("GOTO BITMAP16");
asm("GOTO BITMAP08");
asm("GOTO BITMAP06");
asm("GOTO BITMAP00");
asm("GOTO BITMAP09");
asm("GOTO BITMAP21");
asm("GOTO BITMAP21");
asm("GOTO BITMAP21");
asm("GOTO BITMAP21");
asm("GOTO BITMAP21");
asm("GOTO BITMAP09");
asm("GOTO BITMAP00");
asm("GOTO BITMAP09");
asm("GOTO BITMAP09");
asm("GOTO BITMAP09");
asm("GOTO BITMAP09");
asm("GOTO BITMAP09");
asm("GOTO BITMAP09");
asm("GOTO BITMAP09");
asm("GOTO BITMAP00");
asm("GOTO BITMAP13");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP09");
asm("GOTO BITMAP05");
asm("GOTO BITMAP05");
asm("GOTO BITMAP29");
asm("GOTO BITMAP00");
asm("GOTO BITMAP13");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP13");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP13");
asm("GOTO BITMAP00");
asm("GOTO BITMAP17");
asm("GOTO BITMAP25");
asm("GOTO BITMAP21");
asm("GOTO BITMAP21");
asm("GOTO BITMAP21");
asm("GOTO BITMAP29");
asm("GOTO BITMAP17");
asm("GOTO BITMAP00");
asm("GOTO BITMAP29");
asm("GOTO BITMAP05");
asm("GOTO BITMAP13");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP17");
asm("GOTO BITMAP13");
asm("GOTO BITMAP00");
//each bitmap is 26+return=28=>34 clocks called
//BITMAP00
asm("BITMAP00:");NOPS_026;asm("RETURN"); 
//BITMAP01
asm("BITMAP01:");SETLUM;NOPS_004;CLEARLUM;NOPS_020;asm("RETURN"); 
//BITMAP02
asm("BITMAP02:");NOPS_005;SETLUM;NOPS_004;CLEARLUM;NOPS_015;asm("RETURN"); 
//BITMAP03
//asm("BITMAP03:");SETLUM;NOPS_009;CLEARLUM;NOPS_015;asm("RETURN"); 
//BITMAP04
asm("BITMAP04:");NOPS_010;SETLUM;NOPS_004;CLEARLUM;NOPS_010;asm("RETURN"); 
//BITMAP05
asm("BITMAP05:");SETLUM;NOPS_004;CLEARLUM;NOPS_004;SETLUM;NOPS_004;CLEARLUM;NOPS_010;asm("RETURN"); 
//BITMAP06
asm("BITMAP06:");NOPS_005;SETLUM;NOPS_009;CLEARLUM;NOPS_010;asm("RETURN"); 
//BITMAP07
//asm("BITMAP07:");SETLUM;NOPS_014;CLEARLUM;NOPS_010;asm("RETURN"); 
//BITMAP08
asm("BITMAP08:");NOPS_015;SETLUM;NOPS_004;CLEARLUM;NOPS_005;asm("RETURN"); 
//BITMAP09
asm("BITMAP09:");SETLUM;NOPS_004;CLEARLUM;NOPS_009;SETLUM;NOPS_004;CLEARLUM;NOPS_005;asm("RETURN"); 
//BITMAP10
asm("BITMAP10:");NOPS_005;SETLUM;NOPS_004;CLEARLUM;NOPS_004;SETLUM;NOPS_004;CLEARLUM;NOPS_005;asm("RETURN"); 
//BITMAP11
//asm("BITMAP11:");SETLUM;NOPS_009;CLEARLUM;NOPS_004;SETLUM;NOPS_004;CLEARLUM;NOPS_005;asm("RETURN"); 
//BITMAP12
asm("BITMAP12:");NOPS_010;SETLUM;NOPS_009;CLEARLUM;NOPS_005;asm("RETURN"); 
//BITMAP13
asm("BITMAP13:");SETLUM;NOPS_004;CLEARLUM;NOPS_004;SETLUM;NOPS_009;CLEARLUM;NOPS_005;asm("RETURN"); 
//BITMAP14
asm("BITMAP14:");NOPS_005;SETLUM;NOPS_014;CLEARLUM;NOPS_005;asm("RETURN"); 
//BITMAP15
asm("BITMAP15:");SETLUM;NOPS_019;CLEARLUM;NOPS_005;asm("RETURN"); 
//BITMAP16
asm("BITMAP16:");NOPS_020;SETLUM;NOPS_004;CLEARLUM;asm("RETURN"); 
//BITMAP17
asm("BITMAP17:");SETLUM;NOPS_004;CLEARLUM;NOPS_014;SETLUM;NOPS_004;CLEARLUM;asm("RETURN"); 
//BITMAP18
//asm("BITMAP18:");NOPS_005;SETLUM;NOPS_004;CLEARLUM;NOPS_009;SETLUM;NOPS_004;CLEARLUM;asm("RETURN"); 
//BITMAP19
asm("BITMAP19:");SETLUM;NOPS_009;CLEARLUM;NOPS_009;SETLUM;NOPS_004;CLEARLUM;asm("RETURN"); 
//BITMAP20
//asm("BITMAP20:");NOPS_010;SETLUM;NOPS_004;CLEARLUM;NOPS_004;SETLUM;NOPS_004;CLEARLUM;asm("RETURN"); 
//BITMAP21
asm("BITMAP21:");SETLUM;NOPS_004;CLEARLUM;NOPS_004;SETLUM;NOPS_004;CLEARLUM;NOPS_004;SETLUM;NOPS_004;CLEARLUM;asm("RETURN"); 
//BITMAP22
//asm("BITMAP22:");NOPS_005;SETLUM;NOPS_009;CLEARLUM;NOPS_004;SETLUM;NOPS_004;CLEARLUM;asm("RETURN"); 
//BITMAP23
//asm("BITMAP23:");SETLUM;NOPS_014;CLEARLUM;NOPS_004;SETLUM;NOPS_004;CLEARLUM;asm("RETURN"); 
//BITMAP24
//asm("BITMAP24:");NOPS_015;SETLUM;NOPS_009;CLEARLUM;asm("RETURN"); 
//BITMAP25
asm("BITMAP25:");SETLUM;NOPS_004;CLEARLUM;NOPS_009;SETLUM;NOPS_009;CLEARLUM;asm("RETURN"); 
//BITMAP26
//asm("BITMAP26:");NOPS_005;SETLUM;NOPS_004;CLEARLUM;NOPS_004;SETLUM;NOPS_009;CLEARLUM;asm("RETURN"); 
//BITMAP27
//asm("BITMAP27:");SETLUM;NOPS_009;CLEARLUM;NOPS_004;SETLUM;NOPS_009;CLEARLUM;asm("RETURN"); 
//BITMAP28
//asm("BITMAP28:");NOPS_010;SETLUM;NOPS_014;CLEARLUM;asm("RETURN"); 
//BITMAP29
asm("BITMAP29:");SETLUM;NOPS_004;CLEARLUM;NOPS_004;SETLUM;NOPS_014;CLEARLUM;asm("RETURN"); 
//BITMAP30
asm("BITMAP30:");NOPS_005;SETLUM;NOPS_019;CLEARLUM;asm("RETURN"); 
//BITMAP31
asm("BITMAP31:");SETLUM;NOPS_024;CLEARLUM;asm("RETURN"); 

asm("GLINE:");          //a line of graphics
asm("BCF PORTA, 0x4");  //1
asm("MOVLW 0x0B");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //2,3,4,5 + 34 =>39 sync low
asm("BSF PORTA, 0x4");  //40
asm("MOVLW 0x1C");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //41-44 + 85 => 129
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("MOVF _C,W");
//+288 = 417
asm("ANDLW 0xF8");
asm("MOVWF _C");        //419
asm("MOVLW 0x1C");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //420-423+85=508
asm("RETURN");             //509,510

asm("GLINE2:");          //a line of graphics
asm("BCF PORTA, 0x4");  //1
asm("MOVLW 0x0B");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //2,3,4,5 + 34 =>39 sync low
asm("BSF PORTA, 0x4");  //40
asm("MOVLW 0x1C");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //41-44 + 85 => 129
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
asm("CALL GRAPHICS");asm("INCF _C,F");
//+288 = 417
asm("NOP");
asm("NOP");
asm("MOVLW 0x1C");asm("MOVWF _DELCTR");asm("CALL DELAYBYW");   //420-423+85=508
asm("RETURN");             //509,510


asm("GRAPHICS:");
asm("MOVF _C,w");       //1, use C
asm("BRW");             //2,3
//each call is 4,5
//see defines in io.h
BM_14;BM_14;BM_01;BM_14;BM_14;BM_14;BM_17;BM_00;
BM_17;BM_04;BM_01;BM_04;BM_17;BM_17;BM_19;BM_00;
BM_01;BM_04;BM_01;BM_04;BM_01;BM_17;BM_21;BM_00;
BM_14;BM_04;BM_01;BM_04;BM_01;BM_17;BM_21;BM_00;
BM_16;BM_04;BM_01;BM_04;BM_01;BM_17;BM_25;BM_00;
BM_17;BM_04;BM_01;BM_04;BM_17;BM_17;BM_17;BM_00;
BM_14;BM_14;BM_31;BM_14;BM_14;BM_14;BM_17;BM_00;

BM_14;BM_17;BM_14;BM_15;BM_00;BM_00;BM_00;BM_00;
BM_17;BM_17;BM_04;BM_17;BM_00;BM_00;BM_00;BM_00;
BM_01;BM_17;BM_04;BM_17;BM_00;BM_00;BM_00;BM_00;
BM_01;BM_31;BM_04;BM_15;BM_00;BM_00;BM_00;BM_00;
BM_01;BM_17;BM_04;BM_01;BM_00;BM_00;BM_00;BM_00;
BM_17;BM_17;BM_04;BM_01;BM_00;BM_00;BM_00;BM_00;
BM_14;BM_17;BM_14;BM_01;BM_00;BM_00;BM_00;BM_00;

BM_00;BM_00;BM_15;BM_14;BM_15;BM_14;BM_00;BM_00;
BM_00;BM_00;BM_17;BM_17;BM_17;BM_17;BM_00;BM_00;
BM_00;BM_00;BM_17;BM_31;BM_17;BM_17;BM_00;BM_00;
BM_00;BM_00;BM_17;BM_17;BM_17;BM_17;BM_00;BM_00;
BM_00;BM_00;BM_17;BM_17;BM_17;BM_14;BM_00;BM_00;

BM_00;BM_00;BM_15;BM_14;BM_15;BM_30;BM_00;BM_00;
BM_00;BM_00;BM_17;BM_17;BM_17;BM_01;BM_00;BM_00;
BM_00;BM_00;BM_15;BM_17;BM_17;BM_01;BM_00;BM_00;
BM_00;BM_00;BM_01;BM_17;BM_17;BM_25;BM_00;BM_00;
BM_00;BM_00;BM_01;BM_17;BM_17;BM_17;BM_00;BM_00;
BM_00;BM_00;BM_01;BM_14;BM_17;BM_14;BM_00;BM_00;


/*
S_1;I_1;L_1;I_1;C_1;O_1;N_1;SPC;
S_2;I_2;L_2;I_2;C_2;O_2;N_2;SPC;
S_3;I_3;L_3;I_3;C_3;O_3;N_3;SPC;
S_4;I_4;L_4;I_4;C_4;O_4;N_4;SPC;
S_5;I_5;L_5;I_5;C_5;O_5;N_5;SPC;
S_6;I_6;L_6;I_6;C_6;O_6;N_6;SPC;
S_7;I_7;L_7;I_7;C_7;O_7;N_7;SPC;
SPC;SPC;SPC;SPC;SPC;SPC;SPC;SPC;
S_1;I_1;L_1;I_1;C_1;O_1;N_1;SPC;
S_2;I_2;L_2;I_2;C_2;O_2;N_2;SPC;
S_3;I_3;L_3;I_3;C_3;O_3;N_3;SPC;
S_4;I_4;L_4;I_4;C_4;O_4;N_4;SPC;
S_5;I_5;L_5;I_5;C_5;O_5;N_5;SPC;
S_6;I_6;L_6;I_6;C_6;O_6;N_6;SPC;
S_7;I_7;L_7;I_7;C_7;O_7;N_7;SPC;
SPC;SPC;SPC;SPC;SPC;SPC;SPC;SPC;
S_1;I_1;L_1;I_1;C_1;O_1;N_1;SPC;
S_2;I_2;L_2;I_2;C_2;O_2;N_2;SPC;
S_3;I_3;L_3;I_3;C_3;O_3;N_3;SPC;
S_4;I_4;L_4;I_4;C_4;O_4;N_4;SPC;
S_5;I_5;L_5;I_5;C_5;O_5;N_5;SPC;
S_6;I_6;L_6;I_6;C_6;O_6;N_6;SPC;
S_7;I_7;L_7;I_7;C_7;O_7;N_7;SPC;
SPC;SPC;SPC;SPC;SPC;SPC;SPC;SPC;
SPC;SPC;SPC;SPC;SPC;SPC;SPC;SPC;
SPC;SPC;SPC;SPC;SPC;SPC;SPC;SPC;
*/

/*
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
I_3;I_3;I_3;I_3;I_3;I_3;I_3;I_3;
*/
}

