#define F_OUT (220000UL)
#define PR_OUT (16000000UL/F_OUT)
#define HI_OUT PR_OUT/2

long a,b;

void setup(void){
  Serial.begin(115200);
  pinMode(3, OUTPUT); // Output pin for OCR2B
  // fast manual PWM eg OCR2A = 63;OCR2B = 31; gives 50% 250kHz @16MHz sys
  TCCR2A = bit(COM2A1) | bit(COM2B1) | bit(WGM21) | bit(WGM20);
  TCCR2B = bit(WGM22) | bit(CS20);
  OCR2A = PR_OUT;
  OCR2B = HI_OUT;
  analogWrite(5,127);
  b=220;
  setF(b);
  a=0;
  delay(1000);
  Serial.println("Enter a frequency in kHz and press enter:");
}

void loop(void){
  int d;
  if(Serial.available()){
    d=Serial.read();
    if((d>='0')&&(d<='9')){
      a=a*10+d-'0';      
    }
    if(d==13){
      b=a;
      a=0;
      Serial.println(b);
      if(b<100){b=100;}
      if(b>250){b=250;}
      setF(b);
    }
  }
}

void setF(int f){ //in kHz
  unsigned long n,p;
  int r2a,r2b;
    p=16000UL/f;
    Serial.print(1000L*f);
    Serial.print("Hz => ");
    Serial.println(p);    
    r2a=p;
    r2b=r2a/2;
    OCR2A=r2a;
    OCR2B=r2b;
    f=16000UL/p;
    Serial.print(f);    
    Serial.println("kHz");
}