#define F_OUT (220000UL)
#define PR_OUT (16000000UL/F_OUT)
#define HI_OUT PR_OUT/2

long a,b;
#define STEPS 18

#define LED1 210
#define LED2 185
#define LED3 165

int f[STEPS]={LED1,0,LED1,0,LED1,0,LED2,0,LED2,0,LED2,0,LED3,0,LED3,0,LED3,0};
int t[STEPS]={100,100,100,100,100,500,100,100,100,100,100,500,100,100,100,100,100,500};

void setup(void){
  Serial.begin(115200);
  pinMode(3, OUTPUT); // Output pin for OCR2B
  // fast manual PWM eg OCR2A = 63;OCR2B = 31; gives 50% 250kHz @16MHz sys
  TCCR2A = bit(COM2A1) | bit(COM2B1) | bit(WGM21) | bit(WGM20);
  TCCR2B = bit(WGM22) | bit(CS20);
  OCR2A = PR_OUT;
  OCR2B = HI_OUT;
  analogWrite(5,127);
  setF(220);
}

void loop(void){
  int i;
  for(i=0;i<STEPS;i++){
    setF(f[i]);
    delay(t[i]);
  }
}

void setF(int f){ //in kHz
  unsigned long n,p;
  int r2a,r2b;
  if(f<100){
    OCR2A=255;
    OCR2B=0;
    Serial.println("OFF");
  }else{
    p=16000UL/f;
    Serial.print(1000L*f);
    Serial.print("Hz => ");
    Serial.println(p);    
    r2a=p;
    r2b=r2a/2;
    OCR2A=r2a;
    OCR2B=r2b;
    f=16000UL/p;
    Serial.print(f);    
    Serial.println("kHz");
  }
}