//TimerOne library from https://github.com/PaulStoffregen/TimerOne
#include <TimerOne.h>

//basic code to drive the LEDs in the MIDI Switch Matrix

//same pins as switches
//rows
byte rowPins[8]={2,3,4,5,6,7,8,9};
//columns
byte columnPins[8]={A0,A1,A2,A3,A4,A5,11,10};

byte LED[64]={
  1,0,0,0,0,0,0,0,
  0,1,0,0,0,0,0,0,
  0,0,1,0,0,0,0,0,
  0,0,0,1,0,0,0,0,
  0,0,0,0,1,0,0,0,
  0,0,0,0,0,1,0,0,
  0,0,0,0,0,0,1,0,
  0,0,0,0,0,0,0,1  
};

void setup() {
  int i;
  for(i=0;i<8;i++){   //set pin modes
    pinMode(rowPins[i],OUTPUT);
    pinMode(columnPins[i],INPUT);
    digitalWrite(columnPins[i],LOW);    //toggle drive with pinMode
  }
  Timer1.initialize(200);  //update rate= frame rate * 8 columns
  Timer1.attachInterrupt(LEDupdate); 
}

void loop() {
  //code here to update LED[64] array
}

void LEDupdate(void){   //timer ISR
  static byte col=0;
  byte i;
  for(i=0;i<8;i++){   //set column drivers off
    pinMode(columnPins[i],INPUT);      
  }
  for(i=0;i<8;i++){
    digitalWrite(rowPins[i],LED[col+i*8]);  //set row drivers
  } 
  pinMode(columnPins[col],OUTPUT);  //enable active column
  col=(col+1)&7;
}
