'*********************************
'Picaxe Data Logger
'28X1
'InfraRed input
'P Webb 10/11/2010
'Hope Valley SA
'Version 1.0
'Commercial use prohibited without authority.
'***********************************
setfreq m8
symbol outbyte = b0'LCD use
symbol rs = b1' Register Select for LCD
symbol messagenum = b2'Meesage number 
symbol nblcount = b3' nibblecount for LCD
symbol counter = b4'general counter      '(b4,b5)
'symbol spare = b5'
symbol Sample1 = w3'Word data sample      '(b6,b7)
symbol analogcounter = b8'counter for multi channels       '(b8,b9)
symbol Channels = b9 ' 0 to 3 analog channels
symbol memaddress = w5'current memory address for EEPROM   '(b10,b11)
symbol temp = w6 '(b12,b13) Temporary variable used in display data
symbol keynum = b14  'The number of the key from the IR remote
symbol scalefactor = b15 'To scale the reading
symbol LowCutout = w8 'not used (b16,b17)
symbol datadisp = w9 'the Data to display on the LCD(b18,b19)
symbol Logtime = w10 'The logging time- sample time in seconds '(b20,b21)
symbol loByte = B22'low byte of the 2 byte number
symbol HiByte = B23'high byte of the 2 byte number
symbol datadisp1 = w12' The data to dispaly on the LCD
symbol TimeAdjust = w13 'An offset to adjust the timer accuracy 
symbol latchout =1'Used to clock the LCD
symbol lcddata = 1'Data Byte for LCD
symbol lcdinst= 0'LCD instruction (for register select)
symbol delay = 50'InfraRed timeout millisecs for irin command
'**********************************
'Remote keycodes
'Keycode mapping varies with device = TV, VCR, CBL, DVD
'Some keycodes are the same, but many differ for the same button
'To edit variable items like logging time select the menu
'Press enter or OK to enter editing
'left or back clears digits.  Numbers 0 to 9 enter digits
'Ok or Enter to finish editing.

symbol Enter = 11
symbol Backspace = 52
symbol back = 23
symbol left = 52
symbol leftbtn = 117
symbol Up = 116
symbol Down = 117
symbol Right = 51
symbol Power = 21
symbol Chplus = 16
symbol Chminus = 17
symbol Volplus = 18
symbol Volminus = 19
symbol StopBtn = 24'94
symbol StopBtn2 = 74
symbol playBtn = 26'95
symbol Ok = 124
symbol exitBtn = 15
'*********
PowerReset:
'Start over
'*********
'read variables from Picaxe EEPROM - restored after power on
'*************CPU Registers are 48Bytes at addresses 80 to 127 peek x,y poke x,y
'*************CPU Registers are 48Bytes at addresses 192 to 255 peek x,y poke x,y
'*************EEPROM Registers are 256Bytes at addresses 0 to 255 read x,y write x,y
'LogTime
read 0,lobyte 'lo
read 1, hibyte 'hi
logtime = hibyte *256 +lobyte
if logtime = 0 then 
logtime = 60
end if
'*********
'LowcutOut 'future
read 2,lobyte 'lo
read 3, hibyte 'hi
Lowcutout = hibyte * 256 +lobyte
if Lowcutout = 0 then 
Lowcutout = 1
end if
'*********
read 4, scalefactor
if scalefactor = 0 then 
scalefactor = 1
end if
'*********
read 5, channels 
select case channels
	case 0 to 3
	else
	channels = 0 '1 Channel default
end select
'*********
'Timeadjust
read 6,lobyte 'lo
read 7, hibyte 'hi
TimeAdjust = hibyte * 256 +lobyte
if Timeadjust = 0 then 
Timeadjust = 4200
end if
'*********
temp = 34286+ Timeadjust ' change this to adjust clock accuracy
'Increase value to speed up (too slow), reduce to slow down (toofast)
settimer temp 'timer setting for 8MHz adjust if fast or slow

'********************************
I2cslave %10100000, i2cfast8, i2cword '24lc256 A0, A1, A2 all grounded
'Initialise I2C memory
'********************************
'Initialise LCD Display 16 * 2 lines 4 bit
rs = lcdinst
for counter = 0 to 5
	lookup counter, ($33,$32,$28,$0C,$01,$06), outbyte
	gosub lcdout
next counter
'*********************  'Startup message
messagenum = 17
gosub display1stline
pause 2000
messagenum = 0
'********************************
'This section checks the remote keycodes at start up
'messagenum = 29
'gosub display1stline
'datadisp = 0
'gosub display2ndlinemenu
'gosub remotekeycodes
messagenum = 0
'********************************
main:
'This is the menu routine
'Man menu scrollsaround with up/down or menu number
'Press Ok or enter to enter value editing mode
gosub display1stline
	select case messagenum
		'case 0 'Start Logging
		'case 1 'Upload Data
		'case 2 'Dummy data
		'case 3 'Clear Data
		case 4 'Log time secs
			datadisp = logtime
			gosub display2ndLinemenu
		case 5
			datadisp = LowCutOut
			gosub display2ndLinemenu
		case 6
			datadisp = scalefactor
			gosub display2ndLinemenu
		case 7
			datadisp = channels +1
			gosub display2ndLinemenu
		'case 8 'Calibrate ADC
		case 9 'Adjust timer
			datadisp = timeadjust
			gosub display2ndlinemenu
		'case 10 'remote keycode
		else 'clear 2nd line
			gosub clear2ndline
	end select	
	nokey:
	gosub ReadInfraRed
		if keynum = 199 then nokey
	select case keynum
		case 0 to 9
			messagenum = keynum
		case power
			goto PowerReset ' start all over if power button pressed
		case down, Chminus, volminus
			if messagenum =0 then
				messagenum = 15
			else
				messagenum = messagenum -1
			end if
		case Up, chplus, volplus
			if messagenum >14 then
				messagenum = 0
			else
				messagenum = messagenum + 1
			end if
		case Enter, Right, playbtn, OK,exitbtn
			select case messagenum 
				case 0 'start logging
					'memaddress =0
					'channels = 0,1,2,3
					messagenum = 25 ' Start at mem #
					gosub display1stline
					datadisp = memaddress
					gosub checkmemaddress '
					gosub edititem
					memaddress = datadisp
					gosub checkmemaddress
					'memaddress =0
					messagenum = 20
					gosub display1stline ' Logging
				
					gosub writesample
					messagenum = 21
				case 1 ' upload data
					memaddress = 0
					messagenum = 22
					gosub display1stline
					gosub readsample
					messagenum = 19
				case 2 ' dummy data
					memaddress = 0
					messagenum = 26
					gosub display1stline
					gosub writedummydata					
					messagenum = 27
				case 3 ' clear data
					memaddress = 0
					messagenum = 23
					gosub display1stline
					gosub clearalldata					
					messagenum = 24
				case 4 ' Log time
					datadisp = Logtime 'allocate variable to edit temp
					gosub edititem
					Logtime = datadisp 're-apply edit temp to the variable
					lobyte = Logtime & %11111111
					hibyte = logtime /256
					write 0, lobyte 
					write 1, hibyte
				case 5 'UVcutout
					datadisp = Lowcutout 'allocate variable to edit temp
					gosub edititem
					Lowcutout = datadisp 're-apply edit temp to the variable
					lobyte = Lowcutout & %11111111
					hibyte = Lowcutout /256
					write 2, lobyte 
					write 3, hibyte
				case 6 'Scalefactor
					datadisp = scalefactor
					gosub edititem
					scalefactor = datadisp
					write 4, scalefactor
				Case 7 'Channels
					datadisp = channels +1
					gosub edititem
					channels = datadisp -1
					select case channels
						case 0 to 3
						else
							channels = 0
					end select
					write 5, channels
				case 8 ' Calibrate analog inputs
					messagenum = 30									
					gosub display1stline
					gosub calibrateanalogs
					
				case 9 'TimeAdjust
					datadisp = Timeadjust
					gosub edititem
					Timeadjust = datadisp
					lobyte = Timeadjust & %11111111
					hibyte = Timeadjust /256
					write 6, lobyte 
					write 7, hibyte
					temp = 34286+ Timeadjust 'Adjust clock timer 
					settimer temp 
				case 10 'Remote codes
					messagenum = 29
					gosub display1stline
					datadisp = 0
					gosub display2ndlinemenu
					gosub remotekeycodes
			end select
	end select
	if messagenum >15 then 
		messagenum = 0
	end if
goto main
'*************************************
'Log data and write to the EEPROM I2C Chip
writesample:
do
	timer = 0
	for analogcounter = 0 to channels
		datadisp = 8' 1st line posn 8
		gosub printspot
		rs = lcddata
		outbyte = analogcounter +1 + $30
		gosub lcdout
		temp = 0
		for counter = 1 to 50
		readadc10 analogcounter ,Sample1 
		temp = temp + sample1
		next counter
		sample1 = temp/50' average 50 samples
		sample1 = sample1 * scalefactor
'*********************************** test 1 to 4 for subsequent readings
'sample1 = analogcounter + 1 *100 dummy line for testing channels
'*********************************** test 1 to 4 for subsequent readings
		lobyte= sample1 and %11111111 ' lo byte
		hibyte	 = sample1/256 'hi byte
		writei2c memaddress, (lobyte, hibyte)
		datadisp = sample1  'word
		gosub display2ndline
			pause 2000 ' to allow each data sample to be displayed
		memaddress= memaddress +2 ' increment mem address - hi-lo byte
	next analogcounter
	do until timer >= logtime
		gosub ReadInfraRed
		select case keynum
			case  enter, stopbtn, OK, exitbtn
				goto exitwritesample  'enter key pressed
		end select
		'*************
		datadisp = 10' 1st line posn 10
		gosub printspot
		rs = lcddata
		if logtime >= timer then
			datadisp1 = logtime - timer
			gosub display6bytes
		end if
	loop' until timer =>logtime
	if memaddress >32760 then goto exitwritesample
loop
exitwritesample:
return
'*******************************************************
'Read & Upload from EEPROM I2C Chip to the PC
readsample:
'Upload header info, Sample time, channels, scale factor
sertxd ("Sample secs:")'logtime
		sertxd (9)
		datadisp = logtime
		gosub transmit5bytes
		sertxd (13)
		sertxd (10)		
sertxd ("Channels:")
		sertxd (9)
		datadisp = channels +1
		gosub transmit5bytes
		sertxd (13)
		sertxd (10)
sertxd ("Scale Factor:")
		sertxd (9)
		datadisp = scalefactor
		gosub transmit5bytes		
		sertxd (13)
		sertxd (10)
sertxd ("Mem.")
		sertxd (9)
sertxd ("Ch.1")
		sertxd (9)
sertxd ("Ch.2")
		sertxd (9)
sertxd ("Ch.3")
		sertxd (9)
sertxd ("Ch.4")
		sertxd (13)
		sertxd (10)
readsample1:
	if memaddress <32000 then
		'sertxd ("Mem")
		datadisp = memaddress
		gosub transmit5bytes
		'sertxd (":")
		sertxd (9)
		'Transmit channel data
		select case channels
			case 0 ' 1 channel
				gosub getmemdatat5
				sertxd (13)
				sertxd (10)
				memaddress = memaddress +2
				
			case 1 '2 channels
				gosub getmemdataT5
				sertxd (9)
				memaddress = memaddress +2

				gosub getmemdataT5
				sertxd (13)
				sertxd (10)
				memaddress = memaddress +2

			case 2
				gosub getmemdataT5
				sertxd (9)
				memaddress = memaddress +2

				gosub getmemdataT5
				sertxd (9)
				memaddress = memaddress +2

				gosub getmemdataT5
				sertxd (13)
				sertxd (10)
				memaddress = memaddress +2
			case 3
				gosub getmemdataT5
				sertxd (9)
				memaddress = memaddress +2

				gosub getmemdataT5
				sertxd (9)
				memaddress = memaddress +2

				gosub getmemdataT5
				sertxd (9)
				memaddress = memaddress +2

				gosub getmemdataT5
				sertxd (13)
				sertxd (10)
				memaddress = memaddress +2
		end select
	end if
	gosub ReadInfraRed
	select case keynum
		case enter, stopbtn, OK,exitbtn
			 goto exitreadsample
	end select
goto readsample1
exitreadsample:
return
'**************************************
getmemdataT5:
readi2c memaddress, (lobyte,hibyte) 
		sample1 = hibyte *256 + lobyte
		datadisp = sample1
		gosub display2ndline
		gosub transmit5bytes
return
'**************************************
clearalldata:
datadisp = 0
memaddress = 0
do
	writei2c memaddress, (0,0,0,0,0,0,0,0,0,0)
	memaddress = memaddress + 10'10
	gosub display2ndline
	gosub ReadInfraRed
	select case keynum
		case enter, stopbtn, OK,exitbtn
			goto exitclearalldata 
	end select
loop until memaddress >32717
exitclearalldata:
return
'**************************************
'writes number 9 to all lo byte memory address
writedummydata:
datadisp = 0
memaddress = 0
do
	writei2c memaddress, (9,0,9,0,9,0,9,0,9,0)
	memaddress = memaddress + 10
	datadisp = 9
	gosub display2ndline
	gosub ReadInfraRed
	select case keynum 
		case enter,stopbtn,OK,exitbtn
			goto  exitwritedummydata
	end select
loop until memaddress >32717
exitwritedummydata:
return
'**************************************
'LCD Display routine
lcdout:
for nblcount = 1 to 2
	high latchout ' set latch high
	select case RS
		case = 1 ' data
			high 0
		case = 0 ' instruction
			low 0
	end select
	temp = outbyte & 16
	if temp = 16 then ' bit 4
		high 2
	else
		low 2
	end if
	temp = outbyte & 32 ' bit 5
	if temp = 32 then
		high 3
	else
		low 3
	end if
	temp = outbyte & 64 ' bit 6
	if temp = 64 then
		high 4
	else
		low 4
	end if
	temp = outbyte & 128 ' bit 7
	if temp = 128 then
		high 5
	else
		low 5
	end if
	low latchout ' Clock the display
	'pause 4
	outbyte = outbyte *16  'Shift outbyte Left to get next nibble
	next nblcount
return

'*************************************************************
'Display data on LCD
Display1stline:  'this is the message or the menu number
	rs = lcdinst
	outbyte = $80  ' first line
	gosub lcdout
	gosub displaymessage

return
clear2ndline:
	rs = lcdinst  'Clear SECOND LINE
	outbyte = $C0  'start at second line
	gosub lcdout
	rs = lcddata
	for counter = 0 to 14
		lookup counter , ("                 "), outbyte
	gosub lcdout		
	next counter

return

display2ndline:'	Displays mem address & data
	rs = lcdinst  'SECOND LINE
	outbyte = $C0
	gosub lcdout
	rs = lcddata
	'display memory location
	datadisp1 = memaddress
	gosub display6bytes
	'display data
	datadisp1 = datadisp 
	gosub display6bytes
return
'***************************
display6bytes:
for counter = 1 to 6 
		select case counter
			case 1
				temp = datadisp1/10000  ' 10000's
			case 2
				temp = datadisp1/1000  '1000's
				temp = temp//10
			case 3
				temp = datadisp1/100  '100's
				temp = temp //10
			case 4
				temp = datadisp1/10   '10's
				temp = temp//10
			case 5
				temp = datadisp1//10  ' 1's
			case 6
				temp = 32- $30' " " space			
	end select
		outbyte = temp + $30
		gosub lcdout
	next counter
return
'*************************
'the data to be displayed is held in variable datadisp
display2ndLineMenu:'displays just datadisp
	rs = lcdinst  'SECOND LINE
	outbyte = $C0
	gosub lcdout
	rs = lcddata
	for counter = 1 to 5
		select case counter
			case 1
				temp = datadisp/10000  ' 10000's
			case 2
				temp = datadisp/1000  ' 1000's
				temp = temp//10
			case 3
				temp = datadisp/100  ' 100's
				temp = temp//10
			case 4
				temp = datadisp/10  '10's
				temp = temp//10
			case 5
				temp = datadisp//10  '1s
				temp = temp //10
'			case 6
'				temp = 109-$30' "m"
'			case 7
'				temp = 118-$30 '"v"
		end select
		outbyte = temp + $30
		gosub lcdout
	next counter

return
'***********************
'********************************
edititem: 
'Edits the variable and returns a new value
rs = lcdinst
	outbyte = $0F 'Cursor blink
	gosub lcdout
do
	gosub display2ndLinemenu
	temp = datadisp  'save original
nokeyedit:
	gosub ReadInfraRed
	if keynum = 199 then nokeyedit
	select case keynum
		case 0 to 9
			'if datadisp <9999 then
			datadisp = datadisp //10000 *10  + keynum
			if datadisp <temp then 'overflow
				datadisp = 65535
		 		temp = datadisp
			end if
		case Enter, Right,OK,exitbtn
			goto exitedititem
		case Left, leftbtn, chminus, volminus, Back 
			datadisp = datadisp /10
			temp= datadisp
	end select
loop
exitedititem:
rs = lcdinst
	outbyte = $0C ' blink off
	gosub lcdout
return

'*********************************
transmit5bytes:
'sends a number to the serial port, one digit at a time
		temp = datadisp/10000 + $30  ' 10000's
		sertxd (temp)
		
		temp = datadisp/1000  '1000's
		temp = temp//10 + $30
		sertxd (temp)
		
		temp = datadisp/100  '100's
		temp = temp //10 + $30
		sertxd (temp)
	
		temp = datadisp/10   '10's
		temp = temp//10 + $30
		sertxd (temp)
	
		temp = datadisp//10 + $30 ' 1's
		sertxd (temp)
return

'***************************************
'Set the print position at a specific character position on first line
'Datadisp variable holds the position number
printspot:
rs = lcdinst
outbyte = $80 + datadisp' first line plus offsett
gosub lcdout
return
'*****************************************
'Displays the message selected by messagenum
displaymessage:
rs = lcddata
	for counter = 0 to 15
		select case messagenum
			case 0 ' write
				lookup counter , ("0.Start Logging."), outbyte
			case 1 ' 
				lookup counter , ("1.Upload data.  "), outbyte
			case 2 ' spare
				lookup counter , ("2.Dummy Data.   "), outbyte
			case 3 ' 
				lookup counter , ("3.Clear Data.   "), outbyte
			case 4' 
				lookup counter , ("4.Log time:Secs "), outbyte
			case 5' 
				lookup counter , ("5.LowCutout:Rdg "), outbyte
			case 6' 
				lookup counter , ("6.Scale Factor: "), outbyte
			case 7' 
				lookup counter , ("7.Channels.     "), outbyte
			case 8  
				lookup counter , ("8.Calibrate ADC."), outbyte
			case 9  
				lookup counter , ("9.Adjust time. "), outbyte
			case 10'
				lookup counter , ("10.Remote Keys."), outbyte
			case 11
				lookup counter , ("11.Spare Menu.  "), outbyte
			case 12
				lookup counter , ("12.Spare Menu.  "), outbyte
			case 13
				lookup counter , ("13.Spare Menu.  "), outbyte
			case 14
				lookup counter , ("14.Spare Menu.  "), outbyte
			case 15' 
				lookup counter , ("15.Spare Menu.  "), outbyte
			case 16' 
				lookup counter , ("* For more      "), outbyte
			case 17' 
				lookup counter , ("Welcome back.   "), outbyte
			case 19' 
				lookup counter , ("Exit Upload:    "), outbyte
			case 20' 
				lookup counter , ("Logging:        "), outbyte
			case 21' 
				lookup counter , ("Exit logging:   "), outbyte
			case 22' 
				lookup counter , ("Uploading:      "), outbyte
			case 23' 
				lookup counter , ("Clearing Data:  "), outbyte
			case 24' 
				lookup counter , ("Data Cleared:   "), outbyte
			case 25
				lookup counter , ("Start at Memory:"), outbyte
			case 26
				lookup counter , ("Writing 9's:    "), outbyte
			case 27
				lookup counter , ("Exit Dummy Data:"), outbyte
			case 28
				lookup counter , ("Error ClearData:"), outbyte
			case 29
				lookup counter , ("Remote Keycode: "), outbyte
			case 30
				lookup counter , ("Calib Chnl:     "), outbyte
			case 31
				lookup counter , ("Adjust Timer:   "), outbyte
				
				
		end select
		gosub lcdout
	next counter
return
'******************************
checkmemaddress:
'Calculates an approriate memmory address to start depending on number of channels
	select case channels
		case 0 ' 1 ch
			temp =memaddress//2
			if  temp = 0 then 'Ok
			else
				memaddress = memaddress/2 *2
			end if
		case 1
			temp = memaddress//4
			if temp = 0 then 'Ok
			else
				memaddress = memaddress/4 *4
			end if
		case 2
			temp = memaddress//6
				if temp = 0 then 'Ok
			else
				memaddress = memaddress/6 *6
			end if
		case 3
			temp = memaddress//8
			if temp = 0 then 'Ok
			else
				memaddress = memaddress/8 *8
			end if
	end select
return

'*******************************
ReadInfraRed:
'Procedure reads the keycodes from the InfrRed remote
'and returns the value in variable keynum
if keynum <>199 then
	pause 125 ' repeat wait key
end if
keynum = 199
irin [delay, exitkey],0, keynum ' read IR if no key then exit after delay
select case keynum ' change keynumbers 0 to 9
	case 0 to 8
		keynum = keynum +1
	case 9
		keynum = 0

		
end select
exitkey:
return
'******************************
remotekeycodes:
' Provides a feature to check the InfrRed codes associated with a button on the remote
do
irin 0, keynum 'get a code
datadisp = keynum
gosub display2ndLinemenu 'display the code
select case keynum 'exit sub routine if stop or enter pressed
	case Stopbtn, stopbtn2, Enter, OK,Exitbtn
		pause 2500 ' wait for a bit to see the button code pressed then exit
		goto exitkeycodes
end select
loop
exitkeycodes:
return
'*****************************
calibrateanalogs:
'Provides the ability to select a channel and calibrate the reading to the actual input 
'voltage as measured by an independent voltmeter
'reading can be scaled by setting the scalefactor
'input voltage to the ADC channel cannot exceed 5.0V without damage to Picaxe
analogcounter = 0 'set for channel 1
do
	datadisp = 12 'print channel number at position 12
	gosub printspot
	rs = lcddata
	outbyte = analogcounter + 1 + $30 ' prints the channel number - remember 0 = channel 1
	gosub lcdout
	temp = 0 'reset the temporary variable
	for counter = 1 to 50 ' take 50 samples
		readadc10 analogcounter ,Sample1 
		temp = temp + sample1 'accumulate the samples
	next counter
	sample1 = temp/50 'average the samples
	sample1 = sample1 * scalefactor 'apply scalefactor
	datadisp = sample1  
	gosub display2ndLinemenu 'display the analog
	gosub ReadInfraRed 'check for key inputs
	select case keynum 'analyse the key presses
		case chplus, volplus, Up 'go up to the next analog input
			analogcounter = analogcounter + 1
			if analogcounter >3 then 
				analogcounter = 0
			end if
		case chminus, volminus, Down 'got down to the previous analog input
			if analogcounter  = 0 then 
				analogcounter = 3
			else
				analogcounter = analogcounter -1
			end if
		case Enter, OK ,exitbtn,stopbtn,stopbtn2'exit this sub routine
			goto exitcalib
	end select
loop
exitcalib:
return