; Minimalistic 1 digit display with RGB led
;--------------------------------------------
; 1dgtRGB.ASM: Pic10F20x + RGBLED(Common Anode) = 1 dgt display
; BENABADJI Salim - ORAN - May 05th, 2020
;--------------------------------------------

;controller	equ	10F200
controller	equ	10F202
;controller	equ	10F204
;controller	equ	10F206
;controller	equ	10F220
;controller	equ	10F222

	if	controller == 10F200
		List P = 10F200
#include <P10F200.inc>
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC
	endif
	
	if	controller == 10F202
		List P = 10F202
#include <P10F202.inc>
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC
	endif

	if	controller == 10F204
		List P = 10F204
#include <P10F204.inc>
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC
	endif
	
	if	controller == 10F206
		List P = 10F206
#include <P10F206.inc>
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _IntRC_OSC
	endif

	if	controller == 10F220
		List P = 10F220
#include <P10F220.inc>
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _MCPU_OFF & _IOFSCS_4MHZ
	endif
	
	if	controller == 10F222
		List P = 10F222
#include <P10F222.inc>
	__CONFIG _MCLRE_OFF & _CP_OFF & _WDT_OFF & _MCPU_OFF & _IOFSCS_4MHZ
	endif

;----------------------------- define hardware -------------------------------
	
;RLED	EQU		0	 ; assign red  LED to output GP0
;GLED	EQU		1	 ; assign green LED to output GP1
;BLED	EQU		2	 ; assign blue LED to output GP2 

#define		BTN1	GPIO, 3 ; pushbutton BTN1 to input GP3

;----------------------------- define constants ------------------------------

	CONSTANT  CBLOCK16 = 0x10 ; 16 bytes RAM for PIC10F200/204/220
	;CONSTANT  CBLOCK23 = 0x09 ; 23 bytes RAM for PIC10F222
	CONSTANT  CBLOCK24 = 0x08 ; 24 bytes RAM for PIC10F202/206

;------------------------------ define variables -----------------------------

	;CBLOCK	CBLOCK16	; if PIC10F200	
	CBLOCK	CBLOCK24	; if PIC10F202	

;delay
	;cpt1, cpt2, cpt3	; counter for delays
;digit
	dgt1				; counter for 1 digit
;BTN1
	BP1counter			; = 0, 1, ..., 49 (at 0, sense BP1)
;pwmcolors
	ptrColor			; pointer to LUT RGBseuil
	pwmcounter			; = 0, 1, ..., 19 (PWM divided in 20 segments)
	pwmRcount			; nbr of segments for RED led
	pwmGcount			; nbr of segments for GREEN led
	pwmBcount			; nbr of segments for BLUE led
;others
	maskLEDs		; <0>=1 => turn off RED led
					; <1>=1 => turn off GREEN led
					; <2>=1 => turn off BLUE led
					
	bnFlags			; <0>=1 => look BP1
					; <1>=1 => TMR0 = 0 (i.e., sense TMR0 overflow)
					; <2>=1 => 
	ENDC
;9 bytes used

;--------------------------------- define bits -------------------------------

#define	  bitRED	 maskLEDs, 0 ; <0>=1 => turn off RED led
#define	  bitGREEN	 maskLEDs, 1 ; <1>=1 => turn off GREEN led
#define	  bitBLUE	 maskLEDs, 2 ; <2>=1 => turn off BLUE led

#define	  lookBP1	 bnFlags, 0 ; <0>=1 => allow sensing BP1
#define	  TMR0ovf	 bnFlags, 1 ; <1>=1 => TMR0 = 0 (sense TMR0 overflow)

;////////////////////////////////////////////////////////////////////////
;								MACROS
;////////////////////////////////////////////////////////////////////////

;------------------------------------------------------------------------
; if (file == 0) goto jmpOk ;
;------------------------------------------------------------------------
SIregNUL  macro file, jmpOk
	movf	file, w
	btfsc	STATUS, Z	; file <> 0 ?
	goto    jmpOk		; no, i.e. file = 0
	endm
;------------------------------------------------------------------------
; if (file <> 0) goto jmpOk ;
;------------------------------------------------------------------------
SIregNOTNUL  macro file, jmpOk
	movf	file, w
	btfss	STATUS, Z	; file == 0 ?
	goto    jmpOk		; no, i.e. file <> 0
	endm
;------------------------------------------------------------------------
; if (file < val) goto jmpOk ;
;------------------------------------------------------------------------
SIregLTval8b	macro	file, val, jmpOk
	movlw	val
	subwf	file, w		; w = file - val
	btfss	STATUS, C
	goto	jmpOk		; yes
	endm
;------------------------------------------------------------------------
; if (regA < regB) goto jmpOk ;
;------------------------------------------------------------------------
SIregaLTregb8b	macro	regA, regB, jmpOk
	movf	regB, w
	subwf	regA, w		; w = regA - regB
	btfss	STATUS, C	; w >= 0
	goto	jmpOk		; no
	endm

;/////////////////////////////////////////////////////////////////////////////
;	MAIN PROGRAM
;/////////////////////////////////////////////////////////////////////////////
	ORG		0			; address start of program memory
	goto	Setup
;/////////////////////////////////////////////////////////////////////////////

#include "PWMLEDS.INC"	; first include (contains LUT RGBseuil)

;;------------------------------------------------------------------------
;; Clear all bytes in RAM = [0x08 to 0x1F] = 24 bytes for PIC10F202
;;------------------------------------------------------------------------
;clearRAM
;	movlw	CBLOCK24	; initialize pointer...
;	movwf	FSR			; ... to RAM (indirect addressing)
;init1
;	clrf	INDF		; clear 1 byte
;	incf	FSR, F		; increment pointer
;	btfss	FSR, 5		; >= 0x20 ?
;	goto	init1		; no
;	retlw	0
	
;-----------------------------------------------------------------------------
;sense pushbutton BTN1 (routine duration = 10s, or 19 s)
;-----------------------------------------------------------------------------
senseBTN1 ; called each 10 ms
	incf	BP1counter, F
	SIregLTval8b	BP1counter, .50, rtnBTN1

;sense BP1 each 50*10ms = 500ms
	clrf	BP1counter

	btfss	lookBP1		; =1 => allow sensing BP1
	goto	firstBTN1high	; no
	
	btfsc	BTN1		; BTN1 pushed ?
	goto	rtnBTN1		; no
BP1pushed
	incf	dgt1, F
	SIregLTval8b	dgt1, .10, rtnBTN1
	clrf	dgt1
rtnBTN1
	retlw	0

firstBTN1high
	btfsc	BTN1		; BTN1 low ?
	bsf		lookBP1		; first BP1 high tracked, OK !
	retlw	0

;=============================================================================
Setup		        	; Beginning of the program

;trim the internal oscillator accuracy to 1% at 4 MHz
	;movlw	24h			; particular calibration value for my PIC10F202 sample
	movwf	OSCCAL		; trim the internal oscillator accuracy to 1% at 4 MHz
	
;cfg OPTION
	movlw 	b'00000000'	; wake-up, pull-up, <5>=0:use GP2, not TOCKI
	OPTION				; TMR0 prescaler=1:2 => TMR0 overflow = 512 s

;cfg GPIO
	movlw	b'11111000'	; (GP2,GP1,GP0) outputs
	TRIS	GPIO
	clrf	GPIO		; all outputs LOW
	comf	GPIO, F		; all outputs HIGH, to light off RGB LED (Common Anode)

	if	controller == 10F204
		bcf	CMCON0, CMPON	;CMCON0<3>=CMPON=0 => comparator OFF
	endif
	
	if	controller == 10F206
		bcf	CMCON0, CMPON	;CMCON0<3>=CMPON=0 => comparator OFF
	endif

	if	controller == 10F220
		clrf	ADCON0		; AN0, AN1 digitals, ADC off
	endif
	
	if	controller == 10F222
		clrf	ADCON0		; AN0, AN1 digitals, ADC off
	endif

;initialize
	clrf	dgt1
	clrf	BP1counter
	clrf	pwmRcount
	clrf	pwmGcount
	clrf	pwmBcount
	clrf	bnFlags
	clrf	maskLEDs
	comf	maskLEDs, F

endlessLoop ;------------------------------------------
;waitTMR0timeout
retard
	SIregLTval8b	TMR0, .253, retard ; if (TMR0 < 253) goto retard

;TMR0 >= 253, assume overflow (each 512 s)
	call	majINT

;each 10ms, call senseBTN1
	SIregNOTNUL	pwmcounter, endlessLoop ; if (pwmcounter <> 0) goto endlessLoop
	call	senseBTN1
	
	goto	endlessLoop

;-----------------------------------------------------------------------------
	END
