; PWMLEDS.INC:
;Setup TMR0 overflow (say 0.5 ms).
;At each TMR0 overflow: 
;	Add 1 to counter pwmcounter.
;	When this counter reaches 20, roll it back to 0 (and turn on all LEDs).
;	(there is no flicker, with a periode of 20 * 0.5 = 10 ms).
;	For each LED: 
;	IF (counter >= PWM intensity), turn off this LED.
;
;20 x 20 x 20 = 8000 colors.

;------------------------------------------------------------------------
; LUT for PWM intensity [0,1,...,20] for each LED, to mix a new color
;------------------------------------------------------------------------
RGBseuil	addwf PCL, f	; LUT resistor color code
	DT	  .0,  .0,  .0		; 0: black
	DT	  .5,  .0,  .1	;;;;; 1: brown
	DT	 .20,  .0,  .0		; 2: red
	DT	  .5,  .1,  .0	;;;;; 3: orange
	DT	 .20, .20,  .0		; 4: yellow
	DT	  .0, .20,  .0		; 5: green
	DT	  .0,  .0, .20		; 6: blue
	DT	 .20,  .0, .20		; 7: purple
	DT	  .1,  .1,  .1		; 8: grey
	DT	 .20, .20, .20		; 9: white

;------------------------------------------------------------------------
; majINT (routine duration = 27s, or 54 s)
;------------------------------------------------------------------------
majINT ; called each 512 s
	incf    pwmcounter, F
	SIregLTval8b	pwmcounter, .20, tstRled
	CLRF	pwmcounter
	clrf    maskLEDs		; turn on all LEDs

	MOVF	dgt1, w		; prepare
	ADDWF	dgt1, W		; W = 3 * dgt1
	ADDWF	dgt1, W		; to point LUT
	MOVWF	ptrColor	; store pointer

	CALL	RGBseuil	; pick RED color
	MOVWF	pwmRcount	; store it

	incf	ptrColor, F
	MOVF	ptrColor, W
	CALL	RGBseuil	; pick GREEN color
	MOVWF	pwmGcount	; store it

	incf	ptrColor, F
	MOVF	ptrColor, W
	CALL	RGBseuil	; pick BLUE color
	MOVWF	pwmBcount	; store it

tstRled	
	SIregaLTregb8b	pwmcounter, pwmRcount, tstGled
	bsf     bitRED		; turn off RED led
tstGled
	SIregaLTregb8b	pwmcounter, pwmGcount, tstBled
	bsf     bitGREEN	; turn off GREEN led
tstBled
	SIregaLTregb8b	pwmcounter, pwmBcount, tstfini
	bsf     bitBLUE		; turn off BLUE led

tstfini
	movf    maskLEDs, W		; get mask LED bits
	movwf   GPIO			; update GPIO
	RETLW	0
