// control for digital PSU:
// all are raw digital
// 3 parameters to control:
// relay output (R0/R1)
// voltage set V0-V256 (257 step pot)
// current set I0-I256 (as above)
// 2 parameters to receive
// V adc U0-U1023
// I adc J0-J1023
// V supply adc S0-S1023
// each on a line by itself

#define DIGIPOT_CS 4
#define DIGIPOT_MOSI 11
#define DIGIPOT_SCK 13
#define NEG_PWM 3
#define VSENSE A1
#define ISENSE A0
#define SUPPLY_SENSE A2
#define RLY_CTL 5

#define OVERSAMPLE 32

long a,n;
unsigned long t;
#define TMOUT 200

void setup() {
  analogReference(EXTERNAL);    //connected to 3.3V rail in hardware
  Serial.begin(115200);
  delay(200);                 //let boost stabilise
  digipot_init();             //I is chan 0, V is chan 1
  digipot_set(1,0);           //set to 0
  digipot_set(0,0);
  digitalWrite(RLY_CTL,LOW);
  pinMode(RLY_CTL,OUTPUT);
  t=millis();
}

void loop() {
  int d;
  d=parseToken(&Serial,&n);
  if(d){
    //Serial.write(d);Serial.write(':');Serial.println(n);
    if(d=='V'){
      if((n>=0)&&(n<=256)){
        digipot_set(1,n);        
        //Serial.print("Volts set to:");Serial.println(n);
      }      
    }
    if(d=='I'){
      if((n>=0)&&(n<=256)){
        digipot_set(0,n);        
        //Serial.print("Current set to:");Serial.println(n);
      }      
    }
    if(d=='R'){
      if(n==0){
        //Serial.println("Relay off");
        digitalWrite(RLY_CTL,LOW);
      }
      if(n==1){
        //Serial.println("Relay on");
        digitalWrite(RLY_CTL,HIGH);        
      }
    }
  }
  if((millis()-t)>TMOUT){
    t=t+TMOUT;
    Serial.print("J");
    Serial.println(getI());
    Serial.print("U");
    Serial.println(getV());
    Serial.print("S");
    Serial.println(getS());
  }
}

int getI(){
  int i;
  long n=0;
  for(i=0;i<OVERSAMPLE;i++){
    n=n+analogRead(ISENSE);
    delay(1);
  }
  return n/OVERSAMPLE;
}


int getV(){
  int i;
  long n=0;
  for(i=0;i<OVERSAMPLE;i++){
    n=n+analogRead(VSENSE);
    delay(1);
  }
  return n/OVERSAMPLE;
}

int getS(){
  int i;
  long n=0;
  for(i=0;i<OVERSAMPLE;i++){
    n=n+analogRead(SUPPLY_SENSE);
    delay(1);
  }
  return n/OVERSAMPLE;
}

void digipot_init(){
  digitalWrite(DIGIPOT_CS,HIGH);
  digitalWrite(DIGIPOT_MOSI,LOW);
  digitalWrite(DIGIPOT_SCK,LOW);  
  pinMode(DIGIPOT_CS,OUTPUT);
  pinMode(DIGIPOT_MOSI,OUTPUT);
  pinMode(DIGIPOT_SCK,OUTPUT);
}

void digipot_set(char chan, int val){   //chan is 0(A) or 1(B), value is 0-256 (inclusive)
  int d1=0;
  int d2=0;
  //16bit data is 000a00dddddddddd (4bit address is 0 or 1, write command is 00, data is 10bits
  if(chan){d1=16;}
  if(val>255){d1=d1+1;}
  d2=val&255;
  digitalWrite(DIGIPOT_CS,LOW);
  shiftOut(DIGIPOT_MOSI,DIGIPOT_SCK,MSBFIRST,d1);
  shiftOut(DIGIPOT_MOSI,DIGIPOT_SCK,MSBFIRST,d2);
  digitalWrite(DIGIPOT_CS,HIGH);
  //Serial.print(d1);
  //Serial.write(' ');
  //Serial.println(d2);
}

int parseToken(Stream* s, long* n){ //scan stream and if number entered, returns char prefix (eg U,J)
  static long p=0;
  static int sign=1;
  static char valid=0;    //only return if something has been entered
  static char prefix=0;   //prefix
  int retval=0;
  int d;
  while(s->available()){
   d=s->read();
   if(d=='-'){  
    if(p==0){sign=-1;}      //negative if - first character   
   }else if((d>='0')&&(d<='9')){    //add digit
    p=p*10+d-'0';
    valid=1;
   }else if((d==13)||(d==10)){
     if(valid){
       *n=p*sign;
       retval=prefix;       
     }
     //clear everything if CR/LF received
     p=0;
     sign=1;
     valid=0;
     prefix=0;
   }else if((d>='A')&&(d<='Z')){
     prefix=d;
   }else{
     //clear everything if anything else received
     p=0;
     sign=1;
     valid=0;    
   }
  }
  return retval;
}
