//SSD1306/SH1106 OLED implementation for 16F1455

#include "oled.h"
#include "softi2c.h"

const char bitdouble[]={0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255};     //double bits

void OLEDsendCommand(unsigned char c){
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x80); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDsendData(unsigned char c){     //not used only does a single byte
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x40); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDinit(void){
    __delay_ms(200);        //startup delay for display
    OLEDsendCommand(0x20);  //set addressing mode
    OLEDsendCommand(0x02);  //set page addressing mode (SH1106 only supports page mode)
    OLEDsendCommand(0x8D);  //Charge pump setting
    OLEDsendCommand(0x14);  //Enable Charge pump
    OLEDsendCommand(0xA1);  //column reverse
    //OLEDsendCommand(0xA0);  //column normal
    OLEDsendCommand(0xC8);  //row reverse
    //OLEDsendCommand(0xC0);  //row normal
    OLEDsendCommand(0xAF);  //display on
    OLEDsetcontrast(0x7F);  //contrast =0x7F (same as power on default)
    OLEDclear(0);
}

void OLEDclear(char c){
    unsigned char i,j;
    for(i=0;i<8;i++){
        OLEDsendCommand(0xB0+i); //cycle through pages
        OLEDsendCommand(OLED_X_OFFSET);   //column=0 (lower nybble)     
        OLEDsendCommand(0x10);   //column=0 (upper nybble)
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x40); //write data
        for(j=0;j<128;j++){
            I2Cbyte(c);
        }
        I2Cstop();
    }
}

void OLEDsetpage(unsigned char p){
    //p=7-p;      //flipped
    OLEDsendCommand(0xB0 + (p&7));      //set page address    
}

void OLEDsetcolumn(unsigned char c){
    //c=127-c;     //flipped
    c=c+OLED_X_OFFSET;
    OLEDsendCommand(0x00 + (c & 0x0F));  //set column lower address
    OLEDsendCommand(0x10 + ((c>>4)&0x0F));   //set column higher address    
}

void OLEDchar(const char c){
    int i,j;
    if(c<32){return;}
    if(c>127){return;}
    i=(((int)c)-32)*6;
    I2Cstart();
    I2Cbyte(OLED_ADDRESS);  //write
    I2Cbyte(0x40);          //write data
    for(j=i;j<i+6;j++){     //6 font columns
        I2Cbyte(font[j]);
    }
    I2Cstop();
}

void OLEDcharINV(const char c){
    int i,j;
    if(c<32){return;}
    if(c>127){return;}
    i=(((int)c)-32)*6;
    I2Cstart();
    I2Cbyte(OLED_ADDRESS);  //write
    I2Cbyte(0x40);          //write data
    for(j=i;j<i+6;j++){     //6 font columns
        I2Cbyte(font[j]^0xFF);
    }
    I2Cstop();
}

void OLEDchararray(char* c){
    while(*c){
        OLEDchar(*c++);
    }
}

void OLEDsetcontrast(unsigned char c){ //0-255
    OLEDsendCommand(0x81);
    OLEDsendCommand(c);    
}

char OLED2char(const char c, char x, char y, unsigned const char* f){    //double size
    unsigned int c0=f[2];
    if(c<c0){return 0;}
    if(c>(c0+f[3])){return 0;}
    unsigned int w=f[0];
    unsigned int h=f[1]>>3; //number of 8-bit rows
    unsigned int p=4+(c-c0)*w*h;
    char i,j;
    for(i=0;i<h;i++){
        OLEDsetpage(y+i);
        OLEDsetcolumn(x);
        I2Cstart();
        I2Cbyte(OLED_ADDRESS);  //write
        I2Cbyte(0x40);          //write data
        for(j=0;j<w;j++){
            I2Cbyte(f[p++]);            
        }
        I2Cstop();
    }
    return w;    
}

void OLED2chararray(const char* c, char x, char y, unsigned const char* f){    //double size
    while(*c){
        x=x+OLED2char(*c++,x,y,f);
    }
}

char OLED2char2(char c, char x, char y, unsigned const char* f){
    char t;
    unsigned int c0=f[2];
    if(c<c0){return 0;}
    if(c>(c0+f[3])){return 0;}
    unsigned int w=f[0];
    unsigned int h=f[1]>>3; //number of 8-bit rows
    unsigned int p=4+(c-c0)*w*h;
    char i,j;
    for(i=0;i<h;i++){
        OLEDsetpage(y+i*2);
        OLEDsetcolumn(x);
        I2Cstart();
        I2Cbyte(OLED_ADDRESS);  //write
        I2Cbyte(0x40);          //write data
        for(j=0;j<w;j++){
            t=bitdouble[(f[p++]>>0)&0xF];
            I2Cbyte(t);            
            I2Cbyte(t);            
        }
        p=p-w;
        I2Cstop();
        OLEDsetpage(y+i*2+1);
        OLEDsetcolumn(x);
        I2Cstart();
        I2Cbyte(OLED_ADDRESS);  //write
        I2Cbyte(0x40);          //write data
        for(j=0;j<w;j++){
            t=bitdouble[(f[p++]>>4)&0xF];
            I2Cbyte(t);            
            I2Cbyte(t);            
        }
        I2Cstop();
        
    }
    return w+w;    
}
