//Soft I2C implementation for 16F1455

#ifndef PIC16F1455_SOFTI2C_H
#define PIC16F1455_SOFTI2C_H
#include <xc.h>

// IO pinouts Revs B and C PCB (pins 6 and 10 swapped from rev A):
//  2   RA5 S1
//  3   RA4 S2
//  5   RC5 TCOPWM  (PWM1)
//  6   RC4 SDA(bitbang)
//  7   RC3 TSENSE  (AN7)
//  8   RC6 BMPWM   (PWM2)
//  9   RC7 ISENSE  (AN9)
//  10  RB7 S3
//  11  RB6 SCL(bitbang)
//  12  RB5 VOUTSENSE   (AN11)
//  13  RB4 VBATSENSE   (AN10)
//  14  RC2 VINSENSE    (AN6)

//pin primitives
//ANSEL set in ioinit

#define SDAHI {TRISCbits.TRISC4=1;}
#define SDALO {TRISCbits.TRISC4=0;}

#define SCLHI {TRISBbits.TRISB6=1;}
#define SCLLO {TRISBbits.TRISB6=0;}

#define I2CSETLAT {LATB6=0;LATC4=0;}

//functions
//use I2Cstop as init
void I2Cbit(unsigned char n);
void I2Cbyte(unsigned char n);
void I2Cstart(void);
void I2Cstop(void);

#endif  //PIC16F1455_SOFTI2C_H

