//SSD1306/SH1106 OLED implementation for 16F1455

#ifndef OLED_H
#define OLED_H
#include <xc.h>
#include "softi2c.h"
#include "font.h"

#define OLED_ADDRESS 0x78   //8bit write address, read address is +1
//#define OLED_ADDRESS 0x7A   //8bit write address, read address is +1

//for startup delay
#define _XTAL_FREQ 2000000

#define OLED_X_OFFSET 2
#define OLED_BIG_PIXEL_WIDTH 7

void OLEDsendCommand(unsigned char c);
void OLEDsendData(unsigned char c);
void OLEDclear(char c); //set all bytes to c (0 for blank and 0xFF for all on)
void OLEDinit(void);
void OLEDsetpage(unsigned char p);
void OLEDsetcolumn(unsigned char c);
void OLEDchar(const char c);
void OLEDcharINV(const char c);
void OLEDchararray(char* c);
void OLEDsetcontrast(unsigned char c);
char OLED2char(const char c, char x, char y, unsigned const char* f);
void OLED2chararray(const char* c, char x, char y, unsigned const char* f);    //double size
char OLED2char2(char c, char x, char y, unsigned const char* f);    //double size

#endif  //OLED_H

