//basic IO setup and defines

#include "io.h"

// IO pinouts Revs B and C PCB (pins 6 and 10 swapped from rev A):
//  2   RA5 S1
//  3   RA4 S2
//  5   RC5 TCOPWM  (PWM1)
//  6   RC4 SDA(bitbang)
//  7   RC3 TSENSE  (AN7)
//  8   RC6 BMPWM   (PWM2)
//  9   RC7 ISENSE  (AN9)
//  10  RB7 S3
//  11  RB6 SCL(bitbang)
//  12  RB5 VOUTSENSE   (AN11)
//  13  RB4 VBATSENSE   (AN10)
//  14  RC2 VINSENSE    (AN6)

void ioinit(void){
    ANSELA=0x00;           //none
    ANSELB=0x30;           //only RB4,RB5
    ANSELC=0x8C;           //only RC3,RC7,RC2
    WPUA=0x30;             //pullup on RA5,RA4
    WPUB=0x80;             //pullup on RB7
    OPTION_REGbits.nWPUEN=0;    //allow pullups
    //ADCON1=0b11010000;  //11010000 =  Right justified, FOSC/16, VREF is VDD
    ADCON1=0b11110000;  //11010000 =  Right justified, FRC, VREF is VDD
    ADCON0=0b00000001;  //no source, no conversion, ADC enabled

    //TIMER2 for PWM
    T2CON=0;    //reset
    T2CONbits.T2CKPS=0; //1
    //T2CONbits.T2CKPS=1; //4
    //T2CONbits.T2CKPS=2; //16
    TMR2=0;
    PR2=255;
    //IO and PWM
    TRISCbits.TRISC5=1; //PWM1 high Z
    PWM1CON=0;  //off, active high    
    PWM1CONbits.PWM1EN=1;   //running
    PWM1CONbits.PWM1OE=1;   //enabled
    PWM1DCL=0;
    PWM1DCH=0;    
    TRISCbits.TRISC6=1; //PWM2 high Z
    PWM2CON=0;  //off, active high    
    PWM2CONbits.PWM2EN=1;   //running
    PWM2CONbits.PWM2OE=1;   //enabled
    PWM2DCL=0;
    PWM2DCH=0;    
    //start TIMER2
    T2CONbits.TMR2ON=1;
}

int getADC(char c){
    ADCON0bits.CHS=c&0x1F;       //set channel
    ADCON0bits.ADGO=1;              //start
    while(ADCON0bits.ADGO){}        //wait till done
    //return (((ADRESH&3)<<8)|(ADRESL))>>2;//result
    return ADRES;
}
