#include "flash.h"

void readflash(unsigned char p,unsigned char* r){     //read page p into ram
    unsigned int add;
    unsigned char i;
    add=p*FLASHPAGESIZE;        //assuming pages are less than 256 and evenly divide into it
    PMADRH=add>>8;    
    PMADRL=add;
    for(i=0;i<FLASHPAGESIZE;i++){
        PMCON1bits.CFGS=0;
        PMCON1bits.RD=1;
        NOP();
        NOP();
        r[i]=PMDATL;
        PMADRL++;
    }
}

void writeflash(unsigned char p,unsigned char* r){     //write page p from ram
    unsigned int add;
    unsigned char iflag;
    unsigned char i;
    iflag=INTCON;                    //save interrupt flags
    INTCONbits.GIE=0;                //disable interrupts globally
    add=p*FLASHPAGESIZE;        //assuming pages are less than 256 and evenly divide into it
    PMADRH=add>>8;    
    PMADRL=add;
    PMCON1bits.WREN=1;          
    PMCON1bits.CFGS=0;          //normal flash, not config registers
    PMCON1bits.LWLO=1;          //loading latches
    PMCON1bits.FREE=0;          //write operation
    for(i=0;i<FLASHPAGESIZE;i++){
        if(i==(FLASHPAGESIZE-1)){PMCON1bits.LWLO=0;}        //clear LWLO before last word to trigger write
        PMDATL=r[i];
        PMCON2=0x55;
        PMCON2=0xAA;
        PMCON1bits.WR=1;
        NOP();
        NOP();
        PMADRL++;
    }
    PMCON1bits.WREN=0;            //disable writes
    INTCON=iflag;                    //enable interrupts    
}

void eraseflash(unsigned char p){     //erase page p for write
    unsigned int add;
    unsigned char iflag;
    iflag=INTCON;                    //save interrupt flags
    INTCONbits.GIE=0;                //disable interrupts globally
    PMCON1bits.CFGS=0;          //normal flash, not config registers
    add=p*FLASHPAGESIZE;        //assuming pages are less than 256 and evenly divide into it
    PMADRH=add>>8;    
    PMADRL=add;
    PMCON1bits.FREE=1;          //erase operation
    PMCON1bits.WREN=1;          
    PMCON2=0x55;
    PMCON2=0xAA;
    PMCON1bits.WR=1;
    NOP();
    NOP();
    PMCON1bits.WREN=0;            //disable writes
    INTCON=iflag;                    //enable interrupts    
}


