#include "config.h"
#include <xc.h>
#include "util.h"
#include "io.h"
#include "softi2c.h"
#include "oled.h"
#include "font.h"
#include "timer1.h"
#include "flash.h"

//Battery Charge Adapter for Buck Boost Driver
// IO pinouts Revs B and C PCB (pins 6 and 10 swapped from rev A):
//  2   RA5 S1
//  3   RA4 S2
//  5   RC5 TCOPWM  (PWM1)
//  6   RC4 SDA(bitbang)
//  7   RC3 TSENSE  (AN7)
//  8   RC6 BMPWM   (PWM2)
//  9   RC7 ISENSE  (AN9)
//  10  RB7 S3
//  11  RB6 SCL(bitbang)
//  12  RB5 VOUTSENSE   (AN11)
//  13  RB4 VBATSENSE   (AN10)
//  14  RC2 VINSENSE    (AN6)

state s=IDLE;
state sLast=IDLE;
char disp=0;    //0=normal, 1= editing stuff
char lastDisp=-1;   //flag redraw
struct flashshadow fEdit;   //this version is modified so changes don't take effect immediately
unsigned int* fArray=(unsigned int*)&fEdit; //since it is mostly ints, we can access members serially
unsigned int secLast=0;
unsigned int deltaSec=0;
unsigned int secTemp;
int pwmtemp;

#define STD_TMOUT (3)
unsigned char tvinlow=STD_TMOUT;
unsigned char tvoutlow=STD_TMOUT;
unsigned char tvbatlow=STD_TMOUT;
#define SLEEP_TIMEOUT (20)
unsigned char tsleep=SLEEP_TIMEOUT;
#define NORMAL_CONTRAST (0x7F)
#define LP_CONTRAST (0)
#define BULK_MIN (10)
unsigned int tbulk=0;
unsigned int tstoreon=0;
unsigned int tstoreoff=0;
unsigned char mCount=0;         //counts 60s to give 1min
unsigned char bulkTrig=0;       //threshold passed
unsigned char bulkFlag=0;       //to manually start bulk
unsigned char editsFlag1=0;     //to use edits
unsigned char editsFlag2=0;     //to ignore edits
unsigned char saveFlag=0;       //to manually start bulk
unsigned char bulkHold=BULK_MIN;//minimum time (s) in bulk to allow settling
unsigned char intconSave;

int main(void){    
    //OSCCONbits.IRCF = 0b1111; //use 16MHz HFINTOSC
    OSCCONbits.IRCF = 0b1101; //use 4MHz HFINTOSC
    //OSCCONbits.IRCF = 0b1100; //use 2MHz HFINTOSC
    ioinit();
    I2Cstop();          //this sets up I2C to idle state
    OLEDinit();         //does clear
    dispSleep(NORMAL_CONTRAST);    //mid
    timer1init();
    readflash(HEF_PAGE,(unsigned char*)&f);     //load from flash
    if(f.check!=fbackup.check){ //flash error
        f=fbackup;              //load defaults
        eraseflash(HEF_PAGE);
        writeflash(HEF_PAGE,(unsigned char*)&f);    //and store
        flasherror();       //display message
        __delay_ms(3000);
        OLEDclear(0);
    }
    fEdit=f;
    INTCONbits.GIE=1;       //global interrupt enable
    BMPWM=NULL_PWM;
    TCOPWM=NULL_PWM;
    BMPWM_INACTIVE=1;
    TCOPWM_INACTIVE=1;
    getData();  //ensure we have valid data
    while(1){
        //business logic
        intconSave=INTCON;
        INTCONbits.GIE=0;       //global interrupt disable
        secTemp=seconds; //capture volatile
        INTCON=intconSave;      //interrupt restore
        deltaSec=secTemp-secLast;
        secLast=secTemp;    //update
        if(deltaSec){
            if(deltaSec>5){deltaSec=5;}   //avoid wraparound glitch
            while(deltaSec--){
                //hold off and countdown timers
                if(vin<f.vinlow){tvinlow=STD_TMOUT;}else{if(tvinlow){tvinlow--;}}
                if(vbat<f.vbatlow){tvbatlow=STD_TMOUT;}else{if(tvbatlow){tvbatlow--;}}
                if(vout<f.voutlow){tvoutlow=STD_TMOUT;}else{if(tvoutlow){tvoutlow--;}}
                if(tsleep){tsleep--;}
                if(bulkHold){bulkHold--;}
                mCount++;
                if(mCount>59){
                    mCount=mCount-60;   //minutely actions
                    if(s==BULK){if(tbulk){tbulk--;}}        //bulk countdown in bulk                
                    if(s==NOPOWER){if(tbulk<f.bulkmin){tbulk++;}}   //bulk padding
                    if(s==FLOAT){if(tstoreoff){tstoreoff--;}}   //countdown to next store
                    if(s==STORAGE){if(tstoreon){tstoreon--;}}     //countdown to end of store
                }
            }
            //fault and recovery pass through common idle state
            if(tvbatlow){s=NOBATT;}else if(s==NOBATT){s=IDLE;}
            if(tvoutlow){s=PSUFAULT;}else if(s==PSUFAULT){s=IDLE;}        
            if(tvinlow){s=NOPOWER;}else if(s==NOPOWER){s=IDLE;} //this to dominate
            //operational state changes
            if(s==BULK){
                if(bulkHold==0){    //run for minimum time
                    if(tbulk==0){s=FLOAT;}    //timed bulk end
                    if(iout<f.iabsend){s=FLOAT;tbulk=0;}    //low current bulk end
                }
            }else{
                bulkHold=BULK_MIN;
            }
            if(s==IDLE){if(tbulk){s=BULK;}}     //resume bulk if time left        
            if(s==FLOAT){
                if(bulkTrig){s=BULK;tbulk=f.bulkmin;bulkTrig=0;}         //go bulk on low bat
                if((tstoreoff==0)&&(f.storedelaymin!=0)){   //use zero setting to ignore
                    tstoreon=f.storemin;    
                    s=STORAGE;                    //start storeenance
                }
            }else{
                tstoreoff=f.storedelaymin;  //keep reset unless on float
            }
            if(s==STORAGE){
                if(tstoreon==0){s=FLOAT;}    //switch to float at end of store
            }
            if(s==IDLE){s=FLOAT;}                       //default state            
            if(sLast!=s){
                //any state changes that need action
                switch(s){
                    case IDLE:
                    case FLOAT:
                    case NOBATT:
                    case PSUFAULT:
                    case NOPOWER:
                        //nothing happening in these modes
                        BMPWM=NULL_PWM;
                        BMPWM_INACTIVE=1;
                        break;
                    case BULK:
                        pwmtemp=adjust(f.bulkinc,PC_PWM);
                        if(pwmtemp>NULL_PWM){pwmtemp=NULL_PWM;}
                        if(pwmtemp<0){pwmtemp=0;}
                        BMPWM=NULL_PWM-pwmtemp;
                        BMPWM_INACTIVE=0;
                        break;
                    case STORAGE:
                        pwmtemp=adjust(f.storedec,PC_PWM);
                        if(pwmtemp>NULL_PWM){pwmtemp=NULL_PWM;}
                        if(pwmtemp<0){pwmtemp=0;}
                        BMPWM=NULL_PWM+pwmtemp;
                        BMPWM_INACTIVE=0;
                        break;
                }
                sLast=s;        
                flag2=1;
            }
            if(s!=NOPOWER){tsleep=SLEEP_TIMEOUT;}   //reset
            if(disp!=0){tsleep=SLEEP_TIMEOUT;}   //reset
        }
/*
        if(flag1){            
            flag1=0;
        }
        if(S1||S2){
            tsleep=SLEEP_TIMEOUT;   //reset            
        }
*/
        if(s1down){
            tsleep=SLEEP_TIMEOUT;   //reset
            s1down=0;
            flag2=1;
        }
        if(s2down){
            tsleep=SLEEP_TIMEOUT;   //reset
            s2down=0;
            flag2=1;
        }
        if(s3down){
            tsleep=SLEEP_TIMEOUT;   //reset
            disp=disp+1;
            if(disp>=SCREEN_COUNT){disp=0;}
            s3down=0;
            flag2=1;
        }
        if(flag2){
            getData();  //always   
            if((temp<-TEMP_MIN)||(temp>TEMP_MAX)){  //error
                TCOPWM_INACTIVE=1;               
                TCOPWM=NULL_PWM;
            }else{              //OK
                TCOPWM=NULL_PWM-(((temp-TEMP_NULL)*f.tempco)/TC_PWM);                
                TCOPWM_INACTIVE=0;                               
            }                
            if(vbat<f.vbulkstart){bulkTrig=1;}  //set flag
            if(disp==0){
                if(disp!=lastDisp){
                    OLEDclear(0);                        
                    normalTitle();
                    lastDisp=disp;
                }                
                if(S1){
                    if(s==FLOAT){bulkTrig=1;}
                }
                if(S2){
                    bulkHold=0; //force timers
                    tbulk=0;    
                    tstoreon=0; //also cancel storeenance mode
                }
                normalData();
                OLED2chararray(&stateString[s][0],0,0,ffont);
                OLEDsetpage(7);
                OLEDsetcolumn(90);
                if(s==NOPOWER){
                    showU(tsleep);
                    OLEDchar('s');
                }else if(s==BULK){
                    showT(tbulk);
                }else if(s==STORAGE){
                    showT(tstoreon);
                }else if(s==FLOAT){
                    if(f.storedelaymin!=0){
                        showT(tstoreoff);
                    }else{
                        OLEDchararray("------");    
                    }
                }else{
                    OLEDchararray("------");    
                }
            }else{
                if(disp!=lastDisp){
                    OLEDclear(0);                        
                    OLED2chararray(&calString[disp][0],0,0,ffont);
                    lastDisp=disp;                
                }                
                OLEDsetpage(3);
                OLEDsetcolumn(0);
                switch(disp){
                    case 1:
                        fEdit.vbatcal+=buttonAdj(1);
                        showU(fEdit.vbatcal);                        
                        OLEDsetpage(5);
                        OLEDsetcolumn(0);
                        showVV(adjust(getADC(VBATSENSE),fEdit.vbatcal));
                        break;
                    case 2:
                        fEdit.vincal+=buttonAdj(1);
                        showU(fEdit.vincal);
                        OLEDsetpage(5);
                        OLEDsetcolumn(0);
                        showVV(adjust(getADC(VINSENSE),fEdit.vincal));
                        break;
                    case 3:
                        fEdit.voutcal+=buttonAdj(1);
                        showU(fEdit.voutcal);
                        OLEDsetpage(5);
                        OLEDsetcolumn(0);
                        showVV(adjust(getADC(VOUTSENSE),fEdit.voutcal));
                        break;
                    case 4:
                        fEdit.ioutcal+=buttonAdj(1);
                        showU(fEdit.ioutcal);
                        OLEDsetpage(5);
                        OLEDsetcolumn(0);
                        showAA(adjust(getADC(ISENSE),fEdit.ioutcal));
                        break;
                    case 5:
                        fEdit.vbatlow+=buttonAdj(100);
                        showV(fEdit.vbatlow);
                        break;
                    case 6:
                        fEdit.vinlow+=buttonAdj(100);
                        showV(fEdit.vinlow);
                        break;
                    case 7:
                        fEdit.voutlow+=buttonAdj(100);
                        showV(fEdit.voutlow);
                        break;
                    case 8:
                        fEdit.vbulkstart+=buttonAdj(100);
                        showV(fEdit.vbulkstart);
                        break;
                    case 9:
                        fEdit.iabsend+=buttonAdj(10);
                        showAA(fEdit.iabsend);
                        break;
                    case 10:
                        fEdit.bulkinc+=buttonAdj(1);
                        if(fEdit.bulkinc==0xFFFF){fEdit.bulkinc=0;} //underflow
                        if(fEdit.bulkinc>BULKINCMAX){fEdit.bulkinc=BULKINCMAX;}
                        showPC(fEdit.bulkinc);
                        break;
                    case 11:
                        fEdit.storedec+=buttonAdj(1);
                        if(fEdit.storedec==0xFFFF){fEdit.storedec=0;} //underflow
                        if(fEdit.storedec>STOREDECMAX){fEdit.storedec=STOREDECMAX;}
                        showPC(fEdit.storedec);
                        break;
                    case 12:
                        fEdit.bulkmin+=buttonAdj(5);
                        showT(fEdit.bulkmin);
                        break;
                    case 13:
                        fEdit.storemin+=buttonAdj(5);
                        showT(fEdit.storemin);
                        break;
                    case 14:
                        fEdit.storedelaymin+=buttonAdj(5);
                        showT(fEdit.storedelaymin);
                        editsFlag1=0;
                        editsFlag2=0;
                        saveFlag=0;
                        break;
                    case 15:
                        fEdit.tempco+=buttonAdj(1);
                        if(fEdit.tempco<-TEMPCO_LIM){fEdit.tempco=-TEMPCO_LIM;}
                        if(fEdit.tempco>TEMPCO_LIM){fEdit.tempco=TEMPCO_LIM;}
                        showS(fEdit.tempco);
                        OLEDchararray("%/\x7F" "C");    
                        break;
                    case 16:
                        if(editsFlag1){
                            OLEDchararray("Loaded   ");    
                        }else{
                            OLEDchararray("S1 to use");                                
                            if(S1){
                                f=fEdit;
                                editsFlag1=1; //avoid repeat
                            }
                        }
                        OLEDsetpage(5);
                        OLEDsetcolumn(0);
                        if(editsFlag2){
                            OLEDchararray("Restored     ");    
                        }else{
                            OLEDchararray("S2 to restore");                                
                            if(S2){
                                fEdit=f;
                                editsFlag2=1; //avoid repeat
                            }
                        }
                        break;
                    case 17:
                        if(saveFlag){
                            OLEDchararray("Saved   ");    
                        }else{
                            OLEDchararray("Press S1");                                
                            if(S1){
                                eraseflash(HEF_PAGE);
                                writeflash(HEF_PAGE,(unsigned char*)&f);    //and store
                                saveFlag=1; //avoid repeat
                            }
                        }
                        break;
                }
            }
            flag2=0;
        }
        if(tsleep==0){
            dispSleep(LP_CONTRAST);   //off
//                SLEEP();        //should wake up on timer ISRs
        }else{
            dispSleep(NORMAL_CONTRAST);                
        }            
    }
}

