//basic IO setup and defines

#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  

// IO pinouts Revs B and C PCB (pins 6 and 10 swapped from rev A):
//  2   RA5 S1
//  3   RA4 S2
//  5   RC5 TCOPWM  (PWM1)
//  6   RC4 SDA(bitbang)
//  7   RC3 TSENSE  (AN7)
//  8   RC6 BMPWM   (PWM2)
//  9   RC7 ISENSE  (AN9)
//  10  RB7 S3
//  11  RB6 SCL(bitbang)
//  12  RB5 VOUTSENSE   (AN11)
//  13  RB4 VBATSENSE   (AN10)
//  14  RC2 VINSENSE    (AN6)

#define S1 (!PORTAbits.RA5)
#define S2 (!PORTAbits.RA4)
#define S3 (!PORTBbits.RB7)

#define ISENSE (9)
#define VOUTSENSE (11)
#define VBATSENSE (10)
#define VINSENSE (6)
#define TSENSE (7)

#define BMPWM (PWM2DCH)
#define TCOPWM (PWM1DCH)
#define BMPWM_INACTIVE (TRISCbits.TRISC6)
#define TCOPWM_INACTIVE (TRISCbits.TRISC5)

//same as no change in output
#define NULL_PWM (96)

void ioinit(void);
int getADC(char c);     //get channel c

#endif	/* IO_H */

