#ifndef UTIL_H
#define	UTIL_H

#include <xc.h> // include processor files - each processor file is guarded.  

#define PRESCALE (16)
#define SCREEN_COUNT (18)
#define HYSTERESIS (200)
#define PC_PWM (194)
#define TC_PWM (170)
#define TEMP_MIN (-150)
#define TEMP_MAX (900)
#define TEMP_NULL (250)
//to avoid overflow and running other expensive checks
#define TEMPCO_LIM (25)
#define BULKINCMAX (120)
#define STOREDECMAX (120)

typedef enum {IDLE,NOBATT,FLOAT,BULK,STORAGE,PSUFAULT,NOPOWER} state;

struct flashshadow{ //keep all the saveable parts in one struct, must be exactly FLASHPAGESIZE
    unsigned int check;
    unsigned int vbatcal;   //all V/I
    unsigned int vincal;    //are mV/mA
    unsigned int voutcal;
    unsigned int ioutcal;
    unsigned int vbatlow;
    unsigned int vinlow;
    unsigned int voutlow;
    unsigned int vbulkstart;
    unsigned int iabsend;
    unsigned int bulkinc;   //in permil (ie tenths of a %)
    unsigned int storedec;  //in permil (ie tenths of a %)
    unsigned int bulkmin;   //in min
    unsigned int storemin;   //in min
    unsigned int storedelaymin;    //
    int tempco;         //tempco,signed in hundredths of a percent per degree C
};

// flashshadow struct: check  vbatcal vincal voutcal ioutcal vbatlow vinlow voutlow vbulkstart iabsend bulkinc storedec bulkmin storemin storedelaymin tempco                
#define FLASH_DEFAULTS 0xAA55,9088,   9088,  9088,   3546,   11000,  11000, 11000,  12000,     500,    40,     45,     120,     8640,    0,            0

//special font character
#define DEGREES (127)

extern struct flashshadow f;
extern const struct flashshadow hef;
extern const struct flashshadow fbackup;
extern volatile unsigned char flag1, flag2;    //flag1 ~ 20Hz for debouncing, flag2 ~1Hz for screen updates
extern volatile unsigned char s1down,s2down,s3down,s1Last,s2Last,s3Last;
extern volatile unsigned int seconds;

extern char digits[5]; //for decoding to decimal
extern const unsigned int tcon[];
extern int pwm;
extern unsigned int vbat,vin,vout,iout;    //all in mV/mA,degC
extern int temp;    //tenths of degree C
extern const char stateString[][11],calString[][11];

//prototypes
void getData(void); //get updated V/A values via ADC
unsigned int adjust(unsigned int raw,unsigned int scale);   //calib/scaling
void doZB(char p);  //leading zero blank except places at or lower than p
void toDec(unsigned int n); //prototype
void normalData(void);      //drawing
void normalTitle(void);
int getTemp(unsigned int v);
void snum(int s, char p);    //set up signed number for display
void unum(unsigned int s, char p);  //set up unsigned number
void flasherror(void);       //display message
void showV(unsigned int v); //assumes v is in mV => xx.xV
void showVV(unsigned int v); //assumes v is in mV, shows 2dp xx.xxV
void showAA(unsigned int v); //assumes v is in mA, shows 2dp
void showU(unsigned int v); //full normal 5 digit unsigned
void showS(int v); //full normal 5 digit signed
void showPC(unsigned int v); //one dp ie xxxx.x%
void showT(unsigned int v); //hhhh:mm
signed char buttonAdj(unsigned char n);
void dispSleep(unsigned char n);     //save spurious writes


#endif	/* UTIL_H */

