#include "softi2c.h"

// IO pinouts Revs B and C PCB (pins 6 and 10 swapped from rev A):
//  2   RA5 S1
//  3   RA4 S2
//  5   RC5 TCOPWM  (PWM1)
//  6   RC4 SDA(bitbang)
//  7   RC3 TSENSE  (AN7)
//  8   RC6 BMPWM   (PWM2)
//  9   RC7 ISENSE  (AN9)
//  10  RB7 S3
//  11  RB6 SCL(bitbang)
//  12  RB5 VOUTSENSE   (AN11)
//  13  RB4 VBATSENSE   (AN10)
//  14  RC2 VINSENSE    (AN6)

void I2Cbit(unsigned char n){      //send one bit
    if(n){
        SDAHI
    }else{
        SDALO
    }
    SCLHI
    SCLLO
}

void I2Cbyte(unsigned char n){     //send byte,return read byte + ACK
    I2Cbit(n&128);
    I2Cbit(n& 64);
    I2Cbit(n& 32);
    I2Cbit(n& 16);
    I2Cbit(n&  8);
    I2Cbit(n&  4);
    I2Cbit(n&  2);
    I2Cbit(n&  1);
    I2Cbit(1);  //ack bit
}

void I2Cstart(void){                 //send start condition
    //SDAHI                            //allow repeated start
    SDALO
    SCLLO
}

void I2Cstop(void){                  //send stop condition
    I2CSETLAT
    SDALO
    SCLHI
    SDAHI
}
