/*
 *	Delay functions
 *	See delay.h for details
 *
 *	Make sure this code is compiled with full optimization!!!
 */

#include	"delay.h"


/***********************************************************
 *   Millisecond Delay function using the Count register 
 *   in coprocessor 0 in the MIPS core.
 */
void DelayMs(unsigned long int msDelay )
{
      register unsigned int startCntms = __builtin_mfc0(9, 0);
      register unsigned int waitCntms = msDelay * ms_SCALE;
 
      while( __builtin_mfc0(9, 0) - startCntms < waitCntms );
}
 
/***********************************************************
 *   Microsecond Delay function using the Count register 
 *   in coprocessor 0 in the MIPS core.
 */
void DelayUs(unsigned long int usDelay )
{
      register unsigned int startCnt = __builtin_mfc0(9, 0);
      register unsigned int waitCnt = usDelay * us_SCALE;
 
      while( __builtin_mfc0(9, 0) - startCnt < waitCnt );
}

