#ifndef _KS0108_CONFIG_H    /* Guard against multiple inclusion */
#define _KS0108_CONFIG_H

#include <xc.h>

#include "system/ports/sys_ports.h"
#include "peripheral/ports/plib_ports.h"

// Set this if you want to use the delay functions from the CORETIMER Harmony component. Otherwise these are expected to be defined in "delay.h"
//#define USE_CORETIMER

// Each controller handles a 64x64 half of the screen. Set this if they are around the wrong way
//#define KS0108_SWAP_SIDES

#define APP_LCD_PORT_CS2 PORT_CHANNEL_B
#define APP_LCD_PORT_CS1 PORT_CHANNEL_B
#define APP_LCD_PORT_RESET PORT_CHANNEL_F
#define APP_LCD_PORT_RW PORT_CHANNEL_D
#define APP_LCD_PORT_RS PORT_CHANNEL_B
#define APP_LCD_PORT_ENABLE PORT_CHANNEL_F
#define APP_LCD_PORT_DATA PORT_CHANNEL_B

/* RF4  = LCD Reset - Active Low (output) */
#define KS0108_LCD_RST 16
/* RF5  = LCD Enable (output) */
#define KS0108_LCD_E 32
/* RD5 = LCD_RW (output)*/
#define KS0108_LCD_RW 32
/* RB4 = LCD_RS (output)*/
#define KS0108_LCD_RS 16
/* RB5  = LCD Chip Select 1 (output) */
#define KS0108_LCD_CS1 32
/* RB6  = LCD Chip Select 2 (output) */
#define KS0108_LCD_CS2 64
#define KS0108_PortBits 0xFF00

#define KS0108_DATA_DIRN_IN() SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_INPUT, APP_LCD_PORT_DATA, KS0108_PortBits )
#define KS0108_DATA_DIRN_OUT() SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_DATA, KS0108_PortBits )
#define KS0108_Write_RST SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_RESET, KS0108_LCD_RST )
#define KS0108_Write_EN SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_ENABLE, KS0108_LCD_E )
#define KS0108_Write_CS2 SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_CS2, KS0108_LCD_CS2 )
#define KS0108_Write_CS1 SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_CS1, KS0108_LCD_CS1 )
#define KS0108_Write_RW SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_RW, KS0108_LCD_RW)
#define KS0108_Write_RS SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_RS, KS0108_LCD_RS)

#define KS0108_CTRL_DIRN_OUT()  {KS0108_Write_RST;KS0108_Write_EN;KS0108_Write_CS1;KS0108_Write_CS2;KS0108_Write_RW;KS0108_Write_RS;}

#define KS0108_RST_HIGH()     SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_RESET, KS0108_LCD_RST, KS0108_LCD_RST)
#define KS0108_RST_LOW()      SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_RESET, KS0108_LCD_RST)
#define KS0108_E_HIGH()       SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_ENABLE, KS0108_LCD_E, KS0108_LCD_E)
#define KS0108_E_LOW()        SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_ENABLE, KS0108_LCD_E)
#define KS0108_CS1_HIGH()     SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_CS1, KS0108_LCD_CS1, KS0108_LCD_CS1)
#define KS0108_CS1_LOW()      SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_CS1, KS0108_LCD_CS1)
#define KS0108_CS2_HIGH()     SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_CS2, KS0108_LCD_CS2, KS0108_LCD_CS2)
#define KS0108_CS2_LOW()      SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_CS2, KS0108_LCD_CS2)
#define KS0108_RW_HIGH()      SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_RW, KS0108_LCD_RW, KS0108_LCD_RW)
#define KS0108_RW_LOW()       SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_RW, KS0108_LCD_RW)
#define KS0108_RS_HIGH()      SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_RS, KS0108_LCD_RS, KS0108_LCD_RS)
#define KS0108_RS_LOW()       SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_RS, KS0108_LCD_RS)

#define KS0108_DATA_OUTPUT(_KS0108_Data)	{SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_DATA, KS0108_PortBits); SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_DATA, (_KS0108_Data<<8), KS0108_PortBits);}
#define KS0108_DATA_INPUT()	((SYS_PORTS_Read(PORTS_ID_0, APP_LCD_PORT_DATA) & 0xFF00)>>8)

/* these work with the small LCD*/
#define KS0108_EN_H 2
#define KS0108_EN_L 2

#endif /* _KS0108_CONFIG_H */

/* *****************************************************************************
 End of File
 */
