#ifndef _KS0108_CONFIG_H    /* Guard against multiple inclusion */
#define _KS0108_CONFIG_H

#include <xc.h>

#include "system/ports/sys_ports.h"
#include "peripheral/ports/plib_ports.h"

// Set this if you want to use the delay functions from the CORETIMER Harmony component. Otherwise these are expected to be defined in "delay.h"
//#define USE_CORETIMER

// Each controller handles a 64x64 half of the screen. Set this if they are around the wrong way
//#define KS0108_SWAP_SIDES

#define APP_LCD_PORT_CS2 PORT_CHANNEL_B
#define APP_LCD_PORT_CS1 PORT_CHANNEL_B
#define APP_LCD_PORT_RESET PORT_CHANNEL_F
#define APP_LCD_PORT_RW PORT_CHANNEL_D
#define APP_LCD_PORT_RS PORT_CHANNEL_B
#define APP_LCD_PORT_ENABLE PORT_CHANNEL_F
#define APP_LCD_PORT_DATA PORT_CHANNEL_B

/* RF4  = LCD Reset - Active Low (output) */
#define KS0108_LCD_RST 16
/* RF5  = LCD Enable (output) */
#define KS0108_LCD_E 32
/* RD5 = LCD_RW (output)*/
#define KS0108_LCD_RW 32
/* RB4 = LCD_RS (output)*/
#define KS0108_LCD_RS 16
/* RB5  = LCD Chip Select 1 (output) */
#define KS0108_LCD_CS1 32
/* RB6  = LCD Chip Select 2 (output) */
#define KS0108_LCD_CS2 64
#define KS0108_PortBits 0xFF00

#define KS0108_Read SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_INPUT, APP_LCD_PORT_DATA, KS0108_PortBits )
#define KS0108_Write SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_DATA, KS0108_PortBits )
#define KS0108_Write_RST SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_RESET, KS0108_LCD_RST )
#define KS0108_Write_EN SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_ENABLE, KS0108_LCD_E )
#define KS0108_Write_CS2 SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_CS2, KS0108_LCD_CS2 )
#define KS0108_Write_CS1 SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_CS1, KS0108_LCD_CS1 )
#define KS0108_Write_RW SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_RW, KS0108_LCD_RW)
#define KS0108_Write_RS SYS_PORTS_DirectionSelect(PORTS_ID_0, SYS_PORTS_DIRECTION_OUTPUT, APP_LCD_PORT_RS, KS0108_LCD_RS)

#define KS0108_ASSERT_RESET  SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_RESET, KS0108_LCD_RST)
#define KS0108_CLEAR_RESET   SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_RESET, KS0108_LCD_RST, KS0108_LCD_RST)
#define KS0108_ASSERT_ENABLE SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_ENABLE, KS0108_LCD_E, KS0108_LCD_E)
#define KS0108_CLEAR_ENABLE  SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_ENABLE, KS0108_LCD_E)
#define KS0108_ASSERT_CS2    SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_CS2, KS0108_LCD_CS2)
#define KS0108_CLEAR_CS2     SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_CS2, KS0108_LCD_CS2, KS0108_LCD_CS2)
#define KS0108_ASSERT_CS1    SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_CS1, KS0108_LCD_CS1)
#define KS0108_CLEAR_CS1     SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_CS1, KS0108_LCD_CS1, KS0108_LCD_CS1)
#define KS0108_ASSERT_RW     SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_RW, KS0108_LCD_RW, KS0108_LCD_RW)
#define KS0108_CLEAR_RW      SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_RW, KS0108_LCD_RW)
#define KS0108_ASSERT_RS     SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_RS, KS0108_LCD_RS, KS0108_LCD_RS)
#define KS0108_CLEAR_RS      SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_RS, KS0108_LCD_RS)

#define KS0108_DATA_WRITE(_KS0108_Data)	{SYS_PORTS_Clear(PORTS_ID_0, APP_LCD_PORT_DATA, KS0108_PortBits); SYS_PORTS_Set(PORTS_ID_0, APP_LCD_PORT_DATA, (_KS0108_Data<<8), KS0108_PortBits);}
#define KS0108_DATA_READ(_KS0108_Data)	{_KS0108_Data = ((SYS_PORTS_Read(PORTS_ID_0, APP_LCD_PORT_DATA) & 0xFF00)>>8);}

/* these work with the small LCD*/
#define KS0108_EN_H 2
#define KS0108_EN_L 2

#endif /* _KS0108_CONFIG_H */

/* *****************************************************************************
 End of File
 */
