#ifndef _GLCD_H /* Guard against multiple inclusion */
#define _GLCD_H

#include <stdbool.h>

#include "KS0108.h"
#include "ST7920.h"

typedef enum {
    GLCD_KS0108 = 0,
    GLCD_ST7920,
    GLCD_NONE
} screen_type_t;

void GLCD_Initialize(screen_type_t);
void GLCD_ClearScreen();
void GLCD_WriteBufToScreen();

void BufCopy_KS0108_to_ST7920(uint16_t *dst_st7920, unsigned char *src_ks0108);

#endif /* _GLCD_H */
