#ifndef _ST7920_CONFIG_H /* Guard against multiple inclusion */
#define _ST7920_CONFIG_H

// Set this if you want to use the delay functions from the CORETIMER Harmony component. Otherwise these are expected to be defined in "delay.h"
// Functions required are DelayUs(unsigned long int) and DelayMs(unsigned long int)
// #define USE_CORETIMER

#define APP_LCD_PORT_RESET PORT_CHANNEL_F
#define APP_LCD_PORT_RW PORT_CHANNEL_D
#define APP_LCD_PORT_RS PORT_CHANNEL_B
#define APP_LCD_PORT_ENABLE PORT_CHANNEL_F
#define APP_LCD_PORT_DATA PORT_CHANNEL_B

/* RF4  = LCD Reset - Active Low (output) */
/* RF5  = LCD Enable (output) */
/* RD5 = LCD_RW (output)*/
/* RB4 = LCD_RS (output)*/
/* RB5  = PSB
/* RB8-15 = LCD DATA */

#define LCD_DATA_DIRN_IN()     (TRISBSET = 0xFF00)
#define LCD_DATA_DIRN_OUT()    (TRISBCLR = 0xFF00)
#define LCD_DATA_INPUT()       ((PORTB & 0xFF00)>>8)
#define LCD_DATA_OUTPUT(d)     {LATBCLR = 0xFF00; LATBSET = (d<<8);}
#define LCD_CTRL_DIRN_OUT()    {TRISFCLR = (1<<4)&(1<<5); TRISDCLR = (1<<5); TRISBCLR = (1<<4)&(1<<5)&(1<<6);}
#define LCD_RST_HIGH()         (LATFSET = (1<<4)) // RST -> F4
#define LCD_RST_LOW()          (LATFCLR = (1<<4))
#define LCD_E_HIGH()           (LATFSET = (1<<5)) // E -> F5
#define LCD_E_LOW()            (LATFCLR = (1<<5))
#define LCD_RW_HIGH()          (LATDSET = (1<<5)) // RW -> D5
#define LCD_RW_LOW()           (LATDCLR = (1<<5))
#define LCD_RS_HIGH()          (LATBSET = (1<<4)) // RS -> B4
#define LCD_RS_LOW()           (LATBCLR = (1<<4))
#define LCD_PSB_HIGH()         (LATBSET = (1<<5)) // PSB -> B5
#define LCD_PSB_LOW()          (LATBCLR = (1<<5))

#endif /* _ST7920_CONFIG_H */
