#define RXD2 16    //1 serial1=1,3
#define TXD2 17    //3 serial2=16,17

#include "TFMini.h"
TFMini tfmini;


#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 32 // OLED display height, in pixels

// Declaration for an SSD1306 display connected to I2C (SDA, SCL pins)
#define OLED_RESET     4 // Reset pin # (or -1 if sharing Arduino reset pin)
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);


//TFMINI_BAUDRATE

void setup() {
Serial.begin(115200);  
Serial1.begin(115200, SERIAL_8N1, RXD2, TXD2); //9,8);  //16,17);
Serial.println("Serial Txd is on pin: "+String(TXD2));
Serial.println("Serial Rxd is on pin: "+String(RXD2));

tfmini.begin(&Serial1);    

display.begin(SSD1306_SWITCHCAPVCC, 0x3C);  // initialize with the I2C addr 0x3C (for the 128x32)
display.display();
delay(200);
display.clearDisplay();
display.setRotation(2); //2
display.clearDisplay();
display.setTextSize(1);                               // Set OLED text size to small
display.setCursor(0,0);
display.setTextColor( WHITE,BLACK); // white on black
display.println("TFMini example");  
display.print("Welcome");
display.display();
delay(1000);
display.clearDisplay();
display.display();

}

void loop() {
  // Take one TF Mini distance measurement
  uint16_t dist = tfmini.getDistance();
  uint16_t strength = tfmini.getRecentSignalStrength();

  // Display the measurement
  Serial.print(dist);
  Serial.print(" cm      sigstr: ");
  Serial.println(strength);
char sz[30];
display.setTextSize(2); 

sprintf(sz, "Dist:%d   ", dist);
display.setCursor(0,0);  //5,2
display.setTextColor( WHITE,BLACK); // white on black
display.print(sz);

sprintf(sz, "St:%d   ", strength);
display.setCursor(0,15);  //5,2
display.setTextColor( WHITE,BLACK); // white on black
display.print(sz);
display.display();
  // Wait some short time before taking the next measurement
  delay(25);   
}
